# Класс CGruLayer

<!-- TOC -->

- [Класс CGruLayer](#класс-cgrulayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов гейтов](#матрица-весов-гейтов)
        - [Свободные члены гейтов](#свободные-члены-гейтов)
        - [Матрица весов выхода](#матрица-весов-выхода)
        - [Свободные члены выхода](#свободные-члены-выхода)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой [GRU](https://en.wikipedia.org/wiki/Gated_recurrent_unit), применяющийся к набору последовательностей векторов.

Результатом операции является последовательность векторов той же длины, каждый вектор в которой имеет размер `GetHiddenSize()`.

## Настройки

## Обучаемые параметры

### Матрица весов гейтов

```c++
CPtr<CDnnBlob> GetGateWeightsData() const;
```

Матрица весов гейтов, представляющая собой [блоб](DnnBlob.md) размера:

- `BatchLength * BatchWidth * ListSize` равен `2 * GetHiddenSize()`;
- `Height * Width * Depth * Channels` равен сумме аналогичного размера входа и `GetHiddenSize()`.

Вдоль осей `BatchLength * BatchWidth * ListSize` матрица содержит веса гейтов в следующем порядке:

```c++
G_Update = 0, // Update gate
G_Reset,      // Reset gate
```

Вдоль оси `Height * Width * Depth * Channels` матрица содержит веса:

- от `0` до произведения размеров входа идут веса, которые перемножаются с векторами из входной последовательности;
- остальные `GetHiddenSize()` координат отвечают за веса, которые перемножаются с результатами прошлого шага.

### Свободные члены гейтов

```c++
CPtr<CDnnBlob> GetGateFreeTermData() const;
```

Свободные члены гейтов представляют собой блоб суммарного размера `2 * GetHiddenSize()`.

### Матрица весов выхода

```c++
CPtr<CDnnBlob> GetMainWeightsData() const;
```

Матрица весов выхода представляет собой блоб размера:

- `BatchLength * BatchWidth * ListSize` равен `GetHiddenSize()`;
- `Height * Width * Depth * Channels` равен сумме аналогичного размера входа и `GetHiddenSize()`.

### Свободные члены выхода

Свободные члены выхода представляют собой блоб суммарного размера `GetHiddenSize()`.

## Входы

Слой имеет от 1 до 2 входов:

1. Набор входных последовательностей векторов.
2. *[Опционально]* Начальное последнее возвращенное значение. Будет использовано в качестве последнего возвращенного значения перед первым шагом. Если вход не задан, то будет заполнено нулями.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength`, `BatchWidth` и `ListSize` равны соответствующим у первого входа;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` равен `GetHiddenSize()`.
