# Класс CFullyConnectedLayer

<!-- TOC -->

- [Класс CFullyConnectedLayer](#класс-cfullyconnectedlayer)
    - [Настройки](#настройки)
        - [Длина выходного вектора](#длина-выходного-вектора)
        - [Использование свободных членов](#использование-свободных-членов)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Матрица весов](#матрица-весов)
        - [Свободные члены](#свободные-члены)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует полносвязный слой. Этот слой умножает входной набор векторов на матрицу весов и прибавляет к результату свободные члены.

## Настройки

### Длина выходного вектора

```c++
void SetNumberOfElements(int newNumberOfElements);
```

Устанавливает длину векторов, которые должны получиться на выходе слоя.

### Использование свободных членов

```c++
void SetZeroFreeTerm(bool isZeroFreeTerm);
```

Указывает, нужно ли использовать вектор свободных членов. Если передать `true`, содержимое вектора будет заполнено нулями, и он не будет обучаться. По умолчанию `false`.

## Обучаемые параметры

### Матрица весов

```c++
CPtr<CDnnBlob> GetWeightsData() const;
```

Матрица весов представляет собой [блоб](DnnBlob.md) размера:

- `BatchLength * BatchWidth * ListSize` равен `GetNumberOfElements()`;
- `Height`, `Width`, `Depth` и `Channels` равны соответствующим размерностям первого входа.

### Свободные члены

```c++
CPtr<CDnnBlob> GetFreeTermData() const;
```

Свободные члены представляют собой блоб суммарного размера `GetNumberOfElements()`.

## Входы

На каждый вход подается блоб с набором векторов:

- `BatchLength * BatchWidth * ListSize` - количество векторов в наборе;
- `Height * Width * Depth * Channels` - длина векторов. Должна быть одинаковой для всех входов.

## Выходы

Для каждого входа соответствующий выход содержит блоб с результатами следующего размера:

- `BatchLength` равен `BatchLength` соответствующего входа;
- `BatchWidth` равен `BatchWidth` соответствующего входа;
- `ListSize` равен `ListSize` соответствующего входа;
- `Height`, `Width` и `Depth` равны `1`;
- `Channels` равен `GetNumberOfElements()`.
