# Класс CDropoutLayer

<!-- TOC -->

- [Класс CDropoutLayer](#класс-cdropoutlayer)
    - [Настройки](#настройки)
        - [Вероятность зануления](#вероятность-зануления)
        - [Зануление содержимого каналов целиком](#зануление-содержимого-каналов-целиком)
        - [Зануление одних и тех же элементов в батче](#зануление-одних-и-тех-же-элементов-в-батче)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, случайным образом зануляющий элементы блоба единственного входа.

При работе с блобами, имеющими размер `BatchLength` больше `1`, зануляет все элементы последовательностей одной и той же маской.

Зануление происходит только во время обучения сети. Когда вы запускаете сеть без обучения (например, на тестовой выборке для оценки результата), этот слой пропускает все элементы без изменений.

## Настройки

### Вероятность зануления

```c++
void SetDropoutRate( float value );
```

Установка вероятности зануления одного элемента.

### Зануление содержимого каналов целиком

```c++
void SetSpatial( bool value );
```

Установка режима `spatial`. Если он включен, то зануляться будут не отдельные элементы, а содержимое каналов целиком. Может быть полезно при использовании сверточных сетей. По умолчанию выключен.

### Зануление одних и тех же элементов в батче

```c++
void SetBatchwise( bool value );
```

Установка режима `batchwise`. Если он включен, то все объекты в блобе (`CDnnBlob::GetObjectCount`) будут зануляться одной и той же маской. Может быть полезно при больших размерах батча. По умолчанию выключен.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с данными произвольного размера.

## Выходы

Единственный выход содержит блоб того же размера. Если сеть обучается, то часть элементов будут занулены.
