# Класс CMultichannelLookupLayer

<!-- TOC -->

- [Класс CMultichannelLookupLayer](#класс-cmultichannellookuplayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, сопоставляющий значениям дискретных признаков векторы фиксированной длины и обучающий эти векторы.

Например, векторные представления слов ([Word2Vec](https://en.wikipedia.org/wiki/Word2vec), [GloVe](https://en.wikipedia.org/wiki/GloVe_(machine_learning)) и т.д.).

Один слой поддерживает работу одновременно с несколькими такими таблицами векторов, каждая из которых соответствует своему признаку.

## Настройки

```c++
// Размер одной таблицы.
struct CLookupDimension {
    int VectorCount; // Количество векторов.
    int VectorSize; // Размер векторов.
};

void SetDimensions(const CArray<CLookupDimension>&);
```

Задать массив размеров наборов векторов в слое. Размер массива задает количество наборов, и каждый элемент задает размер и число векторов в соответствующем наборе.

## Обучаемые параметры

```c++
const CDnnBlob& GetEmbeddings(int i) const;
```

Слой обучает наборы векторов. `i`-й набор представляет собой [блоб](DnnBlob.md) размера

- `BatchLength * BatchWidth * ListSize` равный `GetDimensions()[i].VectorCount`
- `Height * Width * Depth * Channels` равный `GetDimensions()[i].VectorSize`

## Входы

Слой поддерживает несколько входов.
На каждый вход подается блоб, который содержит наборы признаков в виде `float` или `int` и имеет размеры

- `BatchLength * BatchWidth * ListSize * Height * Width * Depth` - количество признаков в наборе;
- `Channels` - размерность, вдоль которой записываются значения признаков для разных наборов, должна быть не меньше чем число наборов.

## Выходы
Количество выходов равно количеству входов.
Каждый выход слоя содержит блоб с результатами следующего размера

- `BatchLength`, `BatchWidth`, `ListSize`, `Height`, `Width`, `Depth` равны аналогичным у входного блоба;
- `Channels` равен сумме длин векторов всех наборов и дополнительных каналов в случае, когда `Channels` входа больше количества таблиц в слое.
