# Класс CDepthToSpaceLayer

<!-- TOC -->

- [Класс CDepthToSpaceLayer](#класс-cdepthtospacelayer)
    - [Настройки](#настройки)
        - [Размер блока](#размер-блока)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, трансформирующий каждый пиксель (`1 x 1 x Ch`) двумерных изображений в блок `k x k x Ch/(k*k)`.
Содержимое пикселя интерпретируется как изображение размера `k x k x Ch/(k*k)` в порядке channel-last.
В результате изображения размера `H x W x Ch` трансформируются в изображения размера `H*k x W*k x Ch/(k*k)`.

Является обратной операцией [CSpaceToDepthLayer](SpaceToDepthLayer.md).

## Настройки

### Размер блока

```c++
void SetBlockSize( int blockSize );
```

Установка размера блоков (`k` из описания слоя). Количество каналов у изображений должно быть кратно квадрату этого значения. Число должно быть больше `1`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подаётся блоб с набором изображений размера:

- `BatchLength * BatchWidth * ListSize` - количество изображений в наборе;
- `Height` - высота изображений;
- `Width` - ширина изображений;
- `Depth` равен `1`;
- `Channels` - количество каналов у изображений; должно быть кратно `GetBlockSize() * GetBlockSize()`.

## Выходы

Единственный выход содержит блоб с результатами размера:

- `BatchLength` равен `BatchLength` входа;
- `BatchWidth` равен `BatchWidth` входа;
- `ListSize` равен `ListSize` входа;
- `Height` равен `Height * GetBlockSize()` входа;
- `Width` равен `Width * GetBlockSize()` входа;
- `Depth` равен `1`;
- `Channels` равен `Channels / ( GetBlockSize() * GetBlockSize() )` входа.
