# Класс CCtcLossLayer

<!-- TOC -->

- [Класс CCtcLossLayer](#класс-cctclosslayer)
    - [Настройки](#настройки)
        - [Пробел между метками](#пробел-между-метками)
        - [Игнорирование пробелов](#игнорирование-пробелов)
        - [Вес функции ошибки](#вес-функции-ошибки)
        - [Урезание градиентов](#урезание-градиентов)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)
        - [Значение функции потерь](#значение-функции-потерь)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию потерь используемую для [CTC](README.md).

## Настройки

### Пробел между метками

```c++
void SetBlankLabel( int blankLabel );
```

Установка значения метки, которая будет интерпретироваться как пробел между другими метками.

### Игнорирование пробелов

```c++
void SetAllowBlankLabelSkips( bool enabled );
```

Установка флага, допускающего пропуск пробелов при выравнивании.

### Вес функции ошибки

```c++
void SetLossWeight( float lossWeight );
```

Установка коэффициента, на который будут домножаться градиенты этой функции потерь при обучении. По умолчанию `1`. Полезен при использовании нескольких функций потерь в одной сети.

### Урезание градиентов

```c++
void SetMaxGradientValue( float maxValue );
```

Установка максимального значения элемента в градиенте. Все значения градиента, по модулю превосходящие `GetMaxGradientValue()` будут приведены к значениям, равным по модулю `GetMaxGradientValue()`.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

Слой имеет от двух до пяти входов.

1. На первый вход подаётся блоб с ответами сети размера:
    * `BatchLength` - максимальная длина последовательности ответов
    * `BatchWidth` - количество последовательностей в наборе
    * `ListSize` равен `1`
    * `Height * Width * Depth * Channels` - количество классов
2. На второй вход подаётся блоб с данными типа `int`, содержащий правильные ответы, размера:
    * `BatchLength` - максимальная длина последовательности меток
    * `BatchWidth` - количество последовательностей в наборе, должен быть равен `BatchWidth` блоба из первого входа
    * остальные размерности равны `1`
3. *[Опционально]* На третий вход подаётся блоб с данными типа `int`, содержащий длины последовательностей меток. Если этого входа нет, то считается, что длины всех последовательностей правильных меток равны `BatchLength` блоба из второго входа. Блоб должен иметь следующий размер:
    * `BatchWidth` должен быть равен `BatchWidth` блоба из первого входа
    * остальные размерности равны `1`
4. *[Опционально]* На четвертый вход подаётся блоб с данными типа `int`, содержащий длины последовательностей ответов сети. Если этого входа нет, то считается, что длины всех последовательностей ответов сети равны `BatchLength` блоба из первого входа. Блоб должен иметь следующий размер:
    * `BatchWidth` должен быть равен `BatchWidth` блоба из первого входа
    * остальные размерности равны `1`
5. *[Опционально]* На пятый вход подаётся блоб, содержащий веса последовательностей в наборе, размера:
    * `BatchWidth` должен быть равен `BatchWidth` блоба из первого входа
    * остальные размерности равны `1`

## Выходы

Слой не имеет выходов.

### Значение функции потерь

```c++
float GetLastLoss() const;
```

Получение значения функции потерь на последнем запуске сети.
