# Класс CCrfLayer

<!-- TOC -->

- [Класс CCrfLayer](#класс-ccrflayer)
    - [Настройки](#настройки)
        - [Число классов в CRF](#число-классов-в-crf)
        - [Пустой класс](#пустой-класс)
        - [Variational dropout](#variational-dropout)
        - [Вычисление выхода O_BestPrevClass](#вычисление-выхода-O_BestPrevClass)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, обучающий вероятности и вычисляющий вероятности в условном случайном поле.

## Настройки

### Число классов в CRF

```c++
void SetNumberOfClasses( int numberOfClasses );
```

### Пустой класс

```c++
void SetPaddingClass( int paddingClass );
```

Установка номера пустого класса, которым заполняются концы последовательностей.

### Variational dropout

```c++
void SetDropoutRate( float newDropoutRate );
```

### Вычисление выхода O_BestPrevClass

```c++
void SetBestPrevClassEnabled( bool enabled );
```

Включение вычисления первого выхода (O_BestPrevClass), содержащего оптимальные последовательности классов, во время обучения.
Позволяет подключить к `CCrfLayer` слой [CBestSequenceLayer](BestSequenceLayer.md) и получать предсказания на каждый батч прямо во время обучения.
По-умолчанию выключено.
Во время применения этот выход вычисляется в любом случае, а данная настройка игнорируется.

## Обучаемые параметры

В рамках слоя обучает вероятности условного случайного поля, однако методы для их получения отсутствуют.

## Входы

Слой имеет один или два входа.

На первый вход подаётся блоб с набором последовательностей объектов, размера:

- `BatchLength` - длина последовательностей;
- `BatchWidth` - количество последовательностей в наборе;
- `ListSize` равен `1`;
- `Height * Width * Depth * Channels` - размер объекта.

*[Опционально]* На второй вход подаётся блоб с данными типа `int` содержащий правильные последовательности классов. Необходим при обучении. Блоб должен иметь размеры:

- `BatchLength` равен `BatchLength` первого входа;
- `BatchWidth` равен `BatchWidth` первого входа;
- остальные размерности равны `1`.

## Выходы

Слой имеет два или три выхода.

Первый выход содержит блоб с данными типа `int`, с оптимальными последовательностями классов. Блоб имеет размеры:

- `BatchLength` равен `BatchLength` входов;
- `BatchWidth` равен `BatchWidth` входов;
- `Channels` равен `GetNumberOfClasses()`;
- остальные размерности равны `1`.

Второй выход содержит блоб с данными типа `float`, содержащий ненормализованные логарифмы вероятностей оптимальных последовательностей классов. Блоб имеет те же размеры, что и у первого выхода.

*[Опционально]* Третий выход имеется только в том случае, когда у слоя два входа. Этот выход содержит блоб с ненормализованными логарифмами вероятностей эталонного класса. Блоб имеет размеры:

- `BatchLength` равен `BatchLength` входов;
- `BatchWidth` равен `BatchWidth` входов;
- остальные размерности равны `1`.

Извлечение оптимальной последовательности из первых двух выходов реализовано в [CBestSequenceLayer](BestSequenceLayer.md).
