# Класс CTimeConvLayer

<!-- TOC -->

- [Класс CTimeConvLayer](#класс-ctimeconvlayer)
    - [Настройки](#настройки)
        - [Размеры фильтров](#размеры-фильтров)
        - [Шаг свертки](#шаг-свертки)
        - [Дополнительные столбцы и колонки (padding)](#дополнительные-столбцы-и-колонки-padding)
        - [Разреженная свертка](#разреженная-свертка)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Фильтры](#фильтры)
        - [Свободные члены](#свободные-члены)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, выполняющий операцию свертки "по времени" над набором последовательностей. Поддерживает `padding` и `dilated convolution`.

## Настройки

### Размеры фильтров

```c++
void SetFilterSize( int filterSize );
void SetFilterCount( int filterCount );
```

Устанавливает количество и размеры фильтров.

### Шаг свертки

```c++
void SetStride( int stride );
```

Устанавливает шаг свёртки. По умолчанию это значение равно `1`.

### Дополнительные столбцы и колонки (padding)

```c++
void SetPaddingFront( int padding );
```

Устанавливает количество дополнительных нулевых элементов в начале последовательности. По умолчанию равно `0`.

```c++
void SetPaddingBack( int padding );
```

Устанавливает количество дополнительных нулевых элементов на конце последовательности. По умолчанию равно `0`.

### Разреженная свертка

```c++
void SetDilation( int dilation );
```

Поддержка "разреженных" сверток. Это случаи, когда соседние элементы фильтра сворачивают не соседние элементы исходной последовательности, а элементы на расстоянии `dilation`. По умолчанию равен `1`, что соответствует неразреженной свертке.

## Обучаемые параметры

### Фильтры

```c++
CPtr<CDnnBlob> GetFilterData() const;
```

Фильтры представляют собой [блоб](../DnnBlob.md) размера

- `BatchLength` равен `1`;
- `BatchWidth` равен `GetFilterCount()`;
- `Height` равен `GetFilterSize()`;
- `Width` равен `1`;
- `Depth` равен `1`;
- `Channels` равен `Height * Width * Depth * Channels` у входов.

### Свободные члены

```c++
CPtr<CDnnBlob> GetFreeTermData() const;
```

Свободные члены представляют собой блоб, имеющий суммарный размер `GetFilterCount()`.

## Входы

На каждый вход подается блоб с набором последовательностей:

- `BatchLength` - длина последовательностей;
- `BatchWidth * ListSize` - количество последовательностей в наборе;
- `Height * Width * Depth * Channels` - размер элемента последовательностей.

Размеры блобов всех входов должны совпадать.

## Выходы

Для каждого входа соответствующий выход содержит блоб с результатом свертки.

Блоб с результатами имеет следующие размеры:

- `BatchLength` можно вычислить, исходя из размеров входа, по формуле  
`(2 * Padding + BatchLength - (1 + Dilation * (FilterSize - 1)))/Stride + 1`;
- `BatchWidth` равен `BatchWidth` входа;
- `ListSize` равен `ListSize` входа;
- `Height` равен `1`;
- `Width` равен `1`;
- `Depth` равен `1`;
- `Channels` равен `GetFilterCount()`.
