# Класс CBatchNormalizationLayer

<!-- TOC -->

- [Класс CBatchNormalizationLayer](#класс-cbatchnormalizationlayer)
    - [Настройки](#настройки)
        - [Поканальный режим](#поканальный-режим)
        - [Скорость сходимости](#скорость-сходимости)
    - [Обучаемые параметры](#обучаемые-параметры)
        - [Итоговые значения](#итоговые-значения)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, вычисляющий батч нормализацию по формуле:

```c++
bn(x)[i][j] = ((x[i][j] - mean[j]) / sqrt(var[j])) * gamma[j] + beta[j]
```

где:

- `gamma` и `beta` - обучаемые параметры;
- `mean` и `var` зависят от того, обучается ли сейчас слой:
	- Если слой обучается, то `mean[j]` и `var[j]` - это среднее значение и дисперсия данных `x` в координате `j` относительно всех `i`.
	- Если слой не обучается, то `mean[j]` и `var[j]` - это посчитанные за время обучения экспоненциальное скользящее среднее и несмещенная оценка дисперсии.

## Настройки

### Поканальный режим

```c++
void SetChannelBased( bool isChannelBased );
```

Использование статистики по каналам. 

Если этот режим **включен**, `mean`, `var`, `gamma` и `beta` из формулы будут представлять собой вектора длины равной числу каналов у входа. А координата `i` будет перебирать все значения от `0` до `BatchLength * BatchWidth * ListSize * Height * Width * Depth - 1`.

Если **не используется**, то вектора `mean`, `var`, `gamma` и `beta` имеют длину `Height * Width * Depth * Channels`. А координата `i` будет перебирать все значения от `0` до `BatchLength * BatchWidth * ListSize - 1`.

По умолчанию **включен**.

### Скорость сходимости

```c++
SetSlowConvergenceRate( float rate );
```

Установка коэффициента, используемого при подсчете экспоненциального скользящего среднего и дисперсии.

## Обучаемые параметры

### Итоговые значения

```c++
CPtr<CDnnBlob> GetFinalParams();
```

Получение итоговых коэффициентов. Представляет собой блоб размера:

- `BatchLength` равен `1`;
- `BatchWidth` равен `2`;
- `ListSize` равен `1`;
- `Height` равен `1` если `IsChannelBased()` и `Height` входа в ином случае;
- `Width` равен `1` если `IsChannelBased()` и `Width` входа в ином случае;
- `Depth` равен `1` если `IsChannelBased()` и `Depth` входа в ином случае;
- `Channels` равен `1`.

В первом объекте блоба (координата `BatchWidth` равна `0`) содержатся множители, равные `gamma[j] / sqrt(var[j])`.

Во втором объекте блоба (координата `BatchWidth` равна `1`) содержатся слагаемые, равные `beta[j] - mean[j] * gamma[j] / sqrt(var[j])`.

Таким образом формула батч нормализации заменяется на `bn(x)[i][j] = x[i][j] * finalParams[0][j] + finalParams[1][j]`.

## Входы

На единственный вход подается блоб произвольного размера.

## Выходы

Единственный выход содержит блоб с результатами работы слоя.
