# Класс CReLULayer

<!-- TOC -->

- [Класс CReLULayer](#класс-crelulayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию активации `ReLU` для каждого элемента единственного входа.

По умолчанию имеет формулу:

```c++
f(x) = 0    при x <= 0
f(x) = x    при x > 0
```

Также слой поддерживает задание верхней границы значений (threshold). В таком случае функция приобретает вид:

```c++
f(x) = 0            при x <= 0
f(x) = x            при 0 < x < threshold
f(x) = threshold    при threshold <= x
```

## Настройки

```c++
void SetUpperThreshold( float threshold );
```

Установка верхней границы значений. По умолчанию не установлена, функция не ограничена сверху.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с данными произвольного размера.

## Выходы

Единственный выход содержит блоб тех же размеров, что и вход, с результатами функции над его элементами.