# Класс CLinearLayer

<!-- TOC -->

- [Класс CLinearLayer](#класс-clinearlayer)
    - [Настройки](#настройки)
        - [Множитель](#множитель)
        - [Свободный член](#свободный-член)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, вычисляющий линейную функцию активации для каждого элемента единственного входа.

Имеет формулу:

```c++
f(x) = GetMultiplier() * x + GetFreeTerm()
```

## Настройки

### Множитель

```c++
void SetMultiplier( float multiplier );
```

Установка множителя в функции активации.

### Свободный член

```c++
void SetFreeTerm( float freeTerm );
```

Установка свободного члена в функции активации.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с данными произвольного размера.

## Выходы

Единственный выход содержит блоб тех же размеров, что и вход, с результатами функции над его элементами.
