# Класс CGELULayer

<!-- TOC -->

- [Класс CGELULayer](#класс-cgelulayer)
    - [Настройки](#настройки)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, выполняющий функцию активации `GELU` над каждым элементом единственного входа.

Имеет формулу точного вычисления:
```c++
f(x) = x * 0.5 * ( 1 + erf( x / sqrt( 2 ) ) )
```

Приближенное вычисление:
```c++
f(x) = x * sigmoid( 1.702 * x )
```

## Настройки

Использовать ли точное вычисление (TCalculationMode::Precise) или более быстрое приближенное (TCalculationMode::SigmoidApproximate).
```c++
void SetCalculationMode( TCalculationMode );
```

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с данными произвольного размера.

## Выходы

Единственный выход содержит блоб тех же размеров, что и вход, с результатами функции над его элементами.
