# Класс CELULayer

<!-- TOC -->

- [Класс CELULayer](#класс-CELULayer)
    - [Настройки](#настройки)
        - [Множитель](#множитель)
    - [Обучаемые параметры](#обучаемые-параметры)
    - [Входы](#входы)
    - [Выходы](#выходы)

<!-- /TOC -->

Класс реализует слой, вычисляющий функцию активации `ELU` для каждого элемента единственного входа.

Имеет формулу:

```c++
f(x) = GetAlpha() * (exp(x) - 1)    при x < 0
f(x) = x                            при x >= 0
```

## Настройки

### Множитель

```c++
void SetAlpha( float alpha );
```

Установка множителя экспоненты в случае отрицательного аргумента.

## Обучаемые параметры

Слой не имеет обучаемых параметров.

## Входы

На единственный вход подается блоб с данными произвольного размера.

## Выходы

Единственный выход содержит блоб тех же размеров, что и вход, с результатами функции над его элементами.
