# Метод k-средних CKMeansClustering

<!-- TOC -->

- [Метод k-средних CKMeansClustering](#метод-k-средних-ckmeansclustering)
	- [Параметры](#параметры)
	- [Пример](#пример)

<!-- /TOC -->

Метод k-средних (*k-means*) — наиболее популярный метод кластеризации.

Основная идея заключается в том, что на каждой итерации заново вычисляется центр масс для каждого кластера, полученного на предыдущем шаге, а затем векторы разбиваются на новые кластеры в соответствии с тем,
какой из новых центров оказался ближе по выбранной метрике. 

Алгоритм завершает работу, когда на какой-то итерации не происходит изменения внутрикластерного расстояния. Это произойдёт за конечное число итераций, так как количество возможных разбиений конечного множества конечно, а на каждом шаге суммарное квадратичное отклонение уменьшается.

В **NeoML** алгоритм реализован классом `CKMeansClustering`, который предоставляет интерфейс `IClustering`. Кластеризация производится с помощью его метода `Clusterize`.

## Параметры

Параметры кластеризации описываются структурой `CKMeansClustering::CParam`.

- *Algo* - используемый алгоритм;
- *DistanceFunc* — используемая функция расстояния;
- *InitialClustersCount* — начальное количество кластеров: при создании кластеризатора вы можете передать в конструктор массив длины *InitialClustersCount* с центрами кластеров, которые должны использоваться на первой итерации алгоритма; в противном случае на первой итерации в качестве центров будут взяты случайные элементы входных данных;
- *Initialization* - используемый алгоритм инициализации;
- *MaxIterations* — максимальное количество итераций алгоритма;
- *Tolerance* - критерий остановки для алгоритма Elkan;
- *ThreadCount* - количество потоков, используемых во время работы алгоритма;
- *RunCount* - количество запусков алгоритма, в итоге будет возвращен результат с наименьшей инерцией кластеров;
- *Seed* - `seed` для генерации случайных чисел.

## Пример

В данном примере алгоритм k-средних используется для кластеризации набора данных [Iris Data Set](http://archive.ics.uci.edu/ml/datasets/Iris):

```c++
void Clusterize( const IClusteringData& irisDataSet, CClusteringResult& result )
{
	CKMeansClustering::CParam params;
	params.Algorithm = CKMeansClustering::KMA_Lloyd;
	params.DistanceFunc = DF_Euclid;
	params.InitialClustersCount = 3;
	params.Initialization = CKMeansClustering::KMI_Default;
	params.MaxIterations = 50;
	// params.Tolerance можно опустить т.к. он не используется алгоритмом Lloyd

	CKMeansClustering kMeans( params );
	kMeans.Clusterize( irisDataSet, result );
}
```