# Решение задач классификации и регрессии

<!-- TOC -->

- [Решение задач классификации и регрессии](#решение-задач-классификации-и-регрессии)
	- [Алгоритмы](#алгоритмы)
		- [Градиентный бустинг деревьев](#градиентный-бустинг-деревьев)
		- [Линейный классификатор](#линейный-классификатор)
		- [Машина опорных векторов](#машина-опорных-векторов)
		- [Дерево решений](#дерево-решений)
		- [Классификация методом один против всех](#классификация-методом-один-против-всех)
	- [Вспомогательные интерфейсы](#вспомогательные-интерфейсы)
		- [Интерфейс задачи](#интерфейс-задачи)
		- [Интерфейсы для обучения](#интерфейсы-для-обучения)
		- [Интерфейсы обученных моделей](#интерфейсы-обученных-моделей)
		- [Результат классификации](#результат-классификации)

<!-- /TOC -->

Библиотека **NeoML** предоставляет различные методы решения задач классификации и регрессии.

## Алгоритмы

### Градиентный бустинг деревьев

Градиентный бустинг строит ансамбль деревьев, предназначенных для решения задач классификации и регрессии. Построение ансамбля из нескольких деревьев производится итеративно. Для построения каждого дерева используется некоторое случайное подмножество элементов выборки и случайное подмножество признаков.

В **NeoML** градиентный бустинг реализован классом [CGradientBoost](GradientBoost.md), а обученные им модели реализуют интерфейсы `IGradientBoostModel` и `IGradientBoostRegressionModel` для классификации и регрессии соответственно.

### Линейный классификатор

Бинарный линейный классификатор — алгоритм классификации, основанный на построении линейной разделяющей поверхности, которая делит пространство признаков на два полупространства. 

В **NeoML** реализован классом [CLinear](Linear.md). Этот класс позволяет обучить модели `ILinearBinaryModel` или [`IOneVersusAllModel`](OneVersusAll.md#model) для классификации и `ILinearRegressionModel` для линейной регрессии.

### Машина опорных векторов

Метод опорных векторов переводит исходные вектора в пространство более высокой размерности и ищет в нем разделяющую гиперплоскость с максимальным зазором. 

В **NeoML** реализован классом [CSvm](Svm.md). В зависимости от используемого ядра, обученная модель будет представлена интерфейсом [`ILinearBinaryModel`](Linear.md#for-classification), `ISvmBinaryModel` или [`IOneVersusAllModel`](OneVersusAll.md#model).

### Дерево решений

Метод дерева решений представляет собой классификацию на основе последовательного сравнения признаков данного объекта с некоторыми пороговыми значениями. На основе результата сравнения можно попасть в одну из дочерних вершин, и так далее, до тех пор, пока не будет достигнута листовая вершина, в которой производится окончательная классификация.

Дерево решений в **NeoML** реализовано классом [CDecisionTree](DecisionTree.md), а обученная им модель предоставляет интерфейс `IDecisionTreeModel` или [`IOneVersusAllModel`](OneVersusAll.md#model) в зависимости от количества классов в датасете и режима мультиклассовой классификации.

### Классификация методом один против всех

Чтобы решить задачу многоклассовой классификации с помощью набора бинарных классификаторов, можно прибегнуть к методу "один против всех".

В **NeoML** реализован классом [COneVersusAll](OneVersusAll.md). Обученная модель для многоклассовой классификации реализует интерфейс `IOneVersusAllModel`.

### Классификация методом один против одного

Чтобы решить задачу многоклассовой классификации с помощью набора бинарных классификаторов, можно прибегнуть к методу "один против одного".

В **NeoML** реализован классом [COneVersusOne](OneVersusOne.md). Обученная модель реализует интерфейс `IModel`.

## Вспомогательные интерфейсы

Все построители моделей классификации реализуют общий интерфейс, получают данные в одном формате и создают модели, к которым также можно обращаться через один интерфейс.

### Интерфейс задачи

Построители моделей получают на вход данные для обучения в виде указателя на объект, реализующий один из интерфейсов:

- `IProblem` — для классификации;
- `IRegressionProblem` — для задачи регрессии скалярнозначной функции;
- `IMultivariateProblem` — для задачи регрессии векторнозначной функции.

Более детально эти интерфейсы описаны [тут](Problems.md).

### Интерфейсы для обучения

Все алгоритмы классификации реализуют интерфейс `ITrainingModel`; все алгоритмы регрессии — интерфейс `IRegressionTrainingModel`. [Подробнее...](TrainingModels.md)

### Интерфейсы обученных моделей

Обученные модели реализуют интерфейсы `IModel`, `IRegressionModel`, `IMultivariateRegressionModel`. См. [подробное описание](Models.md).

### Результат классификации

Результат классификации, который возвращают методы `Classify`, `ClassifyEx` обученных моделей, описывается структурой `CClassificationResult`.

```c++
struct NEOML_API CClassificationResult {
public:
	int PreferredClass;
	CClassificationProbability ExceptionProbability;
	CArray<CClassificationProbability> Probabilities;
};
```

- *PreferredClass* — номер класса, к которому классификатор отнёс входной объект;
- *ExceptionProbability* — вероятность того, что входной объект не принадлежит ни одному из классов;
- *Probabilities* — вероятности отнесения объекта к классам.
