# Многоклассовая классификация методом один против одного COneVersusOne

<!-- TOC -->

- [Многоклассовая классификация методом один против одного COneVersusOne](#многоклассовая-классификация-методом-один-против-одного-coneversusone)
	- [Параметры построения модели](#параметры-построения-модели)
	- [Модель](#модель)
	- [Результат классификации](#результат-классификации)
	- [Пример](#пример)

<!-- /TOC -->

Данный метод позволяет выполнить многоклассовую классификацию, имея только бинарный классификатор.

Метод заключается в преобразовании исходной многоклассовой задачи в набор бинарных задач для каждой пары классов. На этом наборе обучается соответствующее количество бинарных классификаторов.

После этого вероятности принадлежности объектов к каждому из классов ищутся путем решения оптимизационной задачи, описанной в Section 4 [данной статьи](https://www.csie.ntu.edu.tw/~cjlin/papers/svmprob/svmprob.pdf).

В **NeoML** алгоритм реализован классом `COneVersusOne`. Он предоставляет метод `Train` для обучения модели классификации.

## Параметры построения модели

Алгоритм имеет только один параметр — указатель на базовый метод бинарной классификации, который должен быть представлен объектом, реализующим [ITrainingModel](TrainingModels.md).

## Модель

Модель, обученная данным методом, представляет собой ансамбль бинарных моделей. Построенная модель реализует [интерфейс `IModel`](Models.md#для-классификации).

## Результат классификации

Модель классификации "один против одного" предоставляет стандартный метод `Classify`, который записывает результат в переданный ему [`CClassificationResult`](README.md#результат-классификации).

## Пример

Ниже представлен простой пример обучения модели на базе линейного бинарного классификатора.

```c++
CLinear linear( EF_LogReg );

COneVersusOne oneVersusOne( linear );
CPtr<IModel> model = oneVersusOne.Train( *trainData );
```
