<?php

/*
 * SnapeBot, PHP Framework for Telegram Bots
 * Copyright (C) 2019 Enea Dolcini
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace neneone\SnapeBot;

class BotAPI
{
    public function __construct($token)
    {
        $this->token = $token;
    }

    public function __call($name, $args)
    {
        $methodsList = json_decode('{"getUpdates":[{"name":"offset","required":false},{"name":"limit","required":false},{"name":"timeout","required":false},{"name":"allowed_updates","required":false}],"setWebhook":[{"name":"url","required":true},{"name":"certificate","required":false},{"name":"max_connections","required":false},{"name":"allowed_updates","required":false}],"deleteWebhook":[{"name":"url","required":false},{"name":"has_custom_certificate","required":false},{"name":"pending_update_count","required":false},{"name":"last_error_date","required":false},{"name":"last_error_message","required":false},{"name":"max_connections","required":false},{"name":"allowed_updates","required":false}],"getWebhookInfo":[{"name":"url","required":false},{"name":"has_custom_certificate","required":false},{"name":"pending_update_count","required":false},{"name":"last_error_date","required":false},{"name":"last_error_message","required":false},{"name":"max_connections","required":false},{"name":"allowed_updates","required":false}],"getMe":[{"name":"chat_id","required":true},{"name":"text","required":true},{"name":"parse_mode","required":false},{"name":"disable_web_page_preview","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendMessage":[{"name":"chat_id","required":true},{"name":"text","required":true},{"name":"parse_mode","required":false},{"name":"disable_web_page_preview","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"forwardMessage":[{"name":"chat_id","required":true},{"name":"from_chat_id","required":true},{"name":"disable_notification","required":false},{"name":"message_id","required":true}],"sendPhoto":[{"name":"chat_id","required":true},{"name":"photo","required":true},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendAudio":[{"name":"chat_id","required":true},{"name":"audio","required":true},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"duration","required":false},{"name":"performer","required":false},{"name":"title","required":false},{"name":"thumb","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendDocument":[{"name":"chat_id","required":true},{"name":"document","required":true},{"name":"thumb","required":false},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendVideo":[{"name":"chat_id","required":true},{"name":"video","required":true},{"name":"duration","required":false},{"name":"width","required":false},{"name":"height","required":false},{"name":"thumb","required":false},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"supports_streaming","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendAnimation":[{"name":"chat_id","required":true},{"name":"animation","required":true},{"name":"duration","required":false},{"name":"width","required":false},{"name":"height","required":false},{"name":"thumb","required":false},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendVoice":[{"name":"chat_id","required":true},{"name":"voice","required":true},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"duration","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendVideoNote":[{"name":"chat_id","required":true},{"name":"video_note","required":true},{"name":"duration","required":false},{"name":"length","required":false},{"name":"thumb","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendMediaGroup":[{"name":"chat_id","required":true},{"name":"media","required":true},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false}],"sendLocation":[{"name":"chat_id","required":true},{"name":"latitude","required":true},{"name":"longitude","required":true},{"name":"live_period","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"editMessageLiveLocation":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"latitude","required":true},{"name":"longitude","required":true},{"name":"reply_markup","required":false}],"stopMessageLiveLocation":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"reply_markup","required":false}],"sendVenue":[{"name":"chat_id","required":true},{"name":"latitude","required":true},{"name":"longitude","required":true},{"name":"title","required":true},{"name":"address","required":true},{"name":"foursquare_id","required":false},{"name":"foursquare_type","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendContact":[{"name":"chat_id","required":true},{"name":"phone_number","required":true},{"name":"first_name","required":true},{"name":"last_name","required":false},{"name":"vcard","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendPoll":[{"name":"chat_id","required":true},{"name":"question","required":true},{"name":"options","required":true},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"sendChatAction":[{"name":"chat_id","required":true},{"name":"action","required":true}],"getUserProfilePhotos":[{"name":"user_id","required":true},{"name":"offset","required":false},{"name":"limit","required":false}],"getFile":[{"name":"file_id","required":true}],"kickChatMember":[{"name":"chat_id","required":true},{"name":"user_id","required":true},{"name":"until_date","required":false}],"unbanChatMember":[{"name":"chat_id","required":true},{"name":"user_id","required":true}],"restrictChatMember":[{"name":"chat_id","required":true},{"name":"user_id","required":true},{"name":"permissions","required":true},{"name":"until_date","required":false}],"promoteChatMember":[{"name":"chat_id","required":true},{"name":"user_id","required":true},{"name":"can_change_info","required":false},{"name":"can_post_messages","required":false},{"name":"can_edit_messages","required":false},{"name":"can_delete_messages","required":false},{"name":"can_invite_users","required":false},{"name":"can_restrict_members","required":false},{"name":"can_pin_messages","required":false},{"name":"can_promote_members","required":false}],"setChatPermissions":[{"name":"chat_id","required":true},{"name":"permissions","required":true}],"exportChatInviteLink":[{"name":"chat_id","required":true}],"setChatPhoto":[{"name":"chat_id","required":true},{"name":"photo","required":true}],"deleteChatPhoto":[{"name":"chat_id","required":true}],"setChatTitle":[{"name":"chat_id","required":true},{"name":"title","required":true}],"setChatDescription":[{"name":"chat_id","required":true},{"name":"description","required":false}],"pinChatMessage":[{"name":"chat_id","required":true},{"name":"message_id","required":true},{"name":"disable_notification","required":false}],"unpinChatMessage":[{"name":"chat_id","required":true}],"leaveChat":[{"name":"chat_id","required":true}],"getChat":[{"name":"chat_id","required":true}],"getChatAdministrators":[{"name":"chat_id","required":true}],"getChatMembersCount":[{"name":"chat_id","required":true}],"getChatMember":[{"name":"chat_id","required":true},{"name":"user_id","required":true}],"setChatStickerSet":[{"name":"chat_id","required":true},{"name":"sticker_set_name","required":true}],"deleteChatStickerSet":[{"name":"chat_id","required":true}],"answerCallbackQuery":[{"name":"callback_query_id","required":true},{"name":"text","required":false},{"name":"show_alert","required":false},{"name":"url","required":false},{"name":"cache_time","required":false}],"editMessageText":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"text","required":true},{"name":"parse_mode","required":false},{"name":"disable_web_page_preview","required":false},{"name":"reply_markup","required":false}],"editMessageCaption":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"caption","required":false},{"name":"parse_mode","required":false},{"name":"reply_markup","required":false}],"editMessageMedia":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"media","required":true},{"name":"reply_markup","required":false}],"editMessageReplyMarkup":[{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false},{"name":"reply_markup","required":false}],"stopPoll":[{"name":"chat_id","required":true},{"name":"message_id","required":true},{"name":"reply_markup","required":false}],"deleteMessage":[{"name":"chat_id","required":true},{"name":"message_id","required":true}],"sendSticker":[{"name":"chat_id","required":true},{"name":"sticker","required":true},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"getStickerSet":[{"name":"name","required":true}],"uploadStickerFile":[{"name":"user_id","required":true},{"name":"png_sticker","required":true}],"createNewStickerSet":[{"name":"user_id","required":true},{"name":"name","required":true},{"name":"title","required":true},{"name":"png_sticker","required":true},{"name":"emojis","required":true},{"name":"contains_masks","required":false},{"name":"mask_position","required":false}],"addStickerToSet":[{"name":"user_id","required":true},{"name":"name","required":true},{"name":"png_sticker","required":true},{"name":"emojis","required":true},{"name":"mask_position","required":false}],"setStickerPositionInSet":[{"name":"sticker","required":true},{"name":"position","required":true}],"deleteStickerFromSet":[{"name":"sticker","required":true}],"answerInlineQuery":[{"name":"inline_query_id","required":true},{"name":"results","required":true},{"name":"cache_time","required":false},{"name":"is_personal","required":false},{"name":"next_offset","required":false},{"name":"switch_pm_text","required":false},{"name":"switch_pm_parameter","required":false}],"sendInvoice":[{"name":"chat_id","required":true},{"name":"title","required":true},{"name":"description","required":true},{"name":"payload","required":true},{"name":"provider_token","required":true},{"name":"start_parameter","required":true},{"name":"currency","required":true},{"name":"prices","required":true},{"name":"provider_data","required":false},{"name":"photo_url","required":false},{"name":"photo_size","required":false},{"name":"photo_width","required":false},{"name":"photo_height","required":false},{"name":"need_name","required":false},{"name":"need_phone_number","required":false},{"name":"need_email","required":false},{"name":"need_shipping_address","required":false},{"name":"send_phone_number_to_provider","required":false},{"name":"send_email_to_provider","required":false},{"name":"is_flexible","required":false},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"answerShippingQuery":[{"name":"shipping_query_id","required":true},{"name":"ok","required":true},{"name":"shipping_options","required":false},{"name":"error_message","required":false}],"answerPreCheckoutQuery":[{"name":"pre_checkout_query_id","required":true},{"name":"ok","required":true},{"name":"error_message","required":false}],"setPassportDataErrors":[{"name":"user_id","required":true},{"name":"errors","required":true}],"sendGame":[{"name":"chat_id","required":true},{"name":"game_short_name","required":true},{"name":"disable_notification","required":false},{"name":"reply_to_message_id","required":false},{"name":"reply_markup","required":false}],"setGameScore":[{"name":"user_id","required":true},{"name":"score","required":true},{"name":"force","required":false},{"name":"disable_edit_message","required":false},{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false}],"getGameHighScores":[{"name":"user_id","required":true},{"name":"chat_id","required":false},{"name":"message_id","required":false},{"name":"inline_message_id","required":false}]}', true);
        if (array_key_exists($name, $methodsList)) {
            if (is_array($args[0])) {
                return $this->BotAPI($name, $args[0]);
            }
            $argsAPI = [];
            $i = 0;
            foreach ($methodsList[$name] as $field) {
                $argsAPI[$field['name']] = $args[$i];
                $i++;
            }
            return $this->BotAPI($name, $argsAPI);
        } else {
            throw new \neneone\neneone\Exception('Method not found');
        }
    }

    public function BotAPI($method, $args = [])
    {
        $ch = curl_init();
        $ch_options = [
      CURLOPT_URL => 'https://api.telegram.org/bot'.$this->token.'/'.$method,
      CURLOPT_POST => true,
      CURLOPT_POSTFIELDS => http_build_query($args),
      CURLOPT_RETURNTRANSFER => true,
    ];
        curl_setopt_array($ch, $ch_options);
        $result = curl_exec($ch);
        curl_close($ch);

        return json_decode($result, true);
    }
}
