import type { SVGProps } from "react";

interface Props extends SVGProps<SVGSVGElement> {}

const Logo = (props: Props) => (
	<svg
		width="1em"
		height="1em"
		viewBox="0 0 928 751"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{...props}
	>
		<path
			d="M28.4264 245.074L245.074 28.4264C268.505 4.99495 306.495 4.99491 329.926 28.4264L373.074 71.5736C396.505 95.005 396.505 132.995 373.074 156.426L284.426 245.074C260.995 268.505 260.995 306.495 284.426 329.926L421.574 467.074C445.005 490.505 482.995 490.505 506.426 467.074L660.75 312.75C674.695 298.805 674.695 276.195 660.75 262.25C646.805 248.305 624.195 248.305 610.25 262.25L506.426 366.074C482.995 389.505 445.005 389.505 421.574 366.074L385.426 329.926C361.995 306.495 361.995 268.505 385.426 245.074L600.074 30.4264C623.505 6.99495 661.495 6.99497 684.926 30.4264L899.574 245.074C923.005 268.505 923.005 306.495 899.574 329.926L506.426 723.074C482.995 746.505 445.005 746.505 421.574 723.074L28.4264 329.926C4.99495 306.495 4.99491 268.505 28.4264 245.074Z"
			fill="currentColor"
			stroke="currentColor"
			strokeWidth="20"
		/>
	</svg>
);

export default Logo;
