#include "ImageFeaturesTestFactory.hpp"

#include <array>

namespace detwinner::logic::images {

//------------------------------------------------------------------------------
ImageFeatures
ImageFeaturesTestFactory::CreateFeatures_1()
{
	ImageFeatures feat1(0, 125.0f / 80.0f);
	// clang-format off
	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > yHistograms1 = { {
		{ { 139, 29, 0, 0, 29, 16, 8, 17, 4, 41, 15, 26, 15, 26, 51, 28, 14, 15, 12, 21, 13, 23, 14, 20, 13, 21, 7, 25, 22, 18, 6, 1792 } },
		{ { 165, 38, 0, 0, 29, 17, 26, 17, 4, 38, 22, 26, 25, 27, 69, 31, 15, 13, 24, 24, 17, 16, 16, 15, 18, 22, 14, 15, 17, 15, 8, 1697 } },
		{ { 55, 17, 0, 0, 28, 9, 35, 21, 29, 39, 31, 63, 8, 53, 401, 6, 17, 5, 10, 9, 7, 6, 11, 13, 18, 7, 14, 11, 12, 4, 6, 1535 } },
		{ { 60, 17, 0, 0, 26, 16, 12, 16, 22, 26, 17, 44, 5, 39, 239, 12, 15, 9, 4, 9, 9, 4, 7, 9, 11, 6, 13, 6, 10, 8, 8, 1801 } }
	} };

	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > uHistograms1 = { {
		{ { 0, 0, 0, 0, 0, 0, 0, 3, 57, 67, 79, 44, 52, 111, 62, 79, 1926, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 6, 59, 101, 69, 44, 75, 131, 49, 90, 1856, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 1, 13, 29, 17, 31, 16, 520, 121, 116, 1616, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 10, 25, 19, 21, 22, 20, 314, 75, 94, 1880, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
	} };

	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > vHistograms1 = { {
		{ { 0, 0, 0, 0, 0, 38, 5, 10, 3, 6, 8, 8, 5, 6, 187, 278, 1926, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 66, 5, 5, 7, 7, 2, 5, 5, 3, 219, 300, 1856, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 401, 42, 48, 29, 34, 7, 41, 22, 15, 63, 162, 1616, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 238, 21, 34, 15, 25, 9, 15, 19, 10, 77, 137, 1880, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
	} };

	const std::array< std::array<HistogramI::BinValue_t, HistogramI::kBinCount>, 4 > iHistograms1 = { {
		{ { 1772, 38, 18, 11, 22, 20, 16, 583 } },
		{ { 1747, 30, 31, 24, 12, 17, 20, 599 } },
		{ { 1636, 73, 48, 52, 55, 42, 29, 545 } },
		{ { 1883, 24, 38, 31, 29, 18, 21, 436 } }
	} };
	// clang-format on

	for (std::size_t j = 0; j < 4; ++j)
	{
		for (std::size_t i = 0; i < Histogram::kBinCount; ++i)
		{
			feat1.histY[j].bins = yHistograms1[j];
			feat1.histU[j].bins = uHistograms1[j];
			feat1.histV[j].bins = vHistograms1[j];
		}
		for (std::size_t i = 0; i < HistogramI::kBinCount; ++i)
		{
			feat1.histI[j].bins = iHistograms1[j];
		}
	}

	return feat1;
}

//------------------------------------------------------------------------------
ImageFeatures
ImageFeaturesTestFactory::CreateFeatures_2()
{
	ImageFeatures feat2(1, 126.0f / 80.0f);
	// clang-format off
	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > yHistograms2 = { {
		{ { 54, 3, 4, 9, 10, 12, 18, 27, 24, 35, 34, 45, 45, 76, 68, 334, 21, 5, 6, 14, 9, 6, 13, 15, 16, 12, 3, 18, 11, 4, 5, 11 } },
		{ { 56, 3, 7, 8, 11, 14, 12, 17, 18, 24, 30, 26, 38, 44, 42, 223, 15, 8, 9, 5, 8, 14, 7, 8, 8, 11, 7, 15, 5, 8, 10, 11 } },
		{ { 106, 28, 22, 9, 23, 14, 14, 19, 16, 19, 24, 19, 22, 30, 28, 43, 21, 24, 28, 21, 19, 25, 22, 24, 16, 21, 22, 24, 20, 23, 15, 59 } },
		{ { 115, 31, 21, 23, 33, 15, 15, 25, 23, 21, 20, 24, 38, 23, 28, 76, 22, 18, 20, 27, 25, 17, 21, 20, 14, 19, 32, 15, 17, 16, 18, 50 } }
	} };

	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > uHistograms2 = { {
		{ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 33, 30, 432, 201, 146, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 30, 33, 277, 138, 120, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 53, 113, 108, 136, 120, 148, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 69, 119, 114, 162, 131, 131, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
	} };

	const std::array< std::array<Histogram::BinValue_t, Histogram::kBinCount>, 4 > vHistograms2 = { {
		{ { 0, 0, 0, 0, 36, 348, 72, 45, 32, 20, 38, 22, 64, 65, 63, 59, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 21, 219, 44, 32, 18, 14, 20, 28, 60, 59, 54, 64, 87, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 5, 24, 12, 14, 13, 5, 5, 30, 101, 166, 159, 141, 143, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
		{ { 0, 0, 0, 0, 7, 51, 6, 12, 8, 4, 5, 21, 142, 162, 160, 158, 145, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
	} };

	const std::array< std::array<HistogramI::BinValue_t, HistogramI::kBinCount>, 4 > iHistograms2 = { {
		{ { 1884, 29, 40, 36, 36, 31, 37, 427 } },
		{ { 2073, 26, 14, 18, 20, 19, 18, 332 } },
		{ { 2044, 9,  4,  6,  3,  6,  4,  444 } },
		{ { 2016, 14, 15, 10, 7,  6,  11, 441 } },
	} };
	// clang-format on

	for (std::size_t j = 0; j < 4; ++j)
	{
		for (std::size_t i = 0; i < Histogram::kBinCount; ++i)
		{
			feat2.histY[j].bins = yHistograms2[j];
			feat2.histU[j].bins = uHistograms2[j];
			feat2.histV[j].bins = vHistograms2[j];
		}
		for (std::size_t i = 0; i < HistogramI::kBinCount; ++i)
		{
			feat2.histI[j].bins = iHistograms2[j];
		}
	}

	return feat2;
}

} // namespace detwinner::logic::images
