1 COMMON A, AL, B, BASEONLY, C, C$, C1, CAT$, CC, CKT$, D, D$, DD, DIA, DIMN$, DMS, E, EO, EX$, F, F$, FD, FF, FQ, FRQ, G$, GO$, I, I$, L, LATLONG, LD, LL, LN, LS, LW, LX, MAX, MENU, MIN, MX, N, NN, NT, OV, P, PI, PROG$, Q, QQ, QU, R, RA, RC, T, T$, U, U$, UH, UL$, V$, VC, W, WHIP, WIRD, WW, X, X$, X1, XS, Z$, ZP, ZS
5 'OMMON EX$,PROG$
10 'PSUPERF - Power Supply Performance  - 17 September 2005
20 CLS:KEY OFF
30 IF EX$=""THEN EX$="EXIT"
40 IF PROG$=""THEN GO$=EX$ ELSE GO$=PROG$
50 
60 DIM X(22),Y(22),VR(22),RF(22),RMS(22),PK(22)
70 '.....title page
80 C=0:VPRI=0:RPRI=0:VSEC=0:RSEC=0 :'DEF LOGLOG10(X)=LOG(X)/LOG(10)
90 CLS
100 COLOR 15,2,1
110 PRINT " Power Supply Performance";TAB(60);"by Robert J. Dehoney ";
120 COLOR 1,0:PRINT STRING$(80,223);
130 COLOR 7,0
140 '
150 T=7
160 PRINT TAB(T);
170 PRINT "This program helps design half wave, full wave, bridge, and doubler"
180 PRINT TAB(T);
190 PRINT "power supplies using on-hand power transformers. It is based on "
200 PRINT TAB(T);
210 PRINT "equations derived from accurate time step simulations."
220 PRINT TAB(T);
230 PRINT "Required inputs are the frequency of operation, the primary and"
240 PRINT TAB(T);
250 PRINT "no-load leg-to-leg secondary AC voltages, and the DC resistances"
260 PRINT TAB(T);
270 PRINT "of both the primary and secondary windings. In addition, you will";
280 PRINT TAB(T);
290 PRINT "be asked to enter a value for the filter capacitor. You can";
300 PRINT TAB(T);
310 PRINT "estimate its value as C=350/F*I/Vpp uF, where Vpp is the peak to";
320 PRINT TAB(T);
330 PRINT "peak ripple, F is the freq in Hz and I is the load current in mA.";
340 PRINT
350 COLOR 0,7:LOCATE ,23:PRINT " Press 1 to continue or 0 to EXIT "
360 COLOR 7,0
370 Z$=INKEY$:IF Z$=""THEN 370
380 IF Z$="0"THEN CHAIN GO$
390 IF Z$="1"THEN CLS:GOTO 410
400 GOTO 370
410 '
420 COLOR 7,0,0
430 IF F*VPRI*RPRI*VSEC*RSEC THEN 500
440 INPUT "ENTER: A.C. Frequency (Hz) ";F :IF F=0 THEN 440
450 INPUT "ENTER: AC line voltage";VPRI :IF VPRI=0 THEN 450
460 INPUT "ENTER: Primary winding resistance (ohms)";RPRI
470 PRINT "ENTER: Secondary leg-to-leg no-load AC voltage at";VPRI;;"volts";
480 INPUT VSEC :IF VSEC=0 THEN 470
490 INPUT "ENTER: Secondary leg-to-leg winding resistance (ohms)";RSEC
500 PRINT
510 PRINT "Choose the type of supply:"
520 PRINT "         1) Half Wave"
530 PRINT "         2) Full Wave "
540 PRINT "         3) Bridge"
550 PRINT "         4) Floating Doubler";
560 PRINT "         5) Grounded Doubler";
570 PRINT
580 '
590 INPUT "Enter number 1, 2, 3, 4, or 5 ";NT
600 IF NT<1 OR NT>5 THEN 590 ELSE PRINT
610 HW=1-(NT=1) :FW=1-(NT=2) :BR=1-(NT=3) :DBLR1=1-(NT=4) :DBLR2=1-(NT=5)
620 RST=RSEC/FW+(VSEC/FW/VPRI)^2*RPRI :VD=6.999999E-01
630 VPK=SQR(2)*VSEC/FW-VD*BR
640 CLS:ON NT GOSUB 4710,4790,4860,4940,5020 'print schematic
650 '
660 LOCATE 18,41:PRINT "Enter a value (10<C<32000) for C, uF"
670 LOCATE 19,41:PRINT "-or- Enter 1 to re-run w/same xfmr."
680 LOCATE 20,41:PRINT "-or- Enter 2 to return to start menu"
690 IF C=0 THEN 760
700 LOCATE 25:COLOR  0,2:PRINT " Want a hard copy printout ?";
710 COLOR 16,2:PRINT "   (y/n)  ";:COLOR 7,0
720 Z$=INKEY$:IF Z$=""THEN 720
730 IF Z$="n"THEN GOSUB 5240:GOTO 760 'clear part of screen
740 IF Z$="y"THEN GOSUB 5110:GOTO 660 'hard copy
750 GOTO 720
760 LOCATE 21,41:INPUT C :IF C=0 THEN 760
770 IF C<3 OR (C>10 AND C<32000) THEN 790
780 BEEP:LOCATE 21,41:PRINT "        ";:GOTO 760
790 IF C=1 THEN C=0 :CLS :GOTO 510
800 IF C=2 THEN 70 ELSE C=C*9.999999E-07:CLS
810 ON NT GOSUB 830,840,850,860,870
820 PRINT "                    ";A$ :GOTO 880
830 A$="Half Wave Rectifier." :B$="v" :RETURN
840 A$="Full Wave Rectifier.":B$="vct" :RETURN
850 A$="Bridge Rectifier" :B$="v" :RETURN
860 A$="Floating Doubler" :B$="v" :RETURN
870 A$="Grounded Doubler" :B$="v" :RETURN
880 PRINT "Vpri=";VPRI;"v   Vsec=";VSEC;B$;
890 PRINT "   C=";CINT(C*1.000000E+06);"uF   Surge current=";INT(10*VPK/RST)/10;"amps"
900 LOCATE ,46:PRINT " Transformer     Diode    "
910 'LOCATE ,46:PRINT " Diode Data Ŀ"
920 PRINT " RL        Vdc          Idc       P-P ripple      Irms        Ipeak "
930 READ RL :IF RL=0 THEN RESTORE :PRINT TAB(51);;"Diode PIV=";INT(PIV*100)/100 :    ON NT GOSUB 4710,4790,4860,4940,5020 'print schematic
940 '
950 '.......define X(P)=values of WRCR
960 X(1)=1000 :X(2)=700 :X(3)=400 :X(4)=300 :X(5)=200 :X(6)=100 :X(7)=70
970 X(8)=40 :X(9)=30 :X(10)=20 :X(11)=10 :X(12)=7 :X(13)=4 :X(14)=3 :X(15)=2
980 X(16)=1 :X(17)=6.999999E-01 :X(18)=4.000000E-01 :X(19)=3.000000E-01 :X(20)=2.000000E-01 :X(21)=1.000000E-01
990 '
1000 WCRL=6.283199*F*C*RL :IF WCRL<1.000000E-01 THEN 930 'curve limit
1010 IF WCRL>1000 THEN WCRL=1000 'curve limit
1020 KR=100*RST/RL :IF KR<1.999999E-02 THEN KR=1.999999E-02 ELSE IF KR>100 THEN 930 'curve limit
1030 X=KR :ON NT GOSUB 1170,2060,2060,2940,3820 'calculate VR,RF,RMS,& PK
1040 X=WCRL :GOSUB 1110 'interpolate to get final values for VR,RF,RMS, & PK
1050 '......calculate Vdc, Idc, Vpp, Irms, & Ipk
1060  VDC=VR*VPK/100 :IDC=VDC/RL :VRIP=RF*VDC/100 :IRMS=RMS*IDC :IPK=PK*IDC
1070 PIV=2*VPK/BR 'Calculate peak inverse voltage
1080 PRINT RL;TAB(9); USING "###.###      ";VDC;IDC;VRIP;IRMS;IPK
1090 GOTO 930
1100 DATA 1500,1000,500,200,100,75,50,20,15,10,0
1110 '..........Interpolation subroutine
1120 FOR P=1 TO 20 :IF X=<X(P) THEN P1=P
1130 NEXT P :X1=X(P1) :X2=X(P1+1) :Y1=VR(P1) :Y2=VR(P1+1) :GOSUB 4700 :VR=Y
1140 Y1=RF(P1): Y2=RF(P1+1) :GOSUB 4700 :RF=Y
1150 Y1=RMS(P1) :Y2=RMS(P1+1) :GOSUB 4700 :RMS=Y
1160 Y1=PK(P1):Y2=PK(P1+1) :GOSUB 4700 :PK=Y :RETURN
1170 '............calculate half wave values for given KR
1180 '.......Halfwave VR
1190 Z=LOGLOG10(X+3.100000E-01):VR(1)=9.156107792000000E+01-1.550817950000000E+01*Z-7.129387310000000*Z^2-7.700402830000000*Z^3+3.192635060000000*Z^4
1200 Z=LOGLOG10(X+4.000000E-01):VR(2)=9.218267368999999E+01-1.678594529999999E+01*Z-5.261339239999999*Z^2-9.041827599999999*Z^3+3.519252019999999*Z^4
1210 VR(3)=9.217591E+01-1.666282249999999E+01*Z-5.592374610000000*Z^2-8.768989659999999*Z^3+3.450310009999999*Z^4
1220 Z=LOGLOG10(X+4.499999E-01):VR(4)=9.253907245000000E+01-1.730027839999999E+01*Z-4.901958350000000*Z^2-9.183177490000000*Z^3+3.542457530000000*Z^4
1230 Z=LOGLOG10(X+6.999999E-01):VR(5)=9.461447410999999E+01-2.124858959999999E+01*Z-6.652622700000000E-01*Z^2-1.158726060000000E+01*Z^3+4.052282199999999*Z^4
1240 Z=LOGLOG10(X+1.200000):VR(6)=9.880125959000000E+01-2.679085470000000E+01*Z+2.018437680000000*Z^2-1.204672070000000E+01*Z^3+4.046216009999999*Z^4
1250 Z=LOGLOG10(X+2):VR(7)=1.062262415000000E+02-3.594762870000000E+01*Z+5.359996619999999*Z^2-1.198151820000000E+01*Z^3+3.865891569999999*Z^4
1260 Z=LOGLOG10(X+4.000000E-01):VR(8)=9.021400880999999E+01-1.088366950000000E+01*Z-1.334575749999999E+01*Z^2-4.055861460000000*Z^3+2.429510569999999*Z^4
1270 Z=LOGLOG10(X+4.499999E-01):VR(9)=8.913193794000000E+01-8.866677920000000*Z-1.411732840000000E+01*Z^2-4.394453229999999*Z^3+2.608714179999999*Z^4
1280 Z=LOGLOG10(X+1.340000):VR(10)=8.661500000000000E+01+8.820928010000000*Z-3.916465879999999E+01*Z^2+9.248126269999999*Z^3
1290 Z=LOGLOG10(X+2.700000):VR(11)=6.893243999999999E+01+4.711282096999999E+01*Z-6.514229710000000E+01*Z^2+1.489895299999999E+01*Z^3
1300 Z=LOGLOG10(X+4.300000):VR(12)=4.879010E+01+8.548060820000000E+01*Z-8.848060822000000E+01*Z^2+1.953125920999999E+01*Z^3
1310 Z=LOGLOG10(X+8.500000):VR(13)=1.305919999999999+1.601241853000000E+02*Z-1.267405869999999E+02*Z^2+2.594035190000000E+01*Z^3
1320 Z=LOGLOG10(X+14):VR(14)=-5.070830500000000E+01+2.458285915000000E+02*Z-1.724358E+02*Z^2+3.391363272999999E+01*Z^3
1330 VR(15)=4.774396520999999E+01-5.172253500000000E-01*X+2.935329E-03*X^2-5.689999E-06*X^3
1340 VR(16)=3.777974793000000E+01-3.766164300000000E-01*X+2.628709E-03*X^2-8.660000E-06*X^3
1350 VR(17)=3.489924826000000E+01-3.440870600000000E-01*X+2.549469E-03*X^2-9.069999E-06*X^3
1360 VR(18)=3.265021309000000E+01-3.199277499999999E-01*X+2.465049E-03*X^2-9.149999E-06*X^3
1370 VR(19)=3.219605757999999E+01-3.151917600000000E-01*X+2.445769E-03*X^2-9.139999E-06*X^3
1380 VR(20)=3.174190225999999E+01-3.104557599999999E-01*X+2.426489E-03*X^2-9.129999E-06*X^3
1390 VR(21)=3.150593368000000E+01-3.078805900000000E-01*X+2.411900E-03*X^2-9.090000E-06*X^3
1400 '.........halfwave RF
1410 Z=LOGLOG10(X+3.099999E-02):RF(1)=5.414610900000000E-01-6.733129E-02*Z-1.263756E-02*Z^2+2.884200E-03*Z^3
1420 Z=LOGLOG10(X+3.599999E-02):RF(2)=7.736689999999999E-01-9.673070E-02*Z-1.280994399999999E-02*Z^2+4.204949E-03*Z^3
1430 Z=LOGLOG10(X+5.499999E-02):RF(3)=1.356331-1.732251900000000E-01*Z-3.124625E-02*Z^2+6.796676E-03*Z^3
1440 Z=LOGLOG10(X+5.299999E-02):RF(4)=1.808668-2.299597799999999E-01*Z-4.334414E-02*Z^2+1.119174E-02*Z^3
1450 Z=LOGLOG10(X+4.699999E-02):RF(5)=2.712229999999999-3.417445600000000E-01*Z-6.976933E-02*Z^2+1.851068E-02*Z^3
1460 Z=LOGLOG10(X+6.899999E-02):RF(6)=5.431766989999999-6.733986E-01*Z-1.587990700000000E-01*Z^2+4.702031E-02*Z^3
1470 Z=LOGLOG10(X+1.220000E-01):RF(7)=7.787326199999999-9.755446400000000E-01*Z-2.798520300000000E-01*Z^2+8.992710E-02*Z^3
1480 Z=LOGLOG10(X+1.899999E-01):RF(8)=1.362676813000000E+01-1.580673720000000*Z-6.771742699999999E-01*Z^2+2.208845200000000E-01*Z^3
1490 Z=LOGLOG10(X+3.000000E-01):RF(9)=1.817412129999999E+01-1.961296700000000*Z-1.116880449999999*Z^2+3.651782100000000E-01*Z^3
1500 Z=LOGLOG10(X+4.000000E-01):RF(10)=2.701866479999999E+01-2.322057580000000*Z-2.194085349999999*Z^2+6.814596500000000E-01*Z^3
1510 Z=LOGLOG10(X+1):RF(11)=5.198220026999999E+01-3.796763900000000E-01*Z-7.485813979999999*Z^2+2.083153580000000*Z^3
1520 Z=LOGLOG10(1.700000):RF(12)=7.078377710000000E+01+5.029033230000000*Z-1.391502780000000E+01*Z^2+5.587475170000000*Z^3
1530 Z=LOGLOG10(X+4.199999):RF(13)=1.034871E+02+3.805073756999999E+01*Z-4.038961809999999E+01*Z^2+9.232845980000000*Z^3
1540 Z=LOGLOG10(X+6.599999):RF(14)=1.142799999999999E+02+7.864570866000000E+01*Z-6.655806869999999E+01*Z^2+1.422434404000000E+01*Z^3
1550 RF(15)=1.870100151000000E+02-3.627160099999999E-01*X+1.032860E-03*X^2+3.980000E-06*X^3
1560 RF(16)=2.590211791999999E+02-6.485249E-02*X-2.327289E-03*X^2+1.725000E-05*X^3
1570 RF(17)=2.834768779999999E+02-2.242939E-02*X-1.529959E-03*X^2+1.000999E-05*X^3
1580 RF(18)=3.037650E+02-2.883999E-02*X
1590 RF(19)=3.081184E+02-1.827999E-02*X
1600 RF(20)=3.124719E+02-7.720000E-03*X
1610 RF(21)=3.147000E+02
1620 '.......halfwave RMS
1630 Z=LOGLOG10(X-8.999999E-04):RMS(1)=2.922652000000000-1.066915420000000*Z+2.437120E-01*Z^2-1.085074E-02*Z^3
1640 Z=LOGLOG10(X-3.000000E-04):RMS(2)=2.922499999999999-1.061470030000000*Z+2.454364900000000E-01*Z^2-1.159506E-02*Z^3
1650 Z=LOGLOG10(X+1.000000E-03):RMS(3)=2.924335399999999-1.063975599999999*Z+2.434083E-01*Z^2-1.002367E-02*Z^3
1660 Z=LOGLOG10(X+3.000000E-03):RMS(4)=2.926219999999999-1.067534740000000*Z+2.441722700000000E-01*Z^2-9.671178E-03*Z^3
1670 Z=LOGLOG10(X+1.099999E-02):RMS(5)=2.928082200000000-1.079050969999999*Z+2.604000600000000E-01*Z^2-1.534190E-02*Z^3
1680 Z=LOGLOG10(X+4.699999E-02):RMS(6)=2.947299999999999-1.124481490000000*Z+2.914357399999999E-01*Z^2-2.173594E-02*Z^3
1690 Z=LOGLOG10(X+1.000000E-01):RMS(7)=2.970554399999999-1.185406509999999*Z+3.444561699999999E-01*Z^2-3.613618E-02*Z^3
1700 Z=LOGLOG10(X+2.599999E-01):RMS(8)=3.033140449999999-1.290597930000000*Z+3.977716E-01*Z^2-4.408657E-02*Z^3
1710 Z=LOGLOG10(X+4.499999E-01):RMS(9)=3.102198999999999-1.422729510000000*Z+4.840604299999999E-01*Z^2-6.289243E-02*Z^3
1720 Z=LOGLOG10(X+9.100000E-01):RMS(10)=3.240222229999999-1.639581330000000*Z+5.933840E-01*Z^2-8.045025E-02*Z^3
1730 Z=LOGLOG10(X+3.400000):RMS(11)=3.988619099999999-2.840667469999999*Z+1.243213359999999*Z^2-1.984214E-01*Z^3
1740 Z=LOGLOG10(X+9):RMS(12)=7.069623910000000-7.948064059999999*Z+4.088002820000000*Z^2-7.280909099999999E-01*Z^3
1750 Z=LOGLOG10(X+1.600000):RMS(13)=2.263027510000000+1.279638399999999E-01*Z-4.769664500000000E-01*Z^2+1.346972900000000E-01*Z^3
1760 Z=LOGLOG10(X+3.200000):RMS(14)=2.069292919999999+3.997055399999999E-01*Z-5.995288200000000E-01*Z^2+1.520073299999999E-01*Z^3
1770 Z=LOGLOG10(X+6.500000):RMS(15)=1.751703499999999+7.360923199999999E-01*Z-6.934189E-01*Z^2+1.540752700000000E-01*Z^3
1780 RMS(16)=1.766000-1.129999E-03*X
1790 RMS(17)=1.692999-5.900000E-04*X
1800 RMS(18)=1.623999-1.900000E-04*X
1810 RMS(19)=1.605000-9.500000E-05*X
1820 RMS(20)=1.585999
1830 RMS(21)=1.577999
1840 '..........halfwave PK
1850 Z=LOGLOG10(X-3.800000E-03):PK(1)=1.066199579999999E+01-7.835545940000000*Z+3.236360029999999*Z^2-5.464056E-01*Z^3
1860 Z=LOGLOG10(X-3.100000E-03):PK(2)=1.064741000000000E+01-7.832364090000000*Z+3.282516019999999*Z^2-5.702349200000000E-01*Z^3
1870 Z=LOGLOG10(X-2.000000E-03):PK(3)=1.065517800000000E+01-7.856166509999999*Z+3.287732509999999*Z^2-5.689154899999999E-01*Z^3
1880 Z=LOGLOG10(X-5.000000E-04):PK(4)=1.065693700000000E+01-7.868517320000000*Z+3.314658800000000*Z^2-5.783141400000000E-01*Z^3
1890 Z=LOGLOG10(X+3.000000E-03):PK(5)=1.068670199999999E+01-7.922988229999999*Z+3.312791409999999*Z^2-5.655811800000000E-01*Z^3
1900 Z=LOGLOG10(X+2.400000E-02):PK(6)=1.075012574000000E+01-8.145076959999999*Z+3.532965799999999*Z^2-6.289553E-01*Z^3
1910 Z=LOGLOG10(X+4.399999E-02):PK(7)=1.084586500000000E+01-8.228129980000000*Z+3.443753229999999*Z^2-5.715895500000000E-01*Z^3
1920 Z=LOGLOG10(X+1.180000E-01):PK(8)=1.100522099999999E+01-8.434081259999999*Z+3.484267369999999*Z^2-5.590572399999999E-01*Z^3
1930 Z=LOGLOG10(X+1.920000E-01):PK(9)=1.111015731999999E+01-8.560450579999999*Z+3.508235920000000*Z^2-5.520325E-01*Z^3
1940 Z=LOGLOG10(X+3.540000E-01):PK(10)=1.120256999999999E+01-8.424107690000000*Z+3.195926439999999*Z^2-4.393944899999999E-01*Z^3
1950 Z=LOGLOG10(X+1.289999):PK(11)=1.199887999999999E+01-9.670269309999999*Z+3.865605869999999*Z^2-5.625056799999999E-01*Z^3
1960 Z=LOGLOG10(X+2.619999):PK(12)=1.298849999999999E+01-1.108168459999999E+01*Z+4.526568860000000*Z^2-6.632895099999999E-01*Z^3
1970 Z=LOGLOG10(X+9.800000E-01):PK(13)=6.664899000000000-4.910860E-02*Z-1.987978749999999*Z^2+6.248775899999999E-01*Z^3
1980 Z=LOGLOG10(X+1.899999):PK(14)=5.388548099999999+1.706479340000000*Z-2.762512760000000*Z^2+7.312513699999999E-01*Z^3
1990 Z=LOGLOG10(X+7.699999):PK(15)=1.415079029999999+8.061529299999999*Z-6.125789400000000*Z^2+1.318401970000000*Z^3
2000 PK(16)=3.721999-2.739999E-03*X
2010 PK(17)=3.473999-1.139999E-03*X
2020 PK(18)=3.273999-3.199999E-04*X
2030 PK(19)=3.230499-1.999999E-04*X
2040 PK(20)=3.187000-7.999999E-05*X
2050 PK(21)=3.163000 :RETURN
2060 '..........fullwave VR
2070 Z=LOGLOG10(X+8.999999E-01):VR(1)=9.788567910000000E+01-1.889300790000000E+01*Z+8.146414059999999*Z^2-1.529645239999999E+01*Z^3+3.947391439999999*Z^4
2080 Z=LOGLOG10(X+6.499999E-01):VR(2)=9.604341398999999E+01-1.414861079999999E+01*Z+1.922593229999999*Z^2-1.157371379999999E+01*Z^3+3.160143250000000*Z^4
2090 Z=LOGLOG10(X+5.799999E-01):VR(3)=9.559312989999999E+01-1.295581610000000E+01*Z+1.774672399999999E-01*Z^2-1.043780259999999E+01*Z^3+2.905836599999999*Z^4
2100 Z=LOGLOG10(X+6.999999E-01):VR(4)=9.634010626000000E+01-1.470895339999999E+01*Z+2.507790640000000*Z^2-1.188654999999999E+01*Z^3+3.222325930000000*Z^4
2110 Z=LOGLOG10(X+1):VR(5)=9.852365089000000E+01-1.983641040000000E+01*Z+8.704728800000000*Z^2-1.542180430000000E+01*Z^3+3.940456110000000*Z^4
2120 Z=LOGLOG10(X+1.700000):VR(6)=1.046095150000000E+02-3.278983950000000E+01*Z+2.179729749000000E+01*Z^2-2.182561520000000E+01*Z^3+5.125476480000000*Z^4
2130 Z=LOGLOG10(X+2.500000):VR(7)=1.129907765000000E+02-4.964102809999999E+01*Z+3.692378655999999E+01*Z^2-2.838034429999999E+01*Z^3+6.213094079999999*Z^4
2140 Z=1/(X+22):VR(8)=7.075635000000000+3.792070320999999E+03*Z-7.910589552000000E+04*Z^2+8.536866787000000E+05*Z^3
2150 Z=LOGLOG10(X+1.799999):VR(9)=9.695115999999999E+01-1.422926959999999*Z-2.217398177000000E+01*Z^2+3.519782509999999*Z^3
2160 Z=LOGLOG10(X+1.269999):VR(10)=9.341236E+01+1.766196209999999*Z-2.265784120000000E+01*Z^2+3.388852409999999*Z^3
2170 Z=LOGLOG10(X+2.490000):VR(11)=8.499150000000000E+01+2.512967020000000E+01*Z-4.055197349999999E+01*Z^2+7.589256549999999*Z^3
2180 Z=LOGLOG10(X+3.700000):VR(12)=7.478260E+01+4.821856246000000E+01*Z-5.607498640000000E+01*Z^2+1.088160265999999E+01*Z^3
2190 Z=LOGLOG10(X+7.400000):VR(13)=4.206813E+01+1.134966419999999E+02*Z-9.596767329999999E+01*Z^2+1.867842213999999E+01*Z^3
2200 Z=LOGLOG10(X+11):VR(14)=1.169980099999999E+01+1.701889569999999E+02*Z-1.286202800000000E+02*Z^2+2.470717028000000E+01*Z^3
2210 Z=LOGLOG10(X+1.679999E+01):VR(15)=-2.376000E+01+2.286102601999999E+02*Z-1.582215109999999E+02*Z^2+2.946312459000000E+01*Z^3
2220 VR(16)=6.716227731999999E+01-6.673480400000000E-01*X+4.905050E-03*X^2-1.707999E-05*X^3
2230 VR(17)=6.531708459000000E+01-6.427090E-01*X+4.871460E-03*X^2-1.770000E-05*X^3
2240 VR(18)=6.377794701000000E+01-6.244642700000000E-01*X+4.842190E-03*X^2-1.806000E-05*X^3
2250 VR(20)=6.310924899000000E+01-6.169983E-01*X+4.826049E-03*X^2-1.816000E-05*X^3
2260 VR(19)=5.849999E-01*VR(18)+4.149999E-01*VR(20)
2270 VR(21)=6.292453322999999E+01-6.149617899999999E-01*X+4.820609E-03*X^2-1.818000E-05*X^3
2280 '......fullwave RF
2290 Z=LOGLOG10(X+1.999999E-02):RF(1)=2.452259999999999E-01-5.190053E-02*Z-1.114584E-02*Z^2+1.026749E-03*Z^3
2300 Z=LOGLOG10(X+9.999999E-03):RF(2)=3.500561E-01-7.349365E-02*Z-1.640974E-02*Z^2+1.539209E-03*Z^3
2310 Z=LOGLOG10(X+4.399999E-02):RF(3)=6.153060999999999E-01-1.345701899999999E-01*Z-2.738944E-02*Z^2+3.360430E-03*Z^3
2320 Z=LOGLOG10(X+3.900000E-02):RF(4)=8.201257299999999E-01-1.785899E-01*Z-3.782831E-02*Z^2+4.928890E-03*Z^3
2330 Z=LOGLOG10(X+3.900000E-02):RF(5)=1.230845999999999-2.673506599999999E-01*Z-5.881462E-02*Z^2+8.305509E-03*Z^3
2340 Z=LOGLOG10(X+6.300000E-02):RF(6)=2.471379099999999-5.392812500000000E-01*Z-1.325925199999999E-01*Z^2+2.448981E-02*Z^3
2350 Z=LOGLOG10(X+8.799999E-02):RF(7)=3.534949300000000-7.634462800000000E-01*Z-2.061445099999999E-01*Z^2+4.135192E-02*Z^3
2360 Z=LOGLOG10(X+1.700000E-01):RF(8)=6.227622659999999-1.309107839999999*Z-4.784087299999999E-01*Z^2+1.211568599999999E-01*Z^3
2370 Z=LOGLOG10(X+2.000000E-01):RF(9)=8.286094690000000-1.644597549999999*Z-7.557321E-01*Z^2+1.981090600000000E-01*Z^3
2380 Z=LOGLOG10(X+3.199999E-01):RF(10)=1.236989699999999E+01-2.152884259999999*Z-1.476775940000000*Z^2+3.991990700000000E-01*Z^3
2390 Z=LOGLOG10(X+7.099999E-01):RF(11)=2.378244999999999E+01-1.883865869999999*Z-4.873212490000000*Z^2+1.273183409999999*Z^3
2400 Z=LOGLOG10(X+1.279999):RF(12)=3.230057609999999E+01+9.829102E-01*Z-9.558945679999999*Z^2+2.407114040000000*Z^3
2410 Z=LOGLOG10(X+3.500000):RF(13)=4.548171E+01+2.259380370999999E+01*Z-2.978465689999999E+01*Z^2+6.882547439999999*Z^3
2420 Z=LOGLOG10(X+5.400000):RF(14)=4.692139E+01+5.078556010999999E+01*Z-5.024843070000000E+01*Z^2+1.095436868999999E+01*Z^3
2430 Z=LOGLOG10(X+1.039999E+01):RF(15)=2.554999E+01+1.369689593999999E+02*Z-1.035744740000000E+02*Z^2+2.078253971999999E+01*Z^3
2440 RF(16)=1.110214352000000E+02-3.486667499999999E-01*X+3.923400E-04*X^2+5.989999E-06*X^3
2450 RF(17)=1.242645353999999E+02-2.537106299999999E-01*X+3.188000E-04*X^2+2.929999E-06*X^3
2460 RF(18)=1.389624598000000E+02-1.493788500000000E-01*X+3.828899E-04*X^2+6.999999E-08*X^3
2470 RF(19)=1.439745819000000E+02-1.106396800000000E-01*X+3.007200E-04*X^2
2480 RF(20)=1.489263015999999E+02-7.169671E-02*X+2.041999E-04*X^2
2490 RF(21)=1.537330E+02-2.336999E-02*X
2500 '.........fullwave RMS
2510 Z=LOGLOG10(X-6.999999E-04):RMS(1)=2.306653-8.560004400000000E-01*Z+1.880158900000000E-01*Z^2-1.234421E-02*Z^3
2520 Z=LOGLOG10(X-6.009999E-04):RMS(2)=2.307420-8.566027300000000E-01*Z+1.864092E-01*Z^2-1.140710E-02*Z^3
2530 Z=LOGLOG10(X):RMS(3)=2.309343299999999-8.585456600000000E-01*Z+1.836847399999999E-01*Z^2-9.644920E-03*Z^3
2540 Z=LOGLOG10(X+1.000000E-03):RMS(4)=2.310158700000000-8.596521300000000E-01*Z+1.829234799999999E-01*Z^2-9.023089E-03*Z^3
2550 Z=LOGLOG10(X+6.000000E-03):RMS(5)=2.310836700000000-8.650956399999999E-01*Z+1.916697899999999E-01*Z^2-1.226155199999999E-02*Z^3
2560 Z=LOGLOG10(X+2.899999E-02):RMS(6)=2.320513180000000-8.906316E-01*Z+2.092056399999999E-01*Z^2-1.569782E-02*Z^3
2570 Z=LOGLOG10(X+5.999999E-02):RMS(7)=2.332310200000000-9.180709499999999E-01*Z+2.294289699999999E-01*Z^2-2.041286E-02*Z^3
2580 Z=LOGLOG10(X+1.679999E-01):RMS(8)=2.368331000000000-9.845019700000000E-01*Z+2.680300399999999E-01*Z^2-2.753918E-02*Z^3
2590 Z=LOGLOG10(X+3.400000E-01):RMS(9)=2.438103000000000-1.138116960000000*Z+3.809909199999999E-01*Z^2-5.448278E-02*Z^3
2600 Z=LOGLOG10(X+6.100000E-01):RMS(10)=2.489124-1.199692609999999*Z+3.982256900000000E-01*Z^2-5.393368E-02*Z^3
2610 Z=LOGLOG10(X+2.200000):RMS(11)=2.853216260000000-1.771602549999999*Z+6.970808799999999E-01*Z^2-1.056047E-01*Z^3
2620 Z=LOGLOG10(X+4.900000):RMS(12)=3.666574-3.117117890000000*Z+1.451743759999999*Z^2-2.479788100000000E-01*Z^3
2630 Z=LOGLOG10(X+15):RMS(13)=6.704349899999999-7.554339719999999*Z+3.619305160000000*Z^2-6.009077399999999E-01*Z^3
2640 Z=LOGLOG10(X+2.299999):RMS(14)=1.696024950000000+2.084737400000000E-01*Z-4.534376E-01*Z^2+1.184951100000000E-01*Z^3
2650 Z=LOGLOG10(X+5.199999):RMS(15)=1.428657700000000+5.010564E-01*Z-5.427853299999999E-01*Z^2+1.227092900000000E-01*Z^3
2660 RMS(16)=1.328038329999999-2.065039E-03*X+8.560001E-06*X^2
2670 RMS(17)=1.246999-6.300000E-04*X
2680 RMS(18)=1.167999-1.900000E-04*X
2690 RMS(19)=1.146999-1.100000E-04*X
2700 RMS(20)=1.128999-3.999999E-05*X
2710 RMS(21)=1.116999
2720 '......fullwave PK
2730 Z=LOGLOG10(X-3.700000E-03):PK(1)=6.632168999999999-4.991892839999999*Z+2.039188080000000*Z^2-3.586614399999999E-01*Z^3
2740 Z=LOGLOG10(X-3.599999E-03):PK(2)=6.635314000000000-4.995585520000000*Z+2.034270159999999*Z^2-3.553494700000000E-01*Z^3
2750 Z=LOGLOG10(X-2.700000E-03):PK(3)=6.637604520000000-5.003809559999999*Z+2.042584879999999*Z^2-3.577769E-01*Z^3
2760 Z=LOGLOG10(X-2.700000E-03):PK(4)=6.647841000000000-5.013928119999999*Z+2.025830010000000*Z^2-3.472080899999999E-01*Z^3
2770 Z=LOGLOG10(X):PK(5)=6.659868829999999-5.035146039999999*Z+2.026240140000000*Z^2-3.429639400000000E-01*Z^3
2780 Z=LOGLOG10(X+1.300000E-02):PK(6)=6.687487159999999-5.123700049999999*Z+2.104351*Z^2-3.633085299999999E-01*Z^3
2790 Z=LOGLOG10(X+2.899999E-02):PK(7)=6.709738699999999-5.199771539999999*Z+2.189421969999999*Z^2-3.904814900000000E-01*Z^3
2800 Z=LOGLOG10(X+7.999999E-02):PK(8)=6.812559220000000-5.330602779999999*Z+2.183320040000000*Z^2-3.652340499999999E-01*Z^3
2810 Z=LOGLOG10(X+1.299999E-01):PK(9)=6.870421699999999-5.393573069999999*Z+2.183625079999999*Z^2-3.564151200000000E-01*Z^3
2820 Z=LOGLOG10(X+2.380000E-01):PK(10)=6.923733000000000-5.327099319999999*Z+2.008542470000000*Z^2-2.905671400000000E-01*Z^3
2830 Z=LOGLOG10(X+7.699999E-01):PK(11)=7.110553299999999-5.496951380000000*Z+2.011278390000000*Z^2-2.726662399999999E-01*Z^3
2840 Z=LOGLOG10(X+1.419999):PK(12)=7.232875999999999-5.602430559999999*Z+2.015793549999999*Z^2-2.638208800000000E-01*Z^3
2850 Z=LOGLOG10(X+4.400000):PK(13)=8.185953400000000-6.984315049999999*Z+2.693205440000000*Z^2-3.761752599999999E-01*Z^3
2860 Z=LOGLOG10(X+9.699999):PK(14)=1.106312070000000E+01-1.120196940000000E+01*Z+4.777551899999999*Z^2-7.227175400000000E-01*Z^3
2870 Z=LOGLOG10(X+2.940000):PK(15)=2.740003000000000+1.372877569999999*Z-1.708654189999999*Z^2+4.111438099999999E-01*Z^3
2880 PK(16)=2.094000-2.589999E-03*X
2890 PK(17)=1.855999-9.800000E-04*X
2900 PK(18)=1.675999-2.300000E-04*X
2910 PK(19)=1.633999-1.300000E-04*X
2920 PK(20)=1.603000-5.999999E-05*X
2930 PK(21)=1.583999 :RETURN
2940 '........floating doubler
2950 Z=LOGLOG10(X+1.599999E-01):VR(1)=1.721445578999999E+02-4.379267570000000E+01*Z-2.425934880000000E+01*Z^2-6.621909420000000*Z^3+5.688028769999999*Z^4
2960 Z=LOGLOG10(X+1.599999E-01):VR(2)=1.721507567999999E+02-4.378762669999999E+01*Z-2.440476879999999E+01*Z^2-6.450686469999999*Z^3+5.637365540000000*Z^4
2970 Z=LOGLOG10(X+2.099999E-01):VR(3)=1.730467505999999E+02-4.497537289999999E+01*Z-2.356450570000000E+01*Z^2-6.891004879999999*Z^3+5.741044159999999*Z^4
2980 Z=LOGLOG10(X+3.000000E-01):VR(4)=1.747970822999999E+02-4.745118130000000E+01*Z-2.194343529999999E+01*Z^2-7.543673069999999*Z^3+5.863406310000000*Z^4
2990 Z=LOGLOG10(X+5.500000E-01):VR(5)=1.802222887000000E+02-5.496212110000000E+01*Z-1.851768660000000E+01*Z^2-7.825500750000000*Z^3+5.748633930000000*Z^4
3000 Z=1/(X+8):VR(6)=3.606756100000000+2.543176192000000E+03*Z-1.784317979999999E+04*Z^2+7.474588774000000E+04*Z^3
3010 Z=1/(X+10):VR(7)=2.189483000000000+2.743184261600000E+03*Z-2.043272519999999E+04*Z^2+1.127062206999999E+05*Z^3
3020 Z=LOGLOG10(X+7.099999E-01):VR(8)=1.729625100000000E+02-2.343338259999999E+01*Z-6.449904100000000E+01*Z^2+1.967076677000000E+01*Z^3
3030 Z=LOGLOG10(X+8.000000E-01):VR(9)=1.682516500000000E+02-1.248261650000000E+01*Z-7.167655569999999E+01*Z^2+2.110976484999999E+01*Z^3
3040 Z=LOGLOG10(X+1.200000):VR(10)=1.575859E+02+1.716050442000000E+01*Z-9.593138259999999E+01*Z^2+2.719674910999999E+01*Z^3
3050 Z=LOGLOG10(X+2.500000):VR(11)=1.170910E+02+9.968175702999999E+01*Z-1.481606810000000E+02*Z^2+3.778589110999999E+01*Z^3
3060 Z=LOGLOG10(X+4.199999):VR(12)=7.455699E+01+1.798888733000000E+02*Z-1.946975459999999E+02*Z^2+4.631292235999999E+01*Z^3
3070 Z=LOGLOG10(X+8.699999):VR(13)=-3.608599E+01+3.657983054999999E+02*Z-2.949358080000000E+02*Z^2+6.387622603999999E+01*Z^3
3080 Z=LOGLOG10(X+1.250000E+01):VR(14)=-1.180999E+02+4.900007236000000E+02*Z-3.546627020000000E+02*Z^2+7.302120389000000E+01*Z^3
3090 Z=LOGLOG10(X+2.039999E+01):VR(15)=-274+7.096412030999999E+02*Z-4.527162719999999E+02*Z^2+8.681186731999999E+01*Z^3
3100 VR(16)=4.955613786999999E+01-2.910693400000000E-01*X-1.410829E-03*X^2+1.673999E-05*X^3
3110 VR(17)=3.830307834999999E+01-1.379937600000000E-01*X-1.425390E-03*X^2+1.120999E-05*X^3
3120 VR(18)=2.390809027000000E+01-3.355557E-02*X-6.056400E-04*X^2+3.039999E-06*X^3
3130 VR(20)=1.244720490999999E+01-5.709470E-04*X-6.754000E-05*X^2
3140 VR(19)=5.849999E-01*VR(18)+4.149999E-01*VR(20)
3150 VR(21)=6.291999-1.810000E-03*X
3160 '..........floating doubler RF
3170 Z=LOGLOG10(X+5.000000E-02):RF(1)=4.226671499999999E-01-1.487565500000000E-01*Z-1.277281E-02*Z^2+1.063000E-02*Z^3
3180 RF(2)=6.042101099999999E-01-2.127271500000000E-01*Z-1.916779E-02*Z^2+1.566426E-02*Z^3
3190 Z=LOGLOG10(X+4.300000E-02):RF(3)=1.055868-3.684870199999999E-01*Z-3.721215E-02*Z^2+2.855793E-02*Z^3
3200 Z=LOGLOG10(X+4.699999E-02):RF(4)=1.402083-4.954257499999999E-01*Z-4.748367E-02*Z^2+3.916987E-02*Z^3
3210 Z=LOGLOG10(X+5.999999E-02):RF(5)=2.122247-7.439485279999999E-01*Z-8.864548E-02*Z^2+6.518165E-02*Z^3
3220 Z=LOGLOG10(X+1.000000E-01):RF(6)=4.277251130000000-1.480282139999999*Z-2.570177699999999E-01*Z^2+1.657441200000000E-01*Z^3
3230 RF(7)=6.093137820000000-2.021193279999999*Z-4.800115699999999E-01*Z^2+2.728283899999999E-01*Z^3
3240 Z=LOGLOG10(X+1.400000E-01):RF(8)=1.057684779999999E+01-3.166089009999999*Z-1.240164519999999*Z^2+5.975043700000000E-01*Z^3
3250 Z=LOGLOG10(X+2.099999E-01):RF(9)=1.400349006000000E+01-3.848553700000000*Z-2.012378620000000*Z^2+8.959108100000000E-01*Z^3
3260 Z=LOGLOG10(X+3.400000E-01):RF(10)=2.048984700000000E+01-4.501958290000000*Z-3.994706399999999*Z^2+1.578604489999999*Z^3
3270 Z=LOGLOG10(X+1):RF(11)=3.694637339999999E+01-1.091814129999999*Z-1.302800390000000E+01*Z^2+4.191749849999999*Z^3
3280 Z=1/(X+7):RF(12)=1.957143999999999E+01+3.695641407999999E+02*Z-1.426088420000000E+03*Z^2+1.494840519000000E+03*Z^3
3290 Z=1/(X+7.500000):RF(13)=3.305641E+01+6.748041089000000E+02*Z-4.667309870000000E+03*Z^2+1.174248496999999E+04*Z^3
3300 Z=1/(X+10):RF(14)=4.252904000000000E+01+9.369880294000000E+02*Z-8.405178390000000E+03*Z^2+2.734651087999999E+04*Z^3
3310 RF(15)=9.635491026999999E+01-6.019528199999999E-01*X+4.773229E-03*X^2-1.366000E-05*X^3
3320 RF(16)=1.222926883999999E+02-2.920911699999999E-01*X+1.922109E-03*X^2-5.280000E-06*X^3
3330 RF(17)=1.329808582000000E+02-2.164830400000000E-01*X+1.767970E-03*X^2-6.629999E-06*X^3
3340 RF(18)=1.454517871000000E+02-1.446035700000000E-01*X+1.315849E-03*X^2-5.289999E-06*X^3
3350 RF(20)=1.543506174000000E+02-6.890148E-02*X+3.725200E-04*X^2-8.600000E-07*X^3
3360 RF(19)=5.849999E-01*RF(18)+4.149999E-01*RF(20)
3370 RF(21)=1.577590E+02-1.437999E-02*X
3380 '............floating doubler RMS
3390 Z=LOGLOG10(X-9.999999E-05):RMS(1)=3.713299999999999-1.297976059999999*Z+3.299693799999999E-01*Z^2-1.486160E-02*Z^3
3400 Z=LOGLOG10(X):RMS(2)=3.715611249999999-1.299414349999999*Z+3.248519980000000E-01*Z^2-1.200284E-02*Z^3
3410 Z=LOGLOG10(X+3.000000E-03):RMS(3)=3.717405010000000-1.304954740000000*Z+3.291931700000000E-01*Z^2-1.298119E-02*Z^3
3420 Z=LOGLOG10(X+8.009999E-03):RMS(4)=3.717000-1.313742980000000*Z+3.460907199999999E-01*Z^2-1.951391E-02*Z^3
3430 Z=LOGLOG10(X+1.899999E-02):RMS(5)=3.724986-1.334837209999999*Z+3.612506E-01*Z^2-2.266049E-02*Z^3
3440 Z=LOGLOG10(X+7.800000E-02):RMS(6)=3.759784799999999-1.424871450000000*Z+4.336560E-01*Z^2-4.076180E-02*Z^3
3450 Z=LOGLOG10(X+1.700000E-01):RMS(7)=3.811719999999999-1.569316660000000*Z+5.636800399999999E-01*Z^2-7.669670E-02*Z^3
3460 Z=LOGLOG10(X+3.899999E-01):RMS(8)=3.904341000000000-1.689269770000000*Z+5.921330499999999E-01*Z^2-7.185745E-02*Z^3
3470 Z=LOGLOG10(X+6.899999E-01):RMS(9)=4.041648849999999-1.957198329999999*Z+7.685309200000000E-01*Z^2-1.103566300000000E-01*Z^3
3480 Z=LOGLOG10(X+1.629999):RMS(10)=4.525266899999999-2.891327959999999*Z+1.375889880000000*Z^2-2.412882E-01*Z^3
3490 Z=1/(X+4):RMS(11)=2.257207189999999+7.060803550000000*Z-1.173277830000000E+01*Z^2+6.257836020000000*Z^3
3500 Z=1/(X+5):RMS(12)=2.227579499999999+8.135174420000000*Z-2.098210869999999E+01*Z^2+1.446275679000000E+01*Z^3
3510 Z=1/(X+7):RMS(13)=2.232254609999999+8.864311899999999*Z-4.718688319999999E+01*Z^2+9.067954083000000E+01*Z^3
3520 Z=1/(X+8):RMS(14)=2.229656850000000+8.823845799999999*Z-6.520127890000000E+01*Z^2+1.759211297999999E+02*Z^3
3530 Z=1/(X+12):RMS(15)=2.227536000000000+8.353855990000000*Z-9.088354679999999E+01*Z^2+3.408062544000000E+02*Z^3
3540 RMS(16)=2.320875289999999-5.388500E-04*X
3550 RMS(17)=2.273000-2.200000E-04*X
3560 RMS(18)=2.243999-7.000000E-05*X
3570 RMS(20)=2.236999-3.999999E-05*X
3580 RMS(19)=5.849999E-01*RMS(18)+4.149999E-01*RMS(20)
3590 RMS(21)=RMS(20)
3600 '.........floating doubler PK
3610 Z=LOGLOG10(X-3.199999E-03):PK(1)=8.613445000000000-6.096584950000000*Z+2.617924839999999*Z^2-4.400620800000000E-01*Z^3
3620 Z=LOGLOG10(X-3.199999E-03):PK(2)=8.619954700000000-6.104320100000000*Z+2.609243749999999*Z^2-4.340197800000000E-01*Z^3
3630 Z=LOGLOG10(X-1.399999E-03):PK(3)=8.626281000000000-6.122485680000000*Z+2.620113120000000*Z^2-4.354434100000000E-01*Z^3
3640 Z=LOGLOG10(X):PK(4)=8.651829699999999-6.148852279999999*Z+2.581769629999999*Z^2-4.106555399999999E-01*Z^3
3650 Z=LOGLOG10(X+7.000000E-03):PK(5)=8.649616769999999-6.202511930000000*Z+2.690866550000000*Z^2-4.536009E-01*Z^3
3660 Z=LOGLOG10(X+3.799999E-02):PK(6)=8.722540200000000-6.422295830000000*Z+2.891681319999999*Z^2-5.088723400000000E-01*Z^3
3670 Z=LOGLOG10(X+6.899999E-02):PK(7)=8.805103499999999-6.502859559999999*Z+2.847123699999999*Z^2-4.744677880000000E-01*Z^3
3680 Z=LOGLOG10(X+1.899999E-01):PK(8)=8.993697540000000-6.850369550000000*Z+3.055153779999999*Z^2-5.151423599999999E-01*Z^3
3690 Z=LOGLOG10(X+3.000000E-01):PK(9)=9.100308480000000-6.922432919999999*Z+2.996111870000000*Z^2-4.796532199999999E-01*Z^3
3700 Z=LOGLOG10(X+5.899999E-01):PK(10)=9.297552599999999-7.090110820000000*Z+2.959474979999999*Z^2-4.430498900000000E-01*Z^3
3710 Z=1/(X+7.900000):PK(11)=3.159052999999999+2.740966630000000E+01*Z-1.013561779999999E+02*Z^2+1.339457724000000E+03*Z^3
3720 Z=1/(X+3.500000):PK(12)=3.223444+2.051637040999999E+01*Z-4.026303660000000E+01*Z^2+2.417845725000000E+01*Z^3
3730 Z=1/(X+4.199999):PK(13)=3.193547+2.174921646999999E+01*Z-9.978974039999999E+01*Z^2+1.504303267999999E+02*Z^3
3740 Z=1/(X+5.800000):PK(14)=3.168470999999999+2.303090415000000E+01*Z-1.636456979999999E+02*Z^2+3.770717059999999E+02*Z^3
3750 Z=1/(X+1.110000E+01):PK(15)=3.138210+2.484082669000000E+01*Z-3.458907030000000E+02*Z^2+1.533729541000000E+03*Z^3
3760 Z=1/(X+24):PK(16)=3.150484999999999+1.549889414999999E+01*Z-5.202599340000000E+02*Z^2+5.323704781000000E+03*Z^3
3770 PK(17)=3.203791200000000+8.066999E-04*X-1.506999E-05*X^2+6.999999E-08*X^3
3780 PK(18)=3.171000
3790 PK(19)=3.168999
3800 PK(20)=3.167000
3810 PK(21)=PK(20) :RETURN
3820 '.......grounded doubler VR
3830 Z=LOGLOG10(X+1.659999E-01):VR(1)=1.722468159000000E+02-4.390744559999999E+01*Z-2.420216240000000E+01*Z^2-6.534623669999999*Z^3+5.660369210000000*Z^4
3840 Z=LOGLOG10(X+2.000000E-01):VR(2)=1.728486493999999E+02-4.471330259999999E+01*Z-2.367970599999999E+01*Z^2-6.886574760000000*Z^3+5.746035510000000*Z^4
3850 Z=LOGLOG10(X+3.000000E-01):VR(3)=1.747150430999999E+02-4.763608979999999E+01*Z-2.327409950000000E+01*Z^2-5.643869180000000*Z^3+5.271385089999999*Z^4
3860 Z=LOGLOG10(X+4.399999E-01):VR(4)=1.775476142000000E+02-5.052447520000000E+01*Z-2.187956360000000E+01*Z^2-6.442673349999999*Z^3+5.508768659999999*Z^4
3870 Z=LOGLOG10(X+1):VR(5)=1.905350199000000E+02-6.699479640000000E+01*Z-1.722808219999999E+01*Z^2-4.647765040000000*Z^3+4.698725660000000*Z^4
3880 Z=LOGLOG10(X+8.799999E-01):VR(6)=1.808347000000000E+02-3.676596370000000E+01*Z-5.670391720000000E+01*Z^2+1.812620532999999E+01*Z^3
3890 Z=LOGLOG10(X+7.300000E-01):VR(7)=1.738379960000000E+02-2.585173819999999E+01*Z-6.248987490000000E+01*Z^2+1.915859500000000E+01*Z^3
3900 Z=LOGLOG10(X+9.700000E-01):VR(8)=1.625589039999999E+02+9.232718099999999E-01*Z-8.229210020000000E+01*Z^2+2.379164360000000E+01*Z^3
3910 Z=LOGLOG10(X+1.259999):VR(9)=1.521380E+02+2.403915100999999E+01*Z-9.832637560000000E+01*Z^2+2.734959694000000E+01*Z^3
3920 Z=LOGLOG10(X+2.200000):VR(10)=1.244299999999999E+02+8.551896636999999E+01*Z-1.402334110000000E+02*Z^2+3.642141511999999E+01*Z^3
3930 Z=LOGLOG10(X+5):VR(11)=3.205245000000000E+01+2.397440485000000E+02*Z-2.231054659999999E+02*Z^2+5.087378677999999E+01*Z^3
3940 Z=LOGLOG10(X+8):VR(12)=-5.390098E+01+3.693585916999999E+02*Z-2.859187069999999E+02*Z^2+6.066257529000000E+01*Z^3
3950 Z=LOGLOG10(X+20):VR(13)=-3.908280E+02+8.774114732000000E+02*Z-5.354684610000000E+02*Z^2+1.007478583000000E+02*Z^3
3960 Z=LOGLOG10(X+28):VR(14)=-5.551229E+02+1.073426523000000E+03*Z-6.069165650000000E+02*Z^2+1.081066584000000E+02*Z^3
3970 Z=LOGLOG10(X+65):VR(15)=-2.154919E+03+3.284468879000000E+03*Z-1.613812819999999E+03*Z^2+2.594408810999999E+02*Z^3
3980 VR(16)=2.461015494000000E+01-2.793590E-02*X-9.519099E-04*X^2+5.160000E-06*X^3
3990 VR(17)=1.856896930999999E+01-1.559344E-02*X-3.743899E-04*X^2+1.519999E-06*X^3
4000 VR(18)=1.160350176000000E+01-6.094209E-03*X-5.578999E-05*X^2
4010 VR(20)=6.145999-2.090000E-03*X
4020 VR(19)=5.849999E-01*VR(18)+4.149999E-01*VR(20)
4030 VR(21)=3.134999-3.100000E-04*X
4040 '.......grounded doubler RF
4050 Z=LOGLOG10(X+5.000000E-02):RF(1)=5.221288000000000E-01-8.044873E-02*Z-1.017447699999999E-02*Z^2+5.580159E-03*Z^3
4060 Z=LOGLOG10(X+5.999999E-02):RF(2)=7.467815599999999E-01-1.169214499999999E-01*Z-1.506331E-02*Z^2+8.721089E-03*Z^3
4070 Z=LOGLOG10(X+7.999999E-02):RF(3)=1.309874000000000-2.061096499999999E-01*Z-2.953040E-02*Z^2+1.688713E-02*Z^3
4080 Z=LOGLOG10(X+9.009999E-02):RF(4)=1.750000-2.740209300000000E-01*Z-4.500935E-02*Z^2+2.505535E-02*Z^3
4090 Z=LOGLOG10(X+1.000000E-01):RF(5)=2.623874399999999-4.017152100000000E-01*Z-8.545701E-02*Z^2+4.424671E-02*Z^3
4100 Z=LOGLOG10(X+1.700000E-01):RF(6)=5.250950690000000-7.396265900000000E-01*Z-2.724023799999999E-01*Z^2+1.239206100000000E-01*Z^3
4110 Z=LOGLOG10(X+2.199999E-01):RF(7)=7.466852099999999-9.494127299999999E-01*Z-4.846461E-01*Z^2+2.024863299999999E-01*Z^3
4120 Z=LOGLOG10(X+4.499999E-01):RF(8)=1.286983100000000E+01-1.194064249999999*Z-1.188181039999999*Z^2+4.317822300000000E-01*Z^3
4130 Z=LOGLOG10(X+6.000000E-01):RF(9)=1.690163719000000E+01-1.020286179999999*Z-2.006320639999999*Z^2+6.761215500000000E-01*Z^3
4140 Z=LOGLOG10(X+1.399999):RF(10)=2.448695429999999E+01+4.121357100000000E-01*Z-4.379085800000000*Z^2+1.320032029999999*Z^3
4150 Z=LOGLOG10(X+5):RF(11)=4.175271289999999E+01+1.261919319999999E+01*Z-1.502079610000000E+01*Z^2+3.700485469999999*Z^3
4160 Z=LOGLOG10(X+15):RF(12)=4.531789799999999E+01+4.375877510000000E+01*Z-3.594111410000000E+01*Z^2+7.858683459999999*Z^3
4170 Z=LOGLOG10(X+5.000000E-01):RF(13)=9.310781717000000E+01-5.954210399999999E-01*Z+4.390073E-01*Z^2-7.639999799999999E-01*Z^3
4180 Z=LOGLOG10(X+10):RF(14)=1.421327999999999E+02-5.661861039999999E+01*Z+3.888940854999999E+01*Z^2-8.917544630000000*Z^3
4190 Z=LOGLOG10(X+9):RF(15)=1.866746599999999E+02-7.428345419999999E+01*Z+4.962241911000000E+01*Z^2-1.020929229999999E+01*Z^3
4200 Z=LOGLOG10(X+4):RF(16)=2.153692199999999E+02+1.310550057999999E+01*Z-1.660597790000000E+01*Z^2+6.264513340000000*Z^3
4210 RF(17)=2.471134811999999E+02-9.361825E-02*X+2.108240E-03*X^2-7.720000E-06*X^3
4220 RF(18)=2.791230885000000E+02-7.056038E-02*X+6.895699E-04*X^2-1.320000E-06*X^3
4230 RF(20)=3.028617939000000E+02-4.377961E-02*X+1.136299E-04*X^2+9.000000E-08*X^3
4240 RF(19)=5.849999E-01*RF(18)+4.149999E-01*RF(20)
4250 RF(21)=3.128359E+02-1.408999E-02*X
4260 '.......grounded doubler RMS
4270 Z=LOGLOG10(X+1.000000E-03):RMS(1)=3.713600000000000-1.299709930000000*Z+3.321811600000000E-01*Z^2-1.558370E-02*Z^3
4280 Z=LOGLOG10(X+3.000000E-03):RMS(2)=3.714430000000000-1.303698040000000*Z+3.366563899999999E-01*Z^2-1.694867E-02*Z^3
4290 Z=LOGLOG10(X+9.999999E-03):RMS(3)=3.718860700000000-1.316121600000000*Z+3.457805600000000E-01*Z^2-1.888746E-02*Z^3
4300 Z=LOGLOG10(X+1.700000E-02):RMS(4)=3.724056-1.326439160000000*Z+3.503464800000000E-01*Z^2-1.912277E-02*Z^3
4310 Z=LOGLOG10(X+3.900000E-02):RMS(5)=3.733300000000000-1.357680049999999*Z+3.835031799999999E-01*Z^2-2.929675E-02*Z^3
4320 Z=LOGLOG10(X+1.260000E-01):RMS(6)=3.774349999999999-1.437518590000000*Z+4.324683200000000E-01*Z^2-3.881562E-02*Z^3
4330 Z=LOGLOG10(X+2.300000E-01):RMS(7)=3.814343499999999-1.514106100000000*Z+4.813996200000000E-01*Z^2-4.913216E-02*Z^3
4340 Z=LOGLOG10(X+5.899999E-01):RMS(8)=3.937109999999999-1.733196049999999*Z+6.149279799999999E-01*Z^2-7.649500E-02*Z^3
4350 Z=LOGLOG10(X+9.200000E-01):RMS(9)=4.021532699999999-1.858132299999999*Z+6.737171099999999E-01*Z^2-8.510263E-02*Z^3
4360 Z=LOGLOG10(X+1.799999):RMS(10)=4.253835429999999-2.229696589999999*Z+8.749961E-01*Z^2-1.218339200000000E-01*Z^3
4370 Z=LOGLOG10(X+6):RMS(11)=5.478497729999999-4.171632820000000*Z+1.920282319999999*Z^2-3.117164E-01*Z^3
4380 Z=LOGLOG10(X+10):RMS(12)=6.269678399999999-5.237649719999999*Z+2.391971369999999*Z^2-3.795014099999999E-01*Z^3
4390 Z=LOGLOG10(X+1.799999):RMS(13)=2.762768700000000+1.653227700000000E-01*Z-4.210984499999999E-01*Z^2+1.133802400000000E-01*Z^3
4400 Z=LOGLOG10(X+3.500000):RMS(14)=2.597501170000000+3.822034200000000E-01*Z-5.199744300000000E-01*Z^2+1.290496299999999E-01*Z^3
4410 Z=LOGLOG10(X+5):RMS(15)=2.405145040000000+4.857140900000000E-01*Z-4.844622E-01*Z^2+1.087636899999999E-01*Z^3
4420 RMS(16)=2.388549130000000-1.753240E-03*X+7.260000E-06*X^2
4430 RMS(17)=2.332000-5.699999E-04*X
4440 RMS(18)=2.273999-1.599999E-04*X
4450 RMS(20)=2.243000
4460 RMS(19)=5.849999E-01*RMS(18)+4.149999E-01*RMS(20)
4470 RMS(21)=2.237999
4480 '........grounded doubler PK
4490 Z=LOGLOG10(X-3.800000E-03):PK(1)=8.621852000000000-6.100277940000000*Z+2.593900690000000*Z^2-4.271558599999999E-01*Z^3
4500 Z=LOGLOG10(X-2.799999E-03):PK(2)=8.606567999999999-6.099351329999999*Z+2.646264820000000*Z^2-4.535805899999999E-01*Z^3
4510 Z=LOGLOG10(X-8.999999E-04):PK(3)=8.611094599999999-6.122940099999999*Z+2.673080520000000*Z^2-4.617662299999999E-01*Z^3
4520 Z=LOGLOG10(X):PK(4)=8.650168770000000-6.157316389999999*Z+2.602619550000000*Z^2-4.191983800000000E-01*Z^3
4530 Z=LOGLOG10(X+7.000000E-03):PK(5)=8.654286799999999-6.226046949999999*Z+2.722407079999999*Z^2-4.644547300000000E-01*Z^3
4540 Z=LOGLOG10(X+3.599999E-02):PK(6)=8.759313099999999-6.471108560000000*Z+2.888881790000000*Z^2-4.988147100000000E-01*Z^3
4550 Z=LOGLOG10(X+6.801000E-02):PK(7)=8.864000-6.628721439999999*Z+2.935742010000000*Z^2-4.946177100000000E-01*Z^3
4560 Z=LOGLOG10(X+1.759999E-01):PK(8)=9.113299100000000-6.971772190000000*Z+3.044147590000000*Z^2-4.929428799999999E-01*Z^3
4570 Z=LOGLOG10(X+2.849999E-01):PK(9)=9.309882669999999-7.226508620000000*Z+3.125689329999999*Z^2-4.939100E-01*Z^3
4580 Z=LOGLOG10(X+5.849999E-01):PK(10)=9.793341000000000-7.948985850000000*Z+3.474625169999999*Z^2-5.477488100000000E-01*Z^3
4590 Z=LOGLOG10(X+2.200000):PK(11)=1.209898875999999E+01-1.145762560000000E+01*Z+5.272525169999999*Z^2-8.565583E-01*Z^3
4600 Z=LOGLOG10(X+6):PK(12)=2.044162800000000E+01-2.532084629999999E+01*Z+1.304173753999999E+01*Z^2-2.315705979999999*Z^3
4610 Z=1/(X+4.900000):PK(13)=3.142803999999999+3.242109313999999E+01*Z-1.115407560000000E+02*Z^2+1.095832929999999E+02*Z^3
4620 Z=1/(X+5.599999):PK(14)=3.122565+3.765490793000000E+01*Z-1.977499670000000E+02*Z^2+3.375824572000000E+02*Z^3
4630 Z=1/(X+7.800000):PK(15)=3.096990000000000+4.793314565000000E+01*Z-4.314557110000000E+02*Z^2+1.274699683999999E+03*Z^3
4640 Z=1/(X+23):PK(16)=2.886017200000000+1.076458970999999E+02*Z-3.115163099999999E+03*Z^2+2.905357263000000E+04*Z^3
4650 PK(17)=3.768399879999999+4.771099E-03*X-1.369700E-04*X^2+7.099999E-07*X^3
4660 PK(18)=3.447027789999999+1.980470E-03*X-1.576000E-05*X^2
4670 PK(20)=3.254352289999999+4.859000E-04*X
4680 PK(19)=5.849999E-01*PK(18)+4.149999E-01*PK(20)
4690 PK(21)=3.190000+1.500000E-04*X :RETURN
4700 Y=Y1+(Y2-Y1)*LOG(X/X1)/LOG(X2/X1) :RETURN
4710 LOCATE 17:PRINT :COLOR 0,7
4720 PRINT "                                      "
4730 PRINT "                   > +"
4740 PRINT " )( diode          "
4750 PRINT " Vac        )(            C   RL  Vdc"
4760 PRINT " )(Ŀ                "
4770 PRINT " transformer      -"
4780 COLOR 7,0:RETURN 660
4790 LOCATE 17:PRINT:COLOR 0,7
4800 PRINT "                diodes   +"
4810 PRINT " )(>           "
4820 PRINT " Vac        )(ĳĿ  C  RL Vdc  "
4830 PRINT " )(>            "
4840 PRINT " transformer           -"
4850 COLOR 7,0:RETURN 660
4860 LOCATE 17:PRINT:COLOR 0,7
4870 PRINT "               Ŀ                "
4880 PRINT " )( >>ÿ            "
4890 PRINT " Vac       )(  ڴ diodes +"
4900 PRINT " )(Ŀ>>          "
4910 PRINT " transformer       C  RL Vdc  "
4920 PRINT "                 -"
4930 COLOR 7,0:RETURN 660
4940 LOCATE 17:PRINT:COLOR 0,7
4950 PRINT "                    diode          "
4960 PRINT " )(> + "
4970 PRINT " Vac       )(          C         "
4980 PRINT " )(ĳĴ    RL Vdc"
4990 PRINT " transformer     diode C         "
5000 PRINT "                ĳ< -"
5010 COLOR 7,0:RETURN 660
5020 LOCATE 17:PRINT:COLOR 0,7
5030 PRINT "                         diode        "
5040 PRINT " )(C+> +"
5050 PRINT " Vac       )(              +      "
5060 PRINT " )(>    C  RL Vdc"
5070 PRINT " transformer      diode           "
5080 PRINT "                   -"
5090 COLOR 7,0:RETURN 660
5100 '
5110 '.....prep display prior to PRT
5120 FOR Z=18 TO 20
5130 LOCATE Z,41:PRINT STRING$(39,32)
5140 NEXT Z
5150 '
5160 '.....PRT
5170 KEY OFF:GOSUB 5240:LOCATE 25,5:COLOR 0,2
5180 PRINT " Send this page to:(1)Printer Queue? (2)Printout? ";
5190 PRINT "(3)Next page? (1/2/3)";:COLOR 7,0
5200 Z$=INKEY$:IF Z$<"1"OR Z$>"3"THEN 5200 ELSE GOSUB 5240
5210 IF Z$="3"THEN RETURN
5220 FOR I%=1 TO 24:FOR J%=1 TO 80:LPRINT CHR$(SCREEN(I%,J%));:NEXT J%:NEXT I%
5230 IF Z$="2"THEN LPRINT CHR$(12) ELSE 5170
5240 LOCATE 25,1:PRINT STRING$(80,32);:RETURN
5250 '.........Program description.
5260 'When power supply parameters are normalized, they become functions of
5270 'only a few variables, Thus, Vdc/Vpk, Vpp/Vdc, Irms/Idc, and Ipk/Idc are
5280 'functions of the AC input Vpk, the source resistance to load resistance
5290 'ratio RS/RL, and W*C*RL, where W=2*pi*Freq, C is the filter capacitance
5300 'and RL is the load resistance. This program is based on data taken with
5310 'an accurate time step program. Values of Vdc/Vpk etc were taken for a
5320 'range of RS/RL values for fixed WCRL values. Equations were then generated
5330 'so that, for specific values of WCRL, any RS/RL value gives values for
5340 'Vdc/Vpk, Vpp/Vdc. Irms/Idc, and Ipk/Idc. For other values of WCRL, an
5350 'interpolation routine is used. Given the transformer parameters, the
5360 'frequency, the filter capacitance C and the load RL, fimal values are
5370 'readily calculated. The program covers values of RS/RL from .02% to 100%,
5380 'and WCRL values from .1 to 1000.
6000 FUNCTION LOGLOG10(X)
6010 LOGLOG10 = LOG(X)/LOG(10)
6020 END FUNCTION
