1 COMMON A, AL, B, BASEONLY, C, C$, C1, CAT$, CC, CKT$, D, D$, DD, DIA, DIMN$, DMS, E, EO, EX$, F, F$, FD, FF, FQ, FRQ, G$, GO$, I, I$, L, LATLONG, LD, LL, LN, LS, LW, LX, MAX, MENU, MIN, MX, N, NN, NT, OV, P, PI, PROG$, Q, QQ, QU, R, RA, RC, T, T$, U, U$, UH, UL$, V$, VC, W, WHIP, WIRD, WW, X, X$, X1, XS, Z$, ZP, ZS
5 'OMMON EX$,PROG$
10 'MATFILT - 05 MAR 2010
20 CLS:KEY OFF
30 IF EX$=""THEN EX$="EXIT"
40 IF PROG$=""THEN GO$=EX$ ELSE GO$=PROG$
50 
60 PROG$="MATFILT"
70 '.....title page
80 MHZ=10^6:TP=8*ATN(1) :DIM LDB(525) :DIM R(15) :DIM G(1575)
90 FOR P=1 TO 525 :READ LDB(P) :NEXT P 'put data into LDB(P) array
100 FOR P=1 TO 1575 :READ G(P) :NEXT P 'put values into G(P) array
110 COLOR 15,2
120 PRINT " FILTERS, IMPEDANCE MATCHING";TAB(61);"by R.J.Dehoney IEEE ";
130 COLOR 7,0
140 '.....start
150 PRINT
160 PRINT "This program is based on George Matthaei's work on Chebyshev Impedance";
170 PRINT "Matching Networks, as reported in the August 1964 IEEE Proceedings. The";
180 PRINT "networks are in low pass network form, but since RL does not equal RS,there is";
190 PRINT "unequal RS and RL, but they have a fixed mismatch loss across the band. The";
200 PRINT "filters designed here have a restricted bandwidth, but have only the ripple";
210 PRINT "loss in the pass band. Required inputs are FH-the upper edge of the pass band,";
220 PRINT "FL-the lower edge of the pass band, RS-the source impedance, RL-the load";
230 PRINT "impedance, and LDB-the allowable pass band ripple. With these inputs, N, the";
240 PRINT "number of reactive elements can be determined along with the high side roll-off.";
250 PRINT "The ratio of RL to RS is limited to fixed values in the range 1.5 to 50 (or,";
260 PRINT "flipping the filter, 0.6667 to 0.02) and the ratio of FH to FL must be selected";
270 PRINT "from values ranging from 1.105 to 3. An example is included showing how to";
280 PRINT "interpolate to obtain intermediate values."
290 PRINT
300 PRINT "The matching filters can also be transformed into hi-pass configurations."
310 GOSUB 4260:CLS
320 '.....start
330 PRINT
340 PRINT " Press 'e'for examples"
350 PRINT "  - or -"
360 PRINT " Press `c' to  continue";
370 PRINT "  - or -"
380 PRINT " Press `x' to EXIT"
390 A$=INKEY$ :IF A$="" THEN 390
400 IF A$="x"THEN RUN GO$
410 IF A$="c"THEN CLS:GOTO 440
420 IF A$="e" THEN CLS:GOTO 2000
430 GOTO 390
440 '.....examples
450 PRINT
460 INPUT " ENTER: Upper pass band frequency FH in MHz";FH
470 CLS
480 PRINT :PRINT "      Allowable values for lower passband frequency FL"
490 W(1)=1.000000E-01 :W(2)=2.000000E-01 :W(3)=3.000000E-01 :W(4)=4.000000E-01 :W(5)=6.000000E-01 :W(6)=8.000000E-01 :W(7)=1
500 PRINT "         Frequency           Lower passband frequency, MHz"
510 FOR P=1 TO 7 :KW=(2-W(P))/(2+W(P)) :A$=CHR$(P+96)
520 PRINT USING "            \\                   ####.### ";A$;KW*FH :NEXT P
530 INPUT " ENTER: a lower case letter to select lower passband frequency FL";B$:IF B$="" THEN 470
540 P=ASC(B$)-96 :IF P<1 OR P>7 THEN 470
550 FL=(2-W(P))/(2+W(P))*FH :KW=P :W0=TP*(FH+FL)/2*10^6
560 R(1)=1.500000 :R(2)=2 :R(3)=2.500000 :R(4)=3 :R(5)=4 :R(6)=5 :R(7)=6 :R(8)=8 :R(9)=10
570 R(10)=15 :R(11)=20 :R(12)=25 :R(13)=30 :R(14)=40 :R(15)=50
580 INPUT " ENTER: Source impedance RS, ohms";RS
590 CLS :PRINT
600 PRINT "Allowable values for RL:"
610 PRINT "  RL>RS      RL<RS"
620 PRINT "   Load letter  Value    Load letter  Value";
630 FOR P=1 TO 15 :A$=CHR$(P+64) :B$=CHR$(P+96)
640 PRINT USING "      \ \    #####.#          \ \ #####.#### ";A$;R(P)*RS;B$;RS/R(P)
650 NEXT P 'prints list of RS*(allowable ratios of R), also inverse
660 PRINT :INPUT " ENTER: an upper case or lower case letter to select RL";KR$ :IF KR$="" THEN 590
670 KR=ASC(KR$) :IF KR>79 AND KR<97 THEN 590
680 IF KR<65 OR KR>111 THEN 590
690 KR=KR-64
700 IF KR>15 THEN FLAG=1 :KR=KR-32
710 R=KR/2+1 :IF KR>4 THEN R=KR-1
720 IF KR=8 THEN R=8
730 IF KR>8 THEN R=5*(KR-7)
740 IF KR>13 THEN R=10*(KR-10)
750 IF FLAG=1 THEN RL=RS/R ELSE RL=R*RS
760 PRINT "   N     Ripple dB";
770 FOR M=1 TO 5 :X=KR+15*(KW-1)+105*(M-1) :RIP=LDB(X) :IF RIP>1.000000E-03 THEN M1=M       :GOTO 780 ELSE 790
780 PRINT USING "  ##      #.#### ";2*M;LDB(X)
790 NEXT M
800 INPUT "Enter number of reactive elements, N ",N
810 IF N<2 OR N>2*M1 THEN 800
820 '----now that we know KR, KW and N, we can find the g values.
830 X1=KR+15*(KW-1)+105*(N/2-1) :G1=G(X1)
840 IF N>2 THEN X2=X1+4*105 :G2=G(X2)
850 IF N>4 THEN X3=X2+3*105 :G3=G(X3)
860 IF N>6 THEN X4=X3+2*105 :G4=G(X4)
870 IF N>8 THEN X5=X4+105 :G5=G(X5)
880 IF N=2 THEN G2=G1/R
890 IF N=4 THEN G3=G2*R :G4=G1/R
900 IF N=6 THEN G4=G3/R :G5=G2*R :G6=G1/R
910 IF N=8 THEN G5=G4*R :G6=G3/R :G7=G2*R :G8=G1/R
920 IF N=10 THEN G6=G5/R :G7=G4*R :G8=G3/R :G9=G2*R :G10=G1/R
930 IF FLAG=1 THEN 1470
940 IF N>2 THEN 1030
950 L1=G1*RS/W0 :C2=G2/RS/W0 :CLS :PRINT :PRINT :PRINT
960 PRINT       "        N=2 FL=";FL;" FH=";FH;"  Ripple=";LDB(X1)
970 PRINT USING "         RSL1Ŀ   RS=###";RS
980 PRINT USING "                     L1=##.###^^^^";L1
990 PRINT USING "        Vin     C2  RL  C2=##.###^^^^";C2
1000 PRINT USING "                     RL=####.#";RL
1010 PRINT       "         "
1020 GOSUB 4260:CLS:GOTO 320
1030 IF N>4 THEN 1120
1040 CLS :PRINT :PRINT :PRINT     "       N=4   FL=";FL;"  FH=";FH;" Ripple=";LDB(X1)
1050 L1=G1*RS/W0 :C2=G2/RS/W0 :L3=G3*RS/W0 :C4=G4/RS/W0
1060 PRINT USING "      RSL1L3Ŀ   RS=###";RS
1070 PRINT USING "                       L1=##.###^^^^  L3=##.###^^^^";L1;L3
1080 PRINT USING "     Vin     C2    C4  RL  C2=##.###^^^^  C4=##.###^^^^";C2;C4
1090 PRINT USING "                       RL=####.#";RL
1100 PRINT       "       "
1110 GOSUB 4260:CLS:GOTO 320
1120 IF N>6 THEN 1230
1130 L1=G1*RS/W0 :C2=G2/RS/W0 :L3=G3*RS/W0 :C4=G4/RS/W0 :L5=G5*RS/W0:C6=G6/RS/W0
1140 CLS :PRINT :PRINT :PRINT    "       N=6    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1150 PRINT       "         RSL1L3L5Ŀ";
1160 PRINT USING "                             RS=####.#";RS
1170 PRINT USING "        Vin     C2   C4   C6  RL  RL=####.#";RL
1180 PRINT       "                          ";
1190 PRINT       "         ";
1200 PRINT USING "L1=##.###^^^^ L3=##.###^^^^ L5=##.###^^^^";L1;L3;L5
1210 PRINT USING "C2=##.###^^^^ C4=##.###^^^^ C6=##.###^^^^";C2;C4;C6
1220 GOSUB 4260:CLS:GOTO 320
1230 IF N>8 THEN 1350
1240 L1=G1*RS/W0 :C2=G2/RS/W0 :L3=G3*RS/W0 :C4=G4/RS/W0 :L5=G5*RS/W0:C6=G6/RS/W0
1250 L7=G7*RS/W0 :C8=G8/RS/W0 :CLS
1260 PRINT :PRINT :PRINT   "           N=8    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1270 PRINT       "         RSL1L3L5L7Ŀ";
1280 PRINT USING "                                 RS=####.#";RS
1290 PRINT USING "        Vin     C2   C4   C6   C8  RL  RL=####.#";RL
1300 PRINT       "                              ";
1310 PRINT       "         ";
1320 PRINT USING "L1=##.###^^^^ L2=##.###^^^^ L5=##.###^^^^ L7=##.###^^^^";L1;L3;L5;L7
1330 PRINT USING "C2=##.###^^^^ C4=##.###^^^^ C6=##.###^^^^ C8=##.###^^^^";C2;C4;C6;C8
1340 GOSUB 4260:CLS:GOTO 320
1350 '---N=10---
1360 L1=G1*RS/W0 :C2=G2/RS/W0 :L3=G3*RS/W0 :C4=G4/RS/W0 :L5=G5*RS/W0:C6=G6/RS/W0
1370 L7=G7*RS/W0 :C8=G8/RS/W0 :L9=G9*RS/W0 :C10=G10/RS/W0 :CLS
1380 PRINT :PRINT :PRINT    "          N=10    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1390 PRINT       "         RSL1L3L5L7L8Ŀ";
1400 PRINT USING "                                     RS=###.#";RS
1410 PRINT USING "        Vin     C2   C4   C6   C8   C10 RL  RL=####.##";RL
1420 PRINT       "                                  ";
1430 PRINT       "         ";
1440 PRINT USING "L1=##.###^^^^ L2=##.###^^^^ L5=##.###^^^^ L7=##.###^^^^ L9=##.###^^^^";L1;L3;L5;L7;L9
1450 PRINT USING "C2=##.###^^^^ C4=##.###^^^^ C6=##.###^^^^ C8=##.###^^^^ C10=##.###^^^^";C2;C4;C6;C8;C10
1460 GOSUB 4260:CLS:GOTO 320
1470 IF N>2 THEN 1560
1480 C1=G1/RS/W0 :L2=G1/R*RS/W0 :CLS :PRINT :PRINT :PRINT
1490 PRINT       "        N=2 FL=";FL;" FH=";FH;" Ripple=";LDB(X1)
1500 PRINT USING "         RSL2Ŀ   RS=###";RS
1510 PRINT USING "                    C1=##.###^^^^";C1
1520 PRINT USING "        Vin  C1    RL  L2=##.###^^^^";L2
1530 PRINT USING "                    RL=##.###";RL
1540 PRINT       "         "
1550 GOSUB 4260:CLS:GOTO 320
1560 IF N>4 THEN 1650
1570 C1=G1/RS/W0 :L2=G2*RS/W0 :C3=G3/RS/W0 :L4=G4*RS/W0 :CLS
1580 PRINT :PRINT :PRINT      "           N=4   FL=";FL;"  FH=";FH;" Ripple=";LDB(X1)
1590 PRINT USING "        RSL2L4Ŀ   RS=###";RS
1600 PRINT USING "                       C1=##.###^^^^  C3=##.###^^^^";C1;C3
1610 PRINT USING "       Vin  C1    C3    RL L2=##.###^^^^  L4=##.###^^^^";L2;L4
1620 PRINT USING "                        RL=##.###";RL
1630 PRINT       "         "
1640 GOSUB 4260:CLS:GOTO 320
1650 IF N>6 THEN 1760
1660 C1=G1/RS/W0 :L2=G2*RS/W0 :C3=G3/RS/W0 :L4=G4*RS/W0 :C5=G5/RS/W0:L6=G6*RS/W0
1670 CLS :PRINT :PRINT :PRINT   "      N=6    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1680 PRINT       "         RSL2L4L6Ŀ";
1690 PRINT USING "                            RS=####.#";RS
1700 PRINT USING "        Vin   C1   C3   C5   RL  RL=##.###";RL
1710 PRINT       "                         ";
1720 PRINT       "         ";
1730 PRINT USING "C1=##.###^^^^ C2=##.###^^^^ C5=##.###^^^^";C1;C3;C5
1740 PRINT USING "L2=##.###^^^^ L4=##.###^^^^ L6=##.###^^^^";L2;L4;L6
1750 GOSUB 4260:CLS:GOTO 320
1760 IF N>8 THEN 1880
1770 C1=G1/RS/W0 :L2=G2*RS/W0 :C3=G3/RS/W0 :L4=G4*RS/W0 :C5=G5/RS/W0:L6=G6*RS/W0
1780 C7=G7/RS/W0 :L8=G8*RS/W0 :CLS
1790 PRINT :PRINT :PRINT   "           N=8    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1800 PRINT       "         RSL2L4L6L8Ŀ";
1810 PRINT USING "                                RS=####.#";RS
1820 PRINT USING "        Vin  C1   C3   C5   C7    RL  RL=####.#";RL
1830 PRINT       "                             ";
1840 PRINT       "         ";
1850 PRINT USING "C1=##.###^^^^ C2=##.###^^^^ C5=##.###^^^^ C7=##.###^^^^";C1;C3;C5;C7
1860 PRINT USING "L2=##.###^^^^ L4=##.###^^^^ L6=##.###^^^^ L8=##.###^^^^";L2;L4;L6;L8
1870 GOSUB 4260:CLS:GOTO 320
1880 '---N=10---
1890 C1=G1/RS/W0 :L2=G2*RS/W0 :C3=G3/RS/W0 :L4=G4*RS/W0 :C5=G5/RS/W0:L6=G6*RS/W0
1900 C7=G7/RS/W0 :L8=G8*RS/W0 :C9=G9/RS/W0 :L10=G10*RS/W0 :CLS
1910 PRINT :PRINT :PRINT  "           N=10    FL=";FL;"   FH=";FH;" Ripple=";LDB(X1)
1920 PRINT       "         RSL2L4L6L8L10Ŀ";
1930 PRINT USING "                                      RS=####.#";RS
1940 PRINT USING "        Vin   C1   C3   C5   C7   C9     RL  RL=####.#";RL
1950 PRINT       "                                   ";
1960 PRINT       "         ";
1970 PRINT USING "C1=##.###^^^^ C2=##.###^^^^ C5=##.###^^^^ C7=##.###^^^^ C9=##.###^^^^";C1;C3;C5;C7;C9
1980 PRINT USING "L2=##.###^^^^ L4=##.###^^^^ L6=##.###^^^^ L8=##.###^^^^ L10=##.###^^^^";L2;L4;L6;L8;L10
1990 GOSUB 4260:CLS:GOTO 320
2000 PRINT:PRINT ;"             ----------------Examples---------------";
2010 PRINT "First, we'll try one using the tabulated values. We'll choose FH=25 MHz,";
2020 PRINT "FL=16.6667 MHz, RS=50 ohms, and RL=400 ohms. We choose N=4 giving us .0422 dB";
2030 PRINT "ripple. This gives us:";
2040 PRINT       "      N=4  FL=15  FH=25  Ripple=.0422";
2050 PRINT       "      RSL1L3Ŀ   RS=50 ohms";
2060 PRINT       "                       L1=5.970E-7, L3=1.827E-6 henries";
2070 PRINT       "    Vin      C2    C4  RL  C2=9.137E-11, C4=2.985E-11 farads";
2080 PRINT       "                       RL=400 ohms";
2090 PRINT       "      ";
2100 PRINT "A circuit analysis program gives us the following results:";
2110 PRINT "     Freq, MHz Insertion loss dB";
2120 PRINT "         0         4.03";
2130 PRINT "        16.67      0.042   We see that, as expected, the";
2140 PRINT "        18.15      0.000   output has a 0.042 dB ripple";
2150 PRINT "        21.25      0.042   from 16.67 to 25 MHz, a roll-off";
2160 PRINT "        23.96      0.000   at F=0 of 4 dB due to mismatch loss,";
2170 PRINT "        25.00      0.042   and a high side roll-off. The filter";
2180 PRINT "        40.00     18.072   overcomes the 4 dB mismatch loss.";
2190 PRINT "        50.00     28.771";
2200 PRINT ";
2210 GOSUB 4260:CLS
2220 PRINT:PRINT ;"Now we'll try interpolating. Let's say we need to drive a 10 ohm load from";
2230 PRINT "a 120 ohm source from 10 to 15 MHz. We start by entering FH=15 and RS=120.";
2240 PRINT "We see that 12 ohms and 8 ohms are tabulated, but not 10 ohms. Not to worry.";
2250 PRINT "We get values for both 12 ohms and 8 ohms for N=4, then, assuming linear";
2260 PRINT "interpolation, find values for 10 ohms. The values turn out to be:";
2270 PRINT "     RL=12          RL=8       RL=10";
2280 PRINT " C1  1.796E-10    2.067E-10   1.932E-10 farads";
2290 PRINT " L2  8.555E-7     7.570E-7    8.062E-7  henries";
2300 PRINT " C3  5.941E-10    7.885E-10   6.913E-10 farads";
2310 PRINT " L4  2.587E-7     1.984E-7    2.286E-7  henries "
2320 PRINT " We check the performance of the RL=10 filter and get:";
2330 PRINT "         Freq, MHz   Insertion loss, dB";
2340 PRINT "            10.00        0.0658   The results are quite gratifying";
2350 PRINT "            10.85        0.00139  but filters obtained through this";
2360 PRINT "            12.66        0.06257  method should always be checked";
2370 PRINT "            14.20        0.00106  with an analysis program.";
2380 PRINT "            15.00        0.1090";
2390 PRINT "The interpolation scheme is simply similar triangles. For instance,";
2400 PRINT "(C1X-C1B)/(RX-RB)=(C1A-C1B)/(RA-RB), where C1X is the unknown value of C1,";
2410 PRINT "RX=10, RA=12, RB=8, C1A is C1 at RL=RA, and C1B is C1 at RL=RB, then";
2420 PRINT "   C1X=[(1.796-2.067)/(12-8)*(10-8)+2.067]E-10 and so on.";
2430 GOSUB 4260:CLS:GOTO 2440
2440 PRINT :PRINT "Sometimes our load is complex and we would like to absorb seris L or shunt C
2450 PRINT "into the filter. If RL is greater than RS, we can handle shunt C, but what can";
2460 PRINT "we do if we have shunt C with RL less than RS? One trick is as follows:";
2470 PRINT "Assume we have a 10 ohm load shunted with a 1000 pF capacitance. We want to";
2480 PRINT "match this to 50 ohms from 10 to 15 MHz. We first design a filter matching";
2490 PRINT "a 5 ohm source to a 10 ohm load. This gives us a filter with a shunt C across";
2500 PRINT "the load, allowing us to at least partially absorb our load C. We then add a";
2510 PRINT "section matching a 50 ohm source to a 5 ohm load. This is what we get:";
2520 PRINT "     Initial match              Final match";
2530 PRINT "     RS1L1Ŀ       RS2L4L6L1Ŀ";
2540 PRINT "                                           CX=0.249E-9";
2550 PRINT "    VS       C2 RL      VS     C3   C5     CX RL CL CL=1.0E-9";
2560 PRINT "                                           CX+CL=C2";
2570 PRINT "            ";
2580 PRINT "   RS1=5 ohms RL=10 ohms   RS2=50 ohms RL=10 ohms";
2590 PRINT "   L1=6.243E-8 henries     C3=4.311E-10  C5=1.430E-9 farads";
2600 PRINT "   C2=1.249E-9 farads      L4=3.564E-7   L6=1.080E-7 henries";
2610 PRINT "                        Results:";
2620 PRINT "Frequency MHz      10.00   10.58   11.56   13.38   14.50   15.00";
2630 PRINT "Insertion Loss dB  0.2285  0.0861  0.0015  0.0740  0.0399  0.0862";
2640 GOSUB 4260:CLS:GOSUB 4360 :GOTO 320
2650 '-------------LDB2------------
2660 DATA .001800,.005398,.009712,.014381,.024240,.034434,.044782,.065671,          .086637,.138917,.190748,.242036,.292759,.392511,.490055
2670 DATA .007090,.021235,.038148,.056397,.094750,.134143,.173863,.253235,          .331840,.523445,.707556,.884410,1.05445,1.37594,1.67535
2680 DATA .015549,.046482,.083313,.122863,.205359,.289233,.372948,.537751,          .697855,1.07618,1.42530,1.74884,2.05014,2.59671,3.08228
2690 DATA .026687,.079573,.142197,.209037,.347127,.485751,.622407,.836733,           1.13795,1.71210,2.22074,2.67658,3.08935,3.81341,4.43402
2700 DATA .054487,.161453,.286429,.417880,.683492,.942628,1.19134,1.65534,           2.07792,2.98813,3.74255,4.38591,4.94650,5.88881,6.66291
2710 DATA .085225,.250817,.441537,.639116,1.02961,1.40036,1.74770,2.37619,           2.92951,4.07171,4.97794,5.72825,5.36822,7.42049,8.26714
2720 DATA .114295,.334238,.584260,.839801,1.33539,1.79552,2.21849,2.96665,           3.60972,4.90052,5.89726,6.70839,7.39203,8.50279,9.38680
2730 '-------------------LDB4.BAS----------------------
2740 DATA .000005,.000014,.000024,.000036,.000061,.000087,.000113,.000166,          .000220,.000355,.000490,.000625,.000761,.001032,.001303
2750 DATA .000072,.000217,.000391,.000579,.000977,.001389,.001809,.002659,          .003516,.005670,.007830,.009993,.012155,.016479,.020801
2760 DATA .000366,.001098,.001976,.002928,.004939,.007023,.009142,.013432,          .017754,.028605,.039465,.050312,.061140,.082725,.104210
2770 DATA .001154,.003462,.006229,.009226,.015557,.022109,.028765,.042219,          .055746,.089577,.123258,.156725,.189958,.255704,.320490
2780 DATA .005765,.017273,.031042,.045910,.077193,.109378,.141885,.207003,          .271701,.430265,.583748,.732186,.875812,1.14969,1.40739
2790 DATA .017581,.052530,.094102,.138693,.231538,.325710,.419483,.603465,          .781440,1.19921,1.58151,1.93332,2.25897,2.84532,3.36201
2800 DATA .039890,.118586,.211177,.309306,.509855,.708365,.901453,1.26813,          1.60901,2.36390,3.00880,3.57090,4.06884,4.92088,5.63309
2810 '-------------------LDB6.BAS---------------
2820 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,           .000001,.000001,.000001,.000002,.000002,.000003,.000003
2830 DATA .000001,.000002,.000004,.000006,.000010,.000014,.000018,.000027,           .000035,.000057,.000078,.000100,.000122,.000165,.000209
2840 DATA .000008,.000025,.000044,.000066,.000111,.000158,.000206,.000303,           .000401,.000646,.000893,.001140,.001387,.001881,.002375
2850 DATA .000046,.000139,.000250,.000371,.000625,.000889,.001158,.001702,           .002250,.003630,.005013,.006398,.007784,.010555,.013325
2860 DATA .000527,.001580,.002844,.004213,.007107,.010105,.013153,.019321,           .025532,.041114,.056692,.072235,.087732,.118578,.149217
2870 DATA .002940,.008813,.015850,.023462,.039518,.056097,.072901,.106746,           .140614,.224636,.307336,.388599,.468422,.623873,.774001
2880 DATA .010951,.032769,.058808,.086841,.145553,.205574,.265808,.385332,           .502630,.784325,1.04972,1.30015,1.53707,1.97556,2.37394
2890 '-------------LDB8.BAS-----------
2900 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,           .000000,.000000,.000000,.000000,.000000,.000000,.000000
2910 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,           .000000,.000001,.000001,.000001,.000001,.000002,.000002
2920 DATA .000000,.000001,.000001,.000001,.000003,.000004,.000005,.000007,           .000009,.000015,.000020,.000026,.000031,.000042,.000053
2930 DATA .000002,.000006,.000010,.000015,.000025,.000036,.000046,.000068,           .000090,.000145,.000201,.000256,.000312,.000423,.000534
2940 DATA .000047,.000142,.300256,.000380,.000641,.000912,.001187,.001745,           .002307,.003721,.005139,.006559,.007979,.010820,.013660
2950 DATA .000474,.001421,.002557,.003788,.006391,.009086,.011827,.017375,           .022963,.036984,.051006,.065002,.078962,.106762,.134394
2960 DATA .002805,.008408,.015123,.022386,.037710,.053534,.069577,.101897,           .134250,.214561,.293676,.371479,.447963,.597078,.741291
2970 '--------------------LDB10.BAS------------------
2980 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,          .000000,.000000,.000000,.000000,.000000,.000000,.000000
2990 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,          .000000,.000000,.000000,.000000,.000000,.000000,.000000
3000 DATA .000000,.000000,.000000,.000000,.000000,.000000,.000000,.000000,          .000000,.000000,.000000,.000001,.000001,.000001,.000001
3010 DATA .000000,.000000,.000000,.000001,.000001,.000001,.000002,.000003,          .000004,.000006,.000008,.000010,.000012,.000017,.000021
3020 DATA .000004,.000013,.000023,.000034,.000058,.000082,.000107,.000157,          .000208,.000335,.000453,.000591,.000719,.000975,.001231
3030 DATA .000076,.000228,.000410,.000607,.001024,.001457,.001897,.002788,          .003686,.005945,.008210,.010477,.012745,.017278,.021808
3040 DATA .000705,.002116,.003808,.005640,.009514,.013524,.017601,.025849,          .034152,.054960,.075739,.096447,.117070,.158045,.198650
3050 '---------------G1N2.BAS---------------
3060 DATA .706219,.998752,1.22321,1.41245,1.72989,1.99750,2.23328,2.64245,           2.99626,3.73699,4.35346,4.89287,5.37845,6.23721,6.99127
3070 DATA .703597,.995037,1.21867,1.40720,1.72345,1.99007,2.22497,2.63262,           2.98511,3.72309,4.33727,4.87467,5.35844,6.21400,6.96526
3080 DATA .699283,.988936,1.21119,1.39857,1.71289,1.97787,2.21133,2.61648,           2.96681,3.70026,4.31067,4.84478,5.32559,6.17590,6.92255
3090 DATA .693375,.980581,1.20096,1.38675,1.69842,1.96116,2.19265,2.59437,           2.94174,3.66900,4.27425,4.80384,5.28059,6.12372,6.86406
3100 DATA .677285,.957826,1.17309,1.35457,1.65900,1.91565,2.14176,2.53417,           2.87348,3.58386,4.17507,4.69237,5.15805,5.98162,6.70478
3110 DATA .656532,.928477,1.13715,1.31306,1.60817,1.85695,2.07614,2.45652,           2.78543,3.47404,4.04714,4.54859,5.00000,5.79833,6.49934
3120 DATA .632455,.894427,1.09545,1.26491,1.54919,1.78885,2.00000,2.36643,           2.68328,3.34664,3.89872,4.38178,4.81664,5.58570,6.26099
3130 '---------------------G1N4.BAS--------------------
3140 DATA .654788,.817774,.930430,1.01869,1.15504,1.26113,1.34862,1.49002,           1.60350,1.82011,1.98377,2.11734,2.23119,2.42036,2.57580
3150 DATA .657906,.821133,.934675,1.02390,1.16246,1.27034,1.35977,1.50469,           1.62135,1.84551,2.01613,2.15623,2.27632,2.47726,2.64380
3160 DATA .660411,.825784,.941288,1.03237,1.17444,1.28561,1.37816,1.52897,           1.65115,1.88814,2.07060,2.22189,2.35267,2.57388,2.75961
3170 DATA .663789,.832114,.950374,1.04407,1.19107,1.30687,1.40383,1.56298,           1.69304,1.94834,2.14780,2.31517,2.46138,2.71189,2.92539
3180 DATA .672627,.849169,.975182,1.07628,1.23732,1.36637,1.47602,1.65926,           1.81212,2.12059,2.36941,2.58343,2.77415,3.10874,3.40107
3190 DATA .682851,.870103,1.00639,1.11740,1.29733,1.44432,1.57115,1.78699,           1.97059,2.34997,2.66341,2.93733,3.18416,3.62196,4.00809
3200 DATA .691997,.891140,1.03907,1.16137,1.36291,1.53036,1.67668,1.92906,           2.14655,2.60193,2.98220,3.31624,3.61804,4.15411,4.62699
3210 '------------------G1N6.BAS---------------
3220 DATA 0,0,0,0,0,0,0,0,1.05045,1.14880,1.21970,1.28578,1.33103,1.40479,           1.46949
3230 DATA .552987,.653863,.721280,.771565,.846080,.902357,.947434,1.01812,           1.07258,1.17336,1.24698,1.30547,1.35436,1.43383,1.49776
3240 DATA .557215,.660472,.728264,.779848,.856701,.914421,.960850,1.03396,           1.09104,1.19692,1.27462,1.33683,1.38912,1.47467,1.54390
3250 DATA .561832,.667505,.737457,.790692,.870676,.930946,.979755,1.05694,           1.11757,1.23102,1.31514,1.38303,1.44049,1.53532,1.61286
3260 DATA .574866,.688083,.764324,.823020,.912464,.980935,1.03712,1.12737,           1.19957,1.33796,1.44358,1.53081,1.60610,1.73341,1.84043
3270 DATA .593425,.718119,.804014,.871286,.975829,1.05763,1.12596,1.23812,           1.33006,1.51205,1.65616,1.77864,1.88685,2.07503,2.23812
3280 DATA .617252,.757844,.857477,.937176,1.06404,1.16593,1.25282,1.39896,           1.52196,1.77348,1.97959,2.15901,2.32038,2.60632,2.85856
3290 '--------------------G1N8.BAS-------------
3300 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3310 DATA 0,0,0,0,0,0,0,0,0,.841923,.892332,.921226,.945450,.990528,1.02565
3320 DATA .455719,.540590,.587676,.619468,.669224,.705926,.732731,.776124,          .808962,.868151,.910889,.944430,.972209,1.01691,1.05226
3330 DATA .478895,.551575,.598015,.632424,.682219,.718858,.747994,.793190,          .827842,.891087,.936721,.972353,1.00293,1.05161,1.09060
3340 DATA .493830,.572148,.622786,.660711,.716904,.758687,.792241,.844841,          .885852,.962018,1.01814,1.06328,1.10141,1.16422,1.21549
3350 DATA .514197,.602034,.660085,.704259,.770829,.821292,.862435,.928134,          .980421,1.08018,1.15603,1.21856,1.27247,1.36356,1.44007
3360 DATA .542203,.644270,.713692,.767640,.850888,.915641,.969540,1.05775,          1.12990,1.27253,1.38542,1.48139,1.56623,1.71387,1.84195
3370 '---------------G1N10.BAS-------------------
3380 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3390 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3400 DATA 0,0,0,0,0,0,0,0,0,0,0,.717659,.736946,.766902,.789986
3410 DATA .411731,.462862,.500630,.524950,.558062,.581406,.632333,.633330,          .654910,.695335,.724629,.746793,.765100,.794839,.818025
3420 DATA .431053,.488315,.524248,.550795,.589262,.617386,.639613,.673939,          .700257,.748246,.782878,.810293,.833166,.870277,.900056
3430 DATA .451413,.516495,.558216,.589321,.635197,.669225,.696516,.739295,          .772676,.834819,.880788,.917900,.949350,1.00139,1.04409
3440 DATA .480211,.557240,.607974,.646531,.704635,.748736,.784761,.842469,          .888593,.977172,1.04508,1.10145,1.15033,1.23350,1.30394
3450 '-------------------G2N4.BAS----------------
3460 DATA .879438,.864180,.832360,.801475,.749720,.709217,.676872,.627771,          .591627,.530784,.491325,.462747,.440656,.407962,.384325
3470 DATA .877473,.861059,.828680,.797396,.744953,.704050,.671307,.621635,          .585091,.523455,.483417,.454380,.431899,.398574,.374422
3480 DATA .873990,.856062,.822701,.790697,.737205,.695548,.662216,.611640,          .574412,.511533,.470604,.440863,.417799,.383534,.358638
3490 DATA .869079,.849091,.814392,.781408,.726515,.683859,.649751,.598002,          .559894,.495457,.453442,.422868,.399129,.363817,.338129
3500 DATA .854894,.829351,.791112,.755573,.697104,.651966,.615978,.561485,          .521413,.453742,.409704,.377735,.352985,.316349,.289898
3510 DATA .834880,.802463,.760009,.721536,.659162,.611495,.573722,.516884,          .475373,.405944,.361356,.329378,.304898,.269196,.243886
3520 DATA .809414,.769794,.723214,.682056,.616451,.567004,.528195,.470430,          .428762,.360212,.317074,.286632,.263634,.230600,.207563
3530 '--------------G2N6.BAS-----------------
3540 DATA 0,0,0,0,0,0,0,0,.777424,.734308,.704615,.678244,.660959,.634147,           .612003
3550 DATA .914105,.919270,.907151,.892603,.865323,.841914,.822226,.790690,           .766442,.722852,.692621,.669738,.651419,.623217,.601909
3560 DATA .912243,.915637,.902547,.887151,.858546,.834376,.814080,.781607,           .756431,.711334,.680110,.656413,.637408,.608099,.585945
3570 DATA .909237,.910661,.896131,.879664,.849355,.823963,.802648,.768642,           .742301,.695104,.662389,.637532,.617576,.586752,.563407
3580 DATA .899970,.895647,.876950,.857242,.822056,.793043,.768852,.730435,           .700754,.647619,.610760,.582714,.560166,.525275,.498795
3590 DATA .885529,.872746,.848018,.823664,.781591,.747552,.719431,.675097,           .641043,.580413,.538591,.506915,.481562,.442579,.413256
3600 DATA .864663,.840686,.808201,.778019,.727560,.687633,.655072,.604384,           .565949,.498635,.453152,.419321,.392684,.352607,.323259
3610 '-------------------G2N8.BAS--------------
3620 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3630 DATA 0,0,0,0,0,0,0,0,0,.844824,.823043,.810364,.799705,.779936,.764694
3640 DATA .982869,.912871,.915840,.913547,.904478,.894460,.885792,.869951,           .856885,.831899,.813252,.798502,.786299,.766816,.751629
3650 DATA .891826,.911377,.912537,.908941,.898503,.887791,.877901,.860801,           .846673,.819587,.799578,.783709,.770576,.749599,.733139
3660 DATA .889498,.904206,.901833,.895461,.880613,.866523,.853892,.832512,           .815024,.781817,.757420,.738122,.722151,.696624,.676585
3670 DATA .883542,.891146,.883320,.872552,.850889,.831597,.814763,.786810,           .764262,.721899,.691015,.666687,.546603,.614591,.589533
3680 DATA .872284,.869198,.853352,.836225,.804866,.778309,.755688,.718858,           .689624,.635568,.596777,.566579,.541899,.503073,.473173
3690 '---------------G2N10.BAS------------------
3700 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3710 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3720 DATA 0,0,0,0,0,0,0,0,0,0,0,.872608,.866148,.855439,.846853
3730 DATA .851504,.881630,.894402,.898963,.901233,.900439,.898423,.893312,           .888545,.877509,.868173,.860536,.853926,.842725,.833681
3740 DATA .858625,.884712,.892594,.894896,.893787,.890215,.886036,.877664,           .869969,.853825,.840950,.830258,.821092,.805899,.793533
3750 DATA .860767,.881901,.885695,.884561,.877959,.870070,.862320,.848232,           .836018,.811467,.792449,.776873,.763644,.741889,.724303
3760 DATA .859701,.872399,.869471,.862817,.847490,.832824,.819526,.796645,           .777567,.740419,.712355,.689706,.670666,.639712,.614990
3770 '-------------------G3N6.BAS----------------
3780 DATA 0,0,0,0,0,0,0,0,3.57519,4.32771,4.95220,5.59978,6.08124,6.93498,           7.75679
3790 DATA 1.39189,1.65447,1.86740,2.04932,2.35952,2.62876,2.86768,3.28642,           3.64755,4.40936,5.04625,5.60283,6.10339,6.98759,7.76402
3800 DATA 1.38976,1.65327,1.86238,2.04397,2.35437,2.62128,2.85826,3.27353,           3.63487,4.39459,5.02813,5.58267,6.08183,6.96401,7.73777
3810 DATA 1.38374,1.64498,1.85303,2.03306,2.34203,2.60724,2.84331,3.25656,           3.61616,4.37252,5.00353,5.55594,6.05317,6.93206,7.70307
3820 DATA 1.36621,1.62203,1.82656,2.00373,2.30826,2.57000,2.80320,3.21176,           3.56757,4.31659,4.94205,5.48997,5.98343,6.85623,7.62248
3830 DATA 1.34284,1.59230,1.79262,1.96660,2.26631,2.52445,2.75476,3.15887,           3.51135,4.25472,4.87671,5.42243,5.91452,6.78622,7.55279
3840 DATA 1.31464,1.55747,1.75362,1.92458,2.22007,2.47534,2.70358,3.10500,           3.45600,4.19843,4.82157,5.36952,5.86447,6.74289,7.51680
3850 '------------------G3N8.BAS--------------
3860 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3870 DATA 0,0,0,0,0,0,0,0,0,2.71634,3.02604,3.21799,3.38721,3.72255,4.00261
3880 DATA 1.25934,1.45645,1.58652,1.68450,1.85605,1.99783,2.10995,2.30736,           2.47012,2.79330,3.05093,3.26761,3.45682,3.77993,4.05198
3890 DATA 1.29612,1.46526,1.59125,1.69517,1.86295,2.00032,2.11831,2.31704,           2.48253,2.81425,3.07750,3.30014,3.49501,3.82877,4.11234
3900 DATA 1.29034,1.46007,1.58727,1.69278,1.86630,2.00900,2.13213,2.34035,           2.51533,2.86867,3.15154,3.39222,3.60421,3.96999,4.28306
3910 DATA 1.27292,1.45062,1.58113,1.69040,1.87163,2.02207,2.15274,2.37546,           2.56420,2.94937,3.26139,3.52927,3.76700,4.18089,4.53870
3920 DATA 1.26486,1.44004,1.57554,1.69026,1.88272,2.04432,2.18591,2.42966,           2.63844,3.07037,3.42563,3.73421,4.01064,4.49736,4.92336
3930 '-----------------G3N10.BAS-----------------
3940 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3950 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
3960 DATA 0,0,0,0,0,0,0,0,0,0,0,2.21549,2.31023,2.46527,2.59137
3970 DATA 1.19672,1.30620,1.39716,1.46132,1.55648,1.62930,1.69879,1.80918,           1.89137,2.05722,2.18713,2.29086,2.38007,2.53177,2.65589
3980 DATA 1.20715,1.32431,1.40681,1.47303,1.57754,1.66064,1.73040,1.84520,           1.93900,2.12274,2.26528,2.38381,2.48646,2.66020,2.80583
3990 DATA 1.20487,1.32685,1.41462,1.48563,1.59944,1.69095,1.76863,1.89779,           2.00463,2.21670,2.38365,2.52418,2.64705,2.85726,3.03575
4000 DATA 1.20163,1.33043,1.42546,1.50357,1.63084,1.73480,1.82409,1.97463,           2.10094,2.35605,2.56095,2.73599,2.89085,3.15972,3.39173
4010 '--------------G4N8.BAS----------------
4020 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
4030 DATA 0,0,0,0,0,0,0,0,0,.498537,.438467,.407607,.383624,.343258,.315316
4040 DATA 1.05874,.971922,.903029,.852023,.769428,.708982,.666138,.600315,           .553993,.478837,.431239,.397601,.372057,.334996,.308895
4050 DATA 1.03830,.958291,.891491,.837866,.758262,.700545,.656196,.591261,           .545193,.470035,.422849,.389399,.363998,.327154,.301070
4060 DATA 1.01836,.936070,.868833,.815200,.734992,.677174,.632871,.568250,           .522369,.447747,.401032,.368007,.342952,.306662,.281038
4070 DATA .993310,.908264,.839925,.785765,.705234,.647431,.603277,.539051,           .493595,.419926,.373988,.341613,.317110,.281728,.256829
4080 DATA .963217,.875128,.805666,.751047,.670348,.612734,.568883,.505343,           .460546,.388285,.343462,.312003,.288273,.254148,.230252
4090 '--------------G4N10.BAS------------------
4100 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
4110 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
4120 DATA 0,0,0,0,0,0,0,0,0,0,0,.607518,.578024,.535061,.504294
4130 DATA 1.09058,1.34576,.994964,.956631,.899757,.857803,.819720,.763647,           .725540,.657517,.611571,.578870,.553219,.514119,.485800
4140 DATA 1.06762,1.01344,.965926,.926490,.865317,.819348,.783020,.728082,           .687563,.618468,.572919,.539483,.513311,.474094,.445368
4150 DATA 1.04110,.981121,.930146,.888424,.824186,.776307,.738609,.681890,           .640251,.569723,.523495,.489711,.463401,.424140,.395513
4160 DATA 1.00815,.941372,.886468,.842083,.774461,.724499,.685385,.626982,           .584402,.512800,.466326,.432565,.406408,.367651,.339610
4170 '---------------G5N10.BAS--------------
4180 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
4190 DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
4200 DATA 0,0,0,0,0,0,0,0,0,0,0,5.52426,6.08252,7.05445,7.89711
4210 DATA 1.48519,1.71767,1.94819,2.13122,2.43218,2.68509,2.94350,3.38623,           3.74099,4.51953,5.18505,5.75020,6.25905,7.17062,7.95889
4220 DATA 1.48356,1.72645,1.92620,2.10366,2.41118,2.67837,2.91608,3.33351,           3.69725,4.46468,5.10747,5.67014,6.17621,7.07131,7.85669
4230 DATA 1.45206,1.68796,1.88395,2.05705,2.35864,2.62004,2.85342,3.26359,           3.62163,4.37775,5.00980,5.56385,6.06327,6.94604,7.72001
4240 DATA 1.41460,1.64303,1.83404,2.00302,2.29794,2.55395,2.78261,3.18567,           3.53800,4.28198,4.90576,5.45242,5.94495,6.81695,7.58314
4250 '
4260 '.....PRINT page & continue
4270 KEY OFF:GOSUB 4340:LOCATE 25,5:COLOR 0,2
4280 PRINT " Send this page to:(1)Printer Queue? (2)Printout? ";
4290 PRINT "(3)Next page? (1/2/3)";:COLOR 7,0
4300 Z$=INKEY$:IF Z$<"1"OR Z$>"3"THEN 4300 ELSE GOSUB 4340
4310 IF Z$="3"THEN RETURN
4320 FOR I%=1 TO 24:FOR J%=1 TO 80:LPRINT CHR$(SCREEN(I%,J%));:NEXT J%:NEXT I%
4330 IF Z$="2"THEN LPRINT CHR$(12) ELSE 4270
4340 LOCATE 25,1:PRINT STRING$(80,32);:RETURN
4350 '
4360 PRINT "The matching filters can also be transformed into hi-pass configurations:"
4370 PRINT "            C1C2Ŀ        C2C4Ŀ";
4380 PRINT "           RS                RS          ";
4390 PRINT "               L2   L4 RL  or    L1   L3    RL";
4400 PRINT "           Vin               Vin         ";
4410 PRINT "                    ";
4420 PRINT "         RL greater than RS      RL less than RS";
4430 PRINT ";
4440 PRINT "The conversion is Cn2=K/Ln1/W0^2 and Ln2=K/Cn1/W0^2, where Ln1 and Cn1 are";
4450 PRINT "the low pass elements and Ln2, Cn2 are the desired high pass elements, and";
4460 PRINT "W0=(WH+WL)/2. K=W0^2/WL/WH. Now, let's try an example. We first get values for";
4470 PRINT "the low pass version. We'll set FH=15 MHz, choose FL to be 5 MHz, set RS=50,";
4480 PRINT "choose RL to be 200 and N to be 4 for a .5098 dB ripple. Then we get:";
4490 PRINT "    Low Pass          High Pass              Performance";
4500 PRINT " L1=1.084589e-6    C1=3.114022e-10      Freq, MHz     dB loss";
4510 PRINT " C2=1.962224E-10   L2=1.721196E-6          5.00        0.5098";
4520 PRINT " L3=1.962224E-6    C3=1.721196E-10         5.351       0.0";
4530 PRINT " C4=1.084569E-10   L4=3.114022E-6         15.00        0.5098";
4540 PRINT "We see that the response is as expected, thus we now have the option of";
4550 PRINT "choosing a configuration perhaps more suited to absorbing reactances.";
4560 GOSUB 4260:CLS
4570 PRINT "One final note. Figuring output voltages when RL<>RS may be a little confusing.";
4580 PRINT "Let's consider a filter with a 50 ohm RS, a 400 ohm RL, and a 1.071 dB ripple.";
4590 PRINT "We know that Pout is maximum when the input is matched. Since the filter is";
4600 PRINT "assumed lossless, Pin=Vin^2/4/RS must appear across RL. So, at the load we";
4610 PRINT "have Vout^2/RL=Vin^2/4/RS, thus Vout=Vin*SQR(RL/4/RS). The 1.071 dB ripple";
4620 PRINT "corresponds to a voltage ratio of 10^(-1.071/20) or 0.884. So, at a ripple";
4630 PRINT "minimum, Vout is 0.884*Vin*SQR(RL/4/RS). With Vin=1 volt, Vout=SQR(400/4/50) or";
4640 PRINT "1.414 volts max and 1.25 volts min.";
4650 GOSUB 4260:CLS:GOTO 320
4660 END
