1 COMMON A, AL, B, BASEONLY, C, C$, C1, CAT$, CC, CKT$, D, D$, DD, DIA, DIMN$, DMS, E, EO, EX$, F, F$, FD, FF, FQ, FRQ, G$, GO$, I, I$, L, LATLONG, LD, LL, LN, LS, LW, LX, MAX, MENU, MIN, MX, N, NN, NT, OV, P, PI, PROG$, Q, QQ, QU, R, RA, RC, T, T$, U, U$, UH, UL$, V$, VC, W, WHIP, WIRD, WW, X, X$, X1, XS, Z$, ZP, ZS
10 'CAPYHAT - Capacity hats for vertical Antennas - 21 DEC 95 rev. 08 APR 97
20 'Edited from CAPHATQ, by W4RNL
30 IF EX$=""THEN EX$="EXIT"
40 CLS:KEY OFF
50 COLOR 7,0,1
60 PI=3.141592
70 X$=STRING$(80,32)
80 UL$=STRING$(80,205)
90 U$="##,###.####"
100 U1$="####.##"
110 U2$="####.###"
120 U3$="####.####"
130 '
140 '.....start
150 CLS
160 COLOR 15,2
170 PRINT " CAPACITIVE HATS for VERTICAL ANTENNAS";
180 PRINT TAB(62);"by L.B.Cebik W4RNL ";
190 PRINT STRING$(80,32);
200 LOCATE CSRLIN-1,20:PRINT "edited for HAMCALC by George Murphy VE3ERP"
210 COLOR 1,0:PRINT STRING$(80,223);:COLOR 7,0
220 '
230 T=7
240 PRINT TAB(T);
250 PRINT "This program computes dimensions of open-frame 4-spoke (square),"
260 PRINT TAB(T);
270 PRINT "6-spoke (hexagonal), and 8-spoke (octagonal) capacitive hats, with"
280 PRINT TAB(T);
290 PRINT "without the spoke outer ends joined by lengths of the same material"
300 PRINT TAB(T);
310 PRINT "to form a continuous rim, using common materials. Calculations are"
320 PRINT TAB(T);
330 PRINT "effective for frequencies of from 3 to 30 MHz. Spoke lengths are"
340 PRINT TAB(T);
350 PRINT "within about 2.5% of NEC-2 models.":
360 PRINT UL$;
370 LN=CSRLIN     'line number
380 PRINT TAB(T);"Press number in < > to:"
390 PRINT UL$;
400 PRINT "      < 1 >  RUN program"
410 PRINT "      < 0 >  EXIT"
420 Z$=INKEY$:IF Z$=""THEN 420
430 IF Z$="0"THEN CLS:RUN EX$
440 IF Z$="1"THEN 460
450 GOTO 420
460 VIEW PRINT 4 TO 24:CLS:VIEW PRINT:LOCATE 4
470 '
480 '.....Frequency selection
490 INPUT " ENTER: Frequency of interest in MHz (range 3-30 MHz)";F
500 FL=3:FH=30:IF F<FL OR F>FH THEN 460 ELSE 510
510 LOCATE CSRLIN-1
520 PRINT" Selected frequency...........................";USING U$;F;
530 PRINT " MHz"
540 PRINT UL$;
550 LN=CSRLIN-1   'line number
560 '
570 '.....Antenna element diameter selection
580 PRINT " Press no. in < > that best describes the diameter of main ";
590 PRINT "radiating element:"
600 PRINT
610 PRINT "   < 1 >  10-16 mm (3/8 - 5/8 in.)
620 PRINT "   < 2 >  16-22 mm (5/8 - 7/8 in.)
630 PRINT "   < 3 >  22-28 mm (7/8 - 1 1/8 in.)
640 PRINT "   < 4 >  28-35 mm (1 1/8 - 1 3/8 in.)
650 PRINT "   < 5 >  35-41 mm (1 3/8 - 1 5/8 in.)
660 PRINT "   < 6 >  41-48 mm (1 5/8 - 1 7/8 in.)
670 PRINT "   < 7 >  48-54 mm (1 7/8 - 2 1/8 in.)
680 '
690 A$=INKEY$:IF A$=""THEN 690
700 IF A$="1"THEN KL=9.688000E-01:KH=9.530000E-01 :D=5.000000E-01:GOTO 790
710 IF A$="2"THEN KL=9.668999E-01:KH=9.483000E-01:D=7.500000E-01:GOTO 790
720 IF A$="3"THEN KL=9.653999E-01:KH=9.445000E-01:D=1:GOTO 790
730 IF A$="4"THEN KL=9.641000E-01:KH=9.412000E-01:D=1.250000:GOTO 790
740 IF A$="5"THEN KL=9.629999E-01 :KH=9.383000E-01:D=1.500000:GOTO 790
750 IF A$="6"THEN KL=9.620000E-01 :KH=9.358000E-01:D=1.750000:GOTO 790
760 IF A$="7"THEN KL=9.610999E-01:KH=9.334999E-01:D=2:GOTO 790
770 GOTO 690
780 '
790 VIEW PRINT LN TO 24:CLS:VIEW PRINT:LOCATE LN
800 KV=(((F/3)-1)*1.000000E-01/3)+6.100000E-01
810 KQ=KH+((4.342944E-01*LOG(FH/F))^KV)*(KL-KH):LK=KQ*2.458928E+02:MQ=1/KQ
820 PRINT" Main element design diameter.................";USING U$;D;
830 PRINT " in. =";USING U1$;D*2.539999E+01;:PRINT " mm"
840 PRINT UL$;
850 LN=CSRLIN-1   'line number
860 '
870 '.....Open-frame hat wire or tubing diameter selection.
880 '     perimeter wire assumed to have same diameter as spoke wire.
890 PRINT " Press number in < > to select diameter of hat spokes & rim you ";
900 PRINT "plan to use:"
910 PRINT
920 PRINT "   < 1 > #12 AWG =  .0808 in. =  2.1 mm ( wire )"
930 PRINT "   < 2 > #10 AWG =  .1019 in. =  2.6 mm ( wire )"
940 PRINT "   < 3 > # 8 AWG =  .1285 in. =  3.3 mm ( wire )"
950 PRINT "   < 4 > ....... =  .250  in. =  6.4 mm ( rod or tubing )"
960 PRINT "   < 5 > ....... =  .500  in. = 12.7 mm ( rod or tubing )"
970 PRINT "   < 6 > ....... =  .750  in. = 19.1 mm ( rod or tubing )"
980 PRINT "   < 7 > ....... = 1.000  in. = 25.4 mm ( rod or tubing )"
990 '
1000 A$=INKEY$:IF A$=""THEN 1000
1010 IF A$="1"THEN 1110
1020 IF A$="2"THEN 1180
1030 IF A$="3"THEN 1250
1040 IF A$="4"THEN 1320
1050 IF A$="5"THEN 1390
1060 IF A$="6"THEN 1460
1070 IF A$="7"THEN 1530
1080 GOTO 1000
1090 '
1100 '          Calibration constants derived from models
1110 KCL=1.240800:KGL=1.245200:KCH=1.232300:KGH=1.240300:HKCL=1.077900:HKGL=1.106299
1120 HKCH=1.095999:HKGH=1.136700:OKCL=9.947999E-01:OKGL=1.033800:OKCH=1.028800:OKGH=1.086300
1130 KCLS=2.151099:KGLS=2.147099:KCHS=1.962299:KGHS=1.940899:HKCLS=1.666200:HKGLS=1.712100
1140 HKCHS=1.588799:HKGHS=1.644899:OKCLS=1.414000:OKGLS=1.474799:OKCHS=1.391899
1150 OKGHS=1.475900
1160 DCAP=8.079999E-02:GOTO 1600
1170 '
1180 KCL=1.227200:KGL=1.233600:KCH=1.217599:KGH=1.230399:HKCL=1.064800:HKGL=1.094499
1190 HKCH=1.080600:HKGH=1.125200:OKCL=9.826999E-01:OKGL=1.022500:OKCH=1.014000:OKGH=1.074499
1200 KCLS=2.113500:KGLS=2.114200:KCHS=1.917799:KGHS=1.907999:HKCLS=1.636500:HKGLS=1.684900
1210 HKCHS=1.551300:HKGHS=1.615100:OKCLS=1.389999:OKGLS=1.452200:OKCHS=1.360700
1220 OKGHS=1.449499
1230 DCAP=1.018999E-01:GOTO 1600
1240 '
1250 KCL=1.213299:KGL=1.221600:KCH=1.202299:KGH=1.220100:HKCL=1.051499:HKGL=1.082499
1260 HKCH=1.064800:HKGH=1.113299:OKCL=9.703999E-01:OKGL=1.010900:OKCH=9.988999E-01:OKGH=1.062299
1270 KCLS=2.074800:KGLS=2.080300:KCHS=1.870900:KGHS=1.873399:HKCLS=1.606099:HKGLS=1.658300
1280 HKCHS=1.512300:HKGHS=1.583799:OKCLS=1.365700:OKGLS=1.429000:OKCHS=1.328299
1290 OKGHS=1.422000
1300 DCAP=1.284999E-01:GOTO 1600
1310 '
1320 KCL=1.172000:KGL=1.185799:KCH=1.153800:KGH=1.187100:HKCL=1.012199:HKGL=1.046399
1330 HKCH=1.015499:HKGH=1.076200:OKCL=9.348000E-01:OKGL=9.763000E-01:OKCH=9.531000E-01:OKGH=1.025099
1340 KCLS=1.958400:KGLS=1.977599:KCHS=1.722300:KGHS=1.762400:HKCLS=1.514700:HKGLS=1.572800
1350 HKCHS=1.390499:HKGHS=1.485000:OKCLS=1.292799:OKGLS=1.359400:OKCHS=1.228399
1360 OKGHS=1.335600
1370 DCAP=2.500000E-01:GOTO 1600
1380 '
1390 KCL=1.125900:KGL=1.145599:KCH=1.093099:KGH=1.145799:HKCL=9.678999E-01:HKGL=1.006100
1400 HKCH=1.008999:HKGH=1.031700:OKCL=8.942000E-01:OKGL=9.381999E-01:OKCH=9.021000E-01:OKGH=9.825000E-01
1410 KCLS=1.826099:KGLS=1.860599:KCHS=1.541900:KGHS=1.625200:HKCLS=1.411800:HKGLS=1.477499
1420 HKCHS=1.315899:HKGHS=1.365800:OKCLS=1.226600:OKGLS=1.281200:OKCHS=1.113299
1430 OKGHS=1.232499
1440 DCAP=5.000000E-01:GOTO 1600
1450 '
1460 KCL=1.096899:KGL=1.120399:KCH=1.049999:KGH=1.116500:HKCL=9.406999E-01:HKGL=9.808999E-01
1470 HKCH=9.180999E-01:HKGH=1.001899:OKCL=8.698999E-01:OKGL=9.146000E-01:OKCH=8.708999E-01:OKGH=9.556000E-01
1480 KCLS=1.741799:KGLS=1.773499:KCHS=1.425099:KGHS=1.533699:HKCLS=1.347000:HKGLS=1.417099
1490 HKCHS=1.159199:HKGHS=1.287700:OKCLS=1.161100:OKGLS=1.232200:OKCHS=1.041700
1500 OKGHS=1.165500
1510 DCAP=7.500000E-01:GOTO 1600
1520 '
1530 KCL=1.075299:KGL=1.101400:KCH=1.014000:KGH=1.092100:HKCL=9.204000E-01:HKGL=9.621999E-01
1540 HKCH=8.877999E-01:HKGH=9.782000E-01:OKCL=8.521999E-01:OKGL=8.974000E-01:OKCH=8.474000E-01:OKGH=9.354000E-01
1550 KCLS=1.678300:KGLS=1.729500:KCHS=1.339200:KGHS=1.463899:HKCLS=1.298699:HKGLS=1.371899
1560 HKCHS=1.094799:HKGHS=1.228999:OKCLS=1.123700:OKGLS=1.195600:OKCHS=9.893000E-01
1570 OKGHS=1.115000
1580 DCAP=1.000000:GOTO 1600
1590 '
1600 VIEW PRINT LN TO 24:CLS:VIEW PRINT:LOCATE LN
1610 PRINT" Selected hat material diameter...............";USING U$;DCAP;
1620 PRINT " in. =";USING U1$;DCAP*2.539999E+01;:PRINT " mm"
1630 PRINT UL$;
1640 LN=CSRLIN-1   'line number
1650 '
1660 '.....Antenna length selection between 60 and 85 electrical degrees
1670 KF=LK*12:KA=KF/90
1680 HS=(KA*60)/F:HL=(KA*85)/F:HSF=HS/12:HLF=HL/12
1690 PRINT " At the selected frequency and element sizes the length of a ";
1700 PRINT "capacitive hat"
1710 PRINT
1720 PRINT " vertical should be between a MINIMUM of";USING U2$;HSF;
1730 PRINT " ft. (";USING U2$;HSF*3.048000E-01;:PRINT " m. )"
1740 PRINT "                            "
1750 PRINT "                        and a MAXIMUM of";USING U2$;HLF;
1760 PRINT " ft. (";USING U2$;HLF*3.048000E-01;:PRINT " m. )"
1770 PRINT "                            "
1780 COLOR 15,2
1790 PRINT " Do you want to specify length in (m)etres or (f)eet?   (m/f) "
1800 COLOR 7,0
1810 Z$=INKEY$
1820 IF Z$="m"THEN M=3.048000E-01:M$=" metres":GOTO 1850
1830 IF Z$="f"THEN M=1:M$=" feet":GOTO 1850
1840 GOTO 1810
1850 LOCATE CSRLIN-1:PRINT X$;:LOCATE CSRLIN-1
1860 PRINT " ENTER: Desired antenna length in";M$;".....";:INPUT HF:HF=HF/M
1870 IF HF>HLF OR HF<HSF THEN BEEP:GOTO 1880 ELSE 1900
1880 PRINT " LENGTH MUST BE WITHIN THE MINIMUM AND MAXIMUM LIMITS!":GOTO 1860
1890 '
1900 VIEW PRINT LN TO 24:CLS:VIEW PRINT:LOCATE LN
1910 PRINT " Antenna physical length......................";USING U$;HF;
1920 PRINT " ft. =";USING U2$;HF*3.048000E-01;:PRINT " m"
1930 '
1940 '.....Required hat capacitance calculation
1950 HR=LK/F:H=HF*12
1960 ZO=60*(LOG((4*(H*MQ))/D)-(1-((F/30)*5.830000E-01)))
1970 LA=(HF/HR)*90:LC=90-LA:LCR=(PI*LC)/180:X=ZO/TAN(LCR)
1980 C=10^6/((2*PI)*(F*X)):CHD=1.112100*C
1990 PRINT
2000 PRINT " Antenna electrical length....................";USING U$;LA;
2010 PRINT ""
2020 PRINT " Loading electrical length....................";USING U$;LC;
2030 PRINT ""
2040 PRINT " Required capacitive reactance................";USING U$;X;
2050 PRINT " "
2060 PRINT " Required capacitance.........................";USING U$;C;
2070 PRINT " pF"
2080 PRINT " Radius of solid metal disc hat...............";USING U$;CHD/2;
2090 PRINT " in. =";USING U2$;CHD/2*2.539999;:PRINT " cm"
2100 PRINT
2110 '
2120 '          Square spoke calculation and calibration
2130 KCF=(4.343000E-01*LOG(F/3))*(KCL-KCH):KC=KCL-KCF
2140 KCD=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(KGL-KCL):KC=KC+KCD
2150 KCG=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(KC-KGH):KC=KC-KCG
2160 SPT=(KC*C)
2170 KCFS=(4.343000E-01*LOG(F/3))*(KCLS-KCHS):KCS=KCLS-KCFS
2180 KCDS=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(KGLS-KCLS):KCS=KCS+KCDS
2190 KCGS=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(KCS-KGHS):KCS=KCS-KCGS
2200 SPTS=(KCS*C)
2210 '
2220 '          Hexagon spoke calculation and calibration
2230 HKCF=(4.343000E-01*LOG(F/3))*(HKCL-HKCH):HKC=HKCL-HKCF
2240 HKCD=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(HKGL-HKCL):HKC=HKC+HKCD
2250 HKCG=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(HKC-HKGH):HKC=HKC-HKCG
2260 HSPT=(HKC*C)
2270 HKCFS=(4.343000E-01*LOG(F/3))*(HKCLS-HKCHS):HKCS=HKCLS-HKCFS
2280 HKCDS=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(HKGLS-HKCLS):HKCS=HKCS+HKCDS
2290 HKCGS=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(HKCS-HKGHS):HKCS=HKCS-HKCGS
2300 HSPTS=(HKCS*C)
2310 '
2320 '          Octagon spoke calculation and calibration
2330 OKCF=(4.343000E-01*LOG(F/3))*(OKCL-OKCH):OKC=OKCL-OKCF
2340 OKCD=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(OKGL-OKCL):OKC=OKC+OKCD
2350 OKCG=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(OKC-OKGH):OKC=OKC-OKCG
2360 OSPT=(OKC*C)
2370 OKCFS=(4.343000E-01*LOG(F/3))*(OKCLS-OKCHS):OKCS=OKCLS-OKCFS
2380 OKCDS=(1.661000*(4.343000E-01*LOG(D/5.000000E-01)))*(OKGLS-OKCLS):OKCS=OKCS+OKCDS
2390 OKCGS=(1.661000*(1.886000E-01*((LOG(D/5.000000E-01))*(LOG(F/3)))))*(OKCS-OKGHS):OKCS=OKCS-OKCGS
2400 OSPTS=(OKCS*C)
2410 '
2420 COLOR 0,7
2430 PRINT " .....HATS WITH SPOKE OUTER ENDS JOINED TO FORM A CONTINUOUS RIM:"
2440 COLOR 7,0
2450 PRINT " Square Hat:    length of each of 4 spokes....";USING U$;SPT;
2460 PRINT " in. =";USING U2$;SPT*2.539999;:PRINT " cm"
2470 PRINT " Hexagonal Hat: length of each of 6 spokes....";USING U$;HSPT;
2480 PRINT " in. =";USING U2$;HSPT*2.539999;:PRINT " cm"
2490 PRINT " Octagonal Hat: length of each of 8 spokes....";USING U$;OSPT;
2500 PRINT " in. =";USING U2$;OSPT*2.539999;:PRINT " cm"
2510 PRINT
2520 COLOR 0,7
2530 PRINT " .....HATS WITH SPOKES ONLY (no outer rim):"
2540 COLOR 7,0
2550 PRINT " Square Hat:    length of each of 4 spokes....";USING U$;SPTS;
2560 PRINT " in. =";USING U2$;SPTS*2.539999;:PRINT " cm"
2570 PRINT " Hexagonal Hat: length of each of 6 spokes....";USING U$;HSPTS;
2580 PRINT " in. =";USING U2$;HSPTS*2.539999;:PRINT " cm"
2590 PRINT " Octagonal Hat: length of each of 8 spokes....";USING U$;OSPTS;
2600 PRINT " in. =";USING U2$;OSPTS*2.539999;:PRINT " cm"
2610 GOSUB 3700
2620 '
2630 CLS    'start page 2
2640 '.....hat dimensions
2650 COLOR 15,2:LOCATE,24:PRINT " HAT GEOMETRY - HATS WITH RIMS "
2660 PRINT
2670 PRINT " SQUARE HAT - 4 SPOKES 90 APART:"
2680 COLOR 7,0
2690 SIDE=2*SQR(SPT^2/2)
2700 FLAT=SIDE
2710 LGTH=4*SPT+4*SIDE
2720 PRINT "    Length of each spoke......................  ";USING U3$;SPT;
2730 PRINT " in. =";USING U2$;SPT*2.539999;:PRINT " cm."
2740 PRINT "    Distance between opposite corners.........  ";USING U3$;2*SPT;
2750 PRINT " in. =";USING U2$;2*SPT*2.539999;:PRINT " cm."
2760 PRINT "    Distance between opposite sides...........  ";USING U3$;FLAT;
2770 PRINT " in. =";USING U2$;FLAT*2.539999;:PRINT " cm."
2780 PRINT "    Length of each of 4 equal sides...........  ";USING U3$;SIDE;
2790 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
2800 PRINT "    Total length of spoke & rim material......  ";USING U3$;LGTH;
2810 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
2820 PRINT
2830 '
2840 COLOR 15,2:PRINT " HEXAGONAL HAT - 6 SPOKES 60 APART:"
2850 COLOR 7,0
2860 SIDE=HSPT
2870 FLAT=2*COS(30*PI/180)*HSPT
2880 LGTH=6*HSPT+6*SIDE
2890 PRINT "    Length of each spoke......................  ";USING U3$;HSPT;
2900 PRINT " in. =";USING U2$;HSPT*2.539999;:PRINT " cm."
2910 PRINT "    Distance between opposite corners.........  ";USING U3$;2*HSPT;
2920 PRINT " in. =";USING U2$;2*HSPT*2.539999;:PRINT " cm."
2930 PRINT "    Distance between opposite sides...........  ";USING U3$;FLAT;
2940 PRINT " in. =";USING U2$;FLAT*2.539999;:PRINT " cm."
2950 PRINT "    Length of each of 6 equal sides...........  ";USING U3$;SIDE;
2960 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
2970 PRINT "    Total length of spoke & rim material......  ";USING U3$;LGTH;
2980 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
2990 PRINT
3000 '
3010 COLOR 15,2:PRINT " OCTAGONAL HAT - 8 SPOKES 22 APART:"
3020 COLOR 7,0
3030 SIDE=2*SIN(2.250000E+01*PI/180)*OSPT
3040 FLAT=2*COS(2.250000E+01*PI/180)*OSPT
3050 LGTH=8*OSPT+8*SIDE
3060 PRINT "    Length of each spoke......................  ";USING U3$;OSPT;
3070 PRINT " in. =";USING U2$;OSPT*2.539999;:PRINT " cm."
3080 PRINT "    Distance between opposite corners.........  ";USING U3$;2*OSPT;
3090 PRINT " in. =";USING U2$;2*OSPT*2.539999;:PRINT " cm."
3100 PRINT "    Distance between opposite sides...........  ";USING U3$;FLAT;
3110 PRINT " in. =";USING U2$;FLAT*2.539999;:PRINT " cm."
3120 PRINT "    Length of each of 8 equal sides...........  ";USING U3$;SIDE;
3130 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
3140 PRINT "    Total length of spoke & rim material......  ";USING U3$;LGTH;
3150 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
3160 '
3170 GOSUB 3700
3180 CLS    'start page 3
3190 '.....hat dimensions
3200 COLOR 15,2:LOCATE,22:PRINT " HAT GEOMETRY - HATS WITH SPOKES ONLY "
3210 PRINT
3220 PRINT " SQUARE HAT - 4 SPOKES 90 APART:"
3230 COLOR 7,0
3240 SIDE=2*SQR(SPTS^2/2)
3250 FLAT=SIDE
3260 LGTH=4*SPTS
3270 PRINT "    Length of each spoke......................  ";USING U3$;SPTS;
3280 PRINT " in. =";USING U2$;SPTS*2.539999;:PRINT " cm."
3290 PRINT "    Length of each horizontal element.........  ";USING U3$;2*SPTS;
3300 PRINT " in. =";USING U2$;2*SPTS*2.539999;:PRINT " cm."
3310 PRINT "    Distance between adjacent spoke outer ends  ";USING U3$;SIDE;
3320 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
3330 PRINT "    Total length of spoke material............  ";USING U3$;LGTH;
3340 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
3350 PRINT
3360 '
3370 COLOR 15,2:PRINT " HEXAGONAL HAT - 6 SPOKES 60 APART:"
3380 COLOR 7,0
3390 SIDE=HSPTS
3400 FLAT=2*COS(30*PI/180)*HSPTS
3410 LGTH=6*HSPTS
3420 PRINT "    Length of each spoke......................  ";USING U3$;HSPTS;
3430 PRINT " in. =";USING U2$;HSPTS*2.539999;:PRINT " cm."
3440 PRINT "    Length of each horizontal element.........  ";USING U3$;2*HSPTS;
3450 PRINT " in. =";USING U2$;2*HSPTS*2.539999;:PRINT " cm."
3460 PRINT "    Distance between adjacent spoke outer ends  ";USING U3$;SIDE;
3470 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
3480 PRINT "    Total length of spoke material............  ";USING U3$;LGTH;
3490 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
3500 PRINT
3510 '
3520 COLOR 15,2:PRINT " OCTAGONAL HAT - 8 SPOKES 22 APART:"
3530 COLOR 7,0
3540 SIDE=2*SIN(2.250000E+01*PI/180)*OSPTS
3550 LGTH=8*OSPTS
3560 PRINT "    Length of each spoke......................  ";USING U3$;OSPTS;
3570 PRINT " in. =";USING U2$;OSPTS*2.539999;:PRINT " cm."
3580 PRINT "    Length of each horizontal element.........  ";USING U3$;2*OSPTS;
3590 PRINT " in. =";USING U2$;2*OSPTS*2.539999;:PRINT " cm."
3600 PRINT "    Distance between adjacent spoke outer ends  ";USING U3$;SIDE;
3610 PRINT " in. =";USING U2$;SIDE*2.539999;:PRINT " cm."
3620 PRINT "    Total length of spoke material............  ";USING U3$;LGTH;
3630 PRINT " in. =";USING U2$;LGTH*2.539999;:PRINT " cm."
3640 '
3650 '.....end
3660 GOSUB 3700
3670 GOTO 140
3680 END
3690 '
3700 'PRT
3710 KEY OFF:GOSUB 3780:LOCATE 25,5:COLOR 0,2
3720 PRINT " Send this page to:(1)Printer Queue? (2)Printout? ";
3730 PRINT "(3)Next page? (1/2/3)";:COLOR 7,0
3740 Z$=INKEY$:IF Z$<"1"OR Z$>"3"THEN 3740 ELSE GOSUB 3780
3750 IF Z$="3"THEN RETURN
3760 FOR I%=1 TO 24:FOR J%=1 TO 80:LPRINT CHR$(SCREEN(I%,J%));:NEXT J%:NEXT I%
3770 IF Z$="2"THEN LPRINT CHR$(12) ELSE 3710
3780 LOCATE 25,1:PRINT STRING$(80,32);:RETURN
