1 COMMON A, AL, B, BASEONLY, C, C$, C1, CAT$, CC, CKT$, D, D$, DD, DIA, DIMN$, DMS, E, EO, EX$, F, F$, FD, FF, FQ, FRQ, G$, GO$, I, I$, L, LATLONG, LD, LL, LN, LS, LW, LX, MAX, MENU, MIN, MX, N, NN, NT, OV, P, PI, PROG$, Q, QQ, QU, R, RA, RC, T, T$, U, U$, UH, UL$, V$, VC, W, WHIP, WIRD, WW, X, X$, X1, XS, Z$, ZP, ZS
5 'OMMON EX$,PROG$
10 'BUTTFILT - Butterworth HF Filters - 21 JUN 96 rev. 08 APR 97
20 'ref: 1994 ARRL HANDBOOK for RADIO AMATEURS, pages 2-40 & 2-41
30 IF EX$=""THEN EX$="exit"
40 PROG$="buttfilt":GO$=EX$
50 
60 CLS:KEY OFF
70 COLOR 7,0,1
80 PI=3.141592
90 LF=1/LOG(10)
100 UL$=STRING$(80,205)
110 U$="#####.###"
120 X$=STRING$(80,32)
130 DIM H(9)     'amateur band centre frequencies
140 DIM V(9,9)   'factor values
150 '
160 '.....amateur HF band centre frequency
170 DATA 1.879, 3.742, 7.148, 10.125, 14.174, 18.118, 21.224, 24.940, 28.837
180 FOR Z=1 TO 9:READ H(Z):NEXT Z
190 '
200 '.....data from Table 10, page 2-40, 1994 ARRL Handbook
210 DATA 1, 2, 1
220 FOR Z=1 TO 3:READ V(3,Z):NEXT Z
230 DATA .618, 1.618, 2, 1.618, .618
240 FOR Z=1 TO 5:READ V(5,Z):NEXT Z
250 DATA .445, 1.247, 1.8019, 2, 1.8019, 1.247, .445
260 FOR Z=1 TO 7:READ V(7,Z):NEXT Z
270 DATA .3473, 1, 1.5321, 1.8794, 2, 1.8794, 1.5321, 1, .3473
280 FOR Z=1 TO 9:READ V(9,Z):NEXT Z
290 GOTO 720
300 '
310 '.....diagrams
320 COLOR 0,7
330 LOCATE ,T:PRINT "  LOW-PASS (Capacitor Input/Output)  "
340 LOCATE ,T:PRINT " L2L4L6L8Ŀ "
350 LOCATE ,T:PRINT " R C1     C3     C5     C7     C9  R "
360 LOCATE ,T:PRINT "  "
370 COLOR 7,0
380 RETURN
390 '
400 COLOR 0,7
410 LOCATE ,T:PRINT "  LOW-PASS (Inductor Input/Output)   "
420 LOCATE ,T:PRINT " L1L3L5L7L9Ŀ "
430 LOCATE ,T:PRINT " R     C2     C4     C6     C8     R "
440 LOCATE ,T:PRINT "  "
450 COLOR 7,0
460 RETURN
470 '
480 COLOR 0,7
490 LOCATE ,T:PRINT " HIGH-PASS (Capacitor Input/Output)  "
500 LOCATE ,T:PRINT " C1C3C5C7C9Ŀ "
510 LOCATE ,T:PRINT " R     L2     L4     L6     L8     R "
520 LOCATE ,T:PRINT "  "
530 COLOR 7,0
540 RETURN
550 '
560 COLOR 0,7
570 LOCATE ,T:PRINT "  HIGH-PASS (Inductor Input/Output)  "
580 LOCATE ,T:PRINT " C2C4C6C8Ŀ "
590 LOCATE ,T:PRINT " R L1     L3     L5     L7     L9  R "
600 LOCATE ,T:PRINT "  "
610 COLOR 7,0
620 RETURN
630 '
640 COLOR 0,7
650 LOCATE ,T:PRINT "          BAND-PASS          "
660 LOCATE ,T:PRINT " L2C2Ŀ "
670 LOCATE ,T:PRINT " R  L1 C1           L3 C3  R "
680 LOCATE ,T:PRINT "  "
690 COLOR 7,0
700 RETURN
710 '
720 '.....start
730 CLS
740 COLOR 15,2
750 PRINT " BUTTERWORTH HF Filters";TAB(57);"by George Murphy VE3ERP ";
760 COLOR 1,0:PRINT STRING$(80,223);
770 COLOR 7,0
780 LOCATE 3:T=3:GOSUB 320
790 LOCATE 3:T=42:GOSUB 400
800 LOCATE 8:T=3:GOSUB 480
810 LOCATE 8:T=42:GOSUB 560
820 LOCATE 13:T=50:GOSUB 640
830 LOCATE 14
840 PRINT "  Press number in < > for:"
850 PRINT TAB(3);STRING$(24,196)
860 PRINT "  < 1 > Low-Pass filters"
870 PRINT "  < 2 > High-Pass filters"
880 PRINT "  < 3 > Band-Pass filters"
890 PRINT "  < 4 > Amateur band edge & centre frequencies"
900 PRINT "  < 5 > Custom value capacitors"
910 PRINT "  < 6 > Toroid inductor calculator"
920 PRINT "  < 7 > Air-core coil designer"
930 PRINT "  < 0 > EXIT"
940 T=50:LOCATE 17
950 LOCATE ,T:PRINT "ͻ"
960 LOCATE ,T:PRINT "There is no need to alter  "
970 LOCATE ,T:PRINT "the design to suit standard"
980 LOCATE ,T:PRINT "components. Menu items 5-7 "
990 LOCATE ,T:PRINT "enable you to assemble your"
1000 LOCATE ,T:PRINT "own custom components.     "
1010 LOCATE ,T:PRINT "ͼ"
1020 COLOR 7,1
1030 LOCATE 25,5:PRINT " (from the 1994 ARRL HANDBOOK for the RADIO AMATEUR, ";
1040 PRINT "pages 2-40 & 2-41) ";
1050 COLOR 7,0
1060 Z$=INKEY$:IF Z$=""THEN 1060
1070 IF Z$="0"THEN CLS:CHAIN GO$
1080 IF Z$="1"THEN F$="Low":GOTO 1160
1090 IF Z$="2"THEN F$="High":GOTO 1160
1100 IF Z$="3"THEN 2450
1110 IF Z$="4"THEN CHAIN"hambands"
1120 IF Z$="5"THEN CHAIN"custcap"
1130 IF Z$="6"THEN CHAIN"toroid"
1140 IF Z$="7"THEN CHAIN"coildsgn"
1150 GOTO 1060
1160 VIEW PRINT 3 TO 24:CLS:VIEW PRINT
1170 IF F$="Low" THEN LOCATE 3:T=3:GOSUB 320:LOCATE 3:T=42:GOSUB 400:GOTO 1190
1180 IF F$="High"THEN LOCATE 3:T=3:GOSUB 480:LOCATE 3:T=42:GOSUB 560:GOTO 1190
1190 PRINT UL$;
1200 INPUT " ENTER: Cutoff Frequency........................(MHz)";FC
1210 IF FC=0 THEN 1160
1220 LOCATE CSRLIN-1:PRINT STRING$(80,32);:LOCATE CSRLIN-1
1230 '
1240 PRINT " Insertion Loss in dB at various frequencies where N = no. of ";
1250 PRINT "filter elements:"
1260 PRINT TAB(4);"MHz";
1270 PRINT TAB(16);"N=3";TAB(27);"N=5";TAB(38);"N=7";TAB(49);"N=9";
1280 PRINT TAB(58);"Signal"
1290 PRINT UL$;
1300 '
1310   FOR J=1 TO 9
1320 IF FC>=H(J-1)AND FC<H(J)THEN GOSUB 1460
1330 F=H(J)
1340 PRINT USING "###.###";F;
1350 IF F$="Low" THEN FQ=F/FC
1360 IF F$="High"THEN FQ=FC/F
1370 IF FQ<1 THEN S$="passed "
1380 IF FQ>1 THEN S$="blocked "
1390 GOSUB 1530
1400 IF FS THEN FS=0:RETURN
1410   NEXT J
1420 IF FC>=H(9)THEN GOSUB 1460
1430 PRINT
1440 GOTO 1600
1450 '
1460 COLOR 0,7
1470 PRINT USING "###.###";FC;
1480 FQ=1:GOSUB 1530
1490 LOCATE CSRLIN-1,58:PRINT "cutoff frequency "
1500 COLOR 7,0
1510 RETURN
1520 '
1530 T=0:FOR K=3 TO 9 STEP 2:T=T+11
1540      A=10*LOG(1+FQ^(2*K))*LF
1550 IF A<1.000000E-03 THEN M$="#####    "ELSE M$=U$
1560      PRINT TAB(T);USING M$;A;
1570     NEXT K:PRINT SPC(5);S$
1580 RETURN
1590 '
1600 COLOR 15,1:LOCATE ,8
1610 PRINT " Do you want to see insertion losses at another frequency?   (y/n)"
1620 COLOR 7,0
1630 Z$=INKEY$:IF Z$=""THEN 1630
1640 IF Z$="n"THEN 1740
1650 IF Z$="y"THEN 1670
1660 GOTO 1630
1670 LOCATE CSRLIN-1:PRINT X$;:LOCATE CSRLIN-1
1680 COLOR 15,2
1690 INPUT " ENTER: Specific frequency (MHz).....................";FS
1700 COLOR 7,0
1710 LOCATE CSRLIN-1:PRINT X$;:LOCATE CSRLIN-2
1720 F=FS:COLOR 0,7:GOSUB 1340:COLOR 7,0:GOTO 1600
1730 '
1740 LOCATE CSRLIN-1:PRINT X$;:LOCATE CSRLIN-1
1750 COLOR 14,4
1760 INPUT " ENTER: Number of circuit elements (your choice).....";N
1770 COLOR 7,0
1780 IF N>=3 AND N<=9 AND N/2<>INT(N/2)THEN 1790 ELSE 1740
1790 VIEW PRINT 9 TO 24:CLS:VIEW PRINT:LOCATE 9
1800 '
1810 COLOR 0,7
1820 IF N=3 THEN T1=16:T2=21:T3=55
1830 IF N=5 THEN T1=23:T2=14:T3=62
1840 IF N=7 THEN T1=30:T2=7 :T3=69
1850 IF N=9 THEN T1=37:T2=0 :T3=76
1860 T$(3)="  ":T$(4)="Ŀ":T$(5)=" R":T$(6)=""
1870 FOR Z=4 TO 6
1880 LOCATE Z,T1:PRINT T$(Z);STRING$(T2,32)
1890 LOCATE Z,T3:PRINT T$(Z);STRING$(T2,32)
1900 NEXT Z
1910 COLOR 7,0
1920 VIEW PRINT 8 TO 24:CLS:VIEW PRINT:LOCATE 8
1930 '
1940 INPUT " ENTER: I/O Resistance R (ohms)......................";R
1950 VIEW PRINT 7 TO 24:CLS:VIEW PRINT:LOCATE 7
1960 '
1970 PRINT TAB(4);N;"ELEMENT FILTER";TAB(43);N;"ELEMENT FILTER"
1980 PRINT
1990 PRINT TAB(5);"I/O Resistance R =";USING U$;R;:PRINT ;" ";
2000 PRINT TAB(44);"I/O Resistance R =";USING U$;R;:PRINT ;" "
2010 PRINT TAB(5);"Cutoff frequency =";USING U$;FC;:PRINT ;" MHz";
2020 PRINT TAB(44);"Cutoff frequency =";USING U$;FC;:PRINT ;" MHz"
2030 PRINT
2040 '
2050 '.....calculation
2060 FOR Z=1 TO N
2070 Z$=RIGHT$(STR$(Z),1)
2080 IF Z/2=INT(Z/2)THEN A$="L":B$="C"ELSE A$="C":B$="L"
2090 IF A$="L"THEN GOSUB 2330 ELSE GOSUB 2360
2100 LOCATE ,19:PRINT A$+Z$;" =";USING U$;X;:PRINT Y$;
2110 IF B$="L"THEN GOSUB 2330 ELSE GOSUB 2360
2120 LOCATE ,58:PRINT B$+Z$;" =";USING U$;X;:PRINT Y$
2130 NEXT Z
2140 LN=CSRLIN
2150 LOCATE 3,2:PRINT ""
2160 LOCATE 3,40:PRINT ""
2170 LOCATE 3,79:PRINT ""
2180 FOR Z=4 TO LN
2190 LOCATE Z,2:PRINT ""
2200 LOCATE Z,40:PRINT ""
2210 LOCATE Z,79:PRINT ""
2220 NEXT Z
2230 LOCATE LN
2240 PRINT STRING$(80,196);
2250 LOCATE CSRLIN-1,1:PRINT " "
2260 LOCATE CSRLIN-1,40:PRINT ""
2270 LOCATE CSRLIN-1,79:PRINT " ";
2280 PRINT TAB(9);
2290 PRINT "The use of silver-mica or polystyrene capacitors is recommended."
2300 PRINT TAB(13);"Inductors should be wound on powdered-iron toroid cores."
2310 GOTO 2820
2320 '
2330 IF F$="Low" THEN X=R/(2*PI*FC)*V(N,Z)
2340 IF F$="High"THEN X=R/(2*PI*FC*V(N,Z))
2350 Y$=" H":RETURN
2360 IF F$="Low" THEN X=1/(2*PI*FC*R)*V(N,Z)*10^6
2370 IF F$="High"THEN X=1/(2*PI*FC*R*V(N,Z))*10^6
2380 Y$=" pF":RETURN
2390 '
2400 '.....format input line
2410 LOCATE CSRLIN-1:PRINT SPC(7);
2420 LOCATE CSRLIN,47:PRINT STRING$(7,".");USING U$;ZZ;
2430 RETURN
2440 '
2450 '.....bandpass
2460 VIEW PRINT 3 TO 24:CLS:VIEW PRINT:LOCATE 3
2470 T=26:GOSUB 640
2480 PRINT UL$;
2490 INPUT " ENTER: I/O resistance R.......................(ohms)";R
2500 ZZ=R:GOSUB 2400:PRINT " ohms"
2510 INPUT " ENTER: Upper limit of pass-band................(MHz)";FU
2520 ZZ=FU:GOSUB 2400:PRINT " MHz"
2530 PRINT
2540 INPUT " ENTER: Lower limit of pass-band................(MHz)";FL
2550 ZZ=FL:GOSUB 2400:PRINT " MHz"
2560 FO=SQR(FU*FL)
2570 LOCATE CSRLIN-2
2580 PRINT "        Centre frequency of pass-band................";
2590 PRINT USING U$;FO;:PRINT ;" MHz"
2600 BW=ABS(FU-FL)
2610 LOCATE CSRLIN+1
2620 PRINT "        Bandwidth of pass-band.......................";
2630 PRINT USING U$;BW;:PRINT ;" MHz"
2640 C(1)=1/(2*PI*BW*R)*V(3,1)*10^6
2650 L(1)=2.533028E+04/FO^2/C(1)
2660 L(2)=R/(2*PI*BW)*V(3,2)
2670 C(2)=2.533028E+04/FO^2/L(2)
2680 C(3)=1/(2*PI*BW*R)*V(3,3)*10^6
2690 L(3)=2.533028E+04/FO^2/C(3)
2700 FOR Z=1 TO 3
2710  Z$=RIGHT$(STR$(Z),1)
2720  PRINT
2730  PRINT TAB(49);"L";Z$;;"...";USING U$;L(Z);:PRINT ;" H"
2740  PRINT TAB(49);"C";Z$;;"...";USING U$;C(Z);:PRINT ;" pF"
2750 NEXT Z
2760 LOCATE 23
2770 PRINT TAB(9);
2780 PRINT "The use of silver-mica or polystyrene capacitors is recommended."
2790 PRINT TAB(13);"Inductors should be wound on powdered-iron toroid cores.";
2800 GOTO 2820
2810 '
2820 '.....end
2830 GOSUB 2860
2840 GOTO 720
2850 '
2860 'PRT
2870 KEY OFF:GOSUB 2940:LOCATE 25,5:COLOR 0,2
2880 PRINT " Send this page to:(1)Printer Queue? (2)Printout? ";
2890 PRINT "(3)Next page? (1/2/3)";:COLOR 7,0
2900 Z$=INKEY$:IF Z$<"1"OR Z$>"3"THEN 2900 ELSE GOSUB 2940
2910 IF Z$="3"THEN RETURN
2920 FOR I%=1 TO 24:FOR J%=1 TO 80:LPRINT CHR$(SCREEN(I%,J%));:NEXT J%:NEXT I%
2930 IF Z$="2"THEN LPRINT CHR$(12) ELSE 2870
2940 LOCATE 25,1:PRINT STRING$(80,32);:RETURN
