# WebRTC

nbnet provides two different WebRTC drivers, WASM and native. The WASM driver has to be compiled with emscripten and can be used to target web browsers or Node JS. The native driver can be compiled as a native application.

If you want to build an online game that can run in a web browser, I recommend using the WASM driver for the client and the native driver for the server.

Please refer to the echo example for a concrete demonstration of how to use these two drivers.

## Building (WASM) 

If you want to target WASM, you'll need to compile your code with *emscripten*. You can either use the `emcc` command directly or use CMake (refer to the examples to see how to set it up).

The following emscripten options are mandatory and must always be added to your compilation command line or CMake script.

*emscripten* does not provide a C API for WebRTC, only a JS one. nbnet provides a wrapper around it so you don't have to write any JS code (oof!). All you have to do is compile with:

`--js-library "net_drivers/webrtc/js/api.js"`

The nbnet JS API uses a bunch of asynchronous functions that you'll need to let *emscripten* know about:

`-s ASYNCIFY`

`-s ASYNCIFY_IMPORTS="[\"__js_game_client_start\", \"__js_game_client_close\", \"__js_game_server_start\\"]"`

nbnet network conditions simulation runs in a separate thread so if you want to use it you'll need to compile with:

`-s USE_PTHREADS=1`

If you want to run your code in a web browser, you'll also need to provide a shell file:

`--shell-file <PATH TO YOUR SHELL FILE>`

To learn more about shell files: https://emscripten.org/docs/tools_reference/emcc.html

You can also look at the `shell.html` from the raylib example.

For more information: https://emscripten.org/docs/tools_reference/emcc.html

## Building (Native)

The Native WebRTC driver depends on [libdatachannel](https://github.com/paullouisageneau/libdatachannel). Please follow the building instructions in the library repository.

## NodeJS

If you decide to go with WASM for your server, you'll need to run it in a *NodeJS* server. You can get *NodeJS* from [here](https://nodejs.org/en/download/).

Once it's installed, you'll need to create a `package.json` file. Check out the *echo* and *raylib* examples to see what this file should look like. (For more information: https://docs.npmjs.com/creating-a-package-json-file)

To run your server, you need to install the required *NodeJS* packages by running:

`npm install`

from the directory containing your `package.json` file.

Then to run your server:

`node server.js`

`server.js` is the JS file generated by *emscripten*.

## Web browser

Unless your client is a non-graphical application, you'll probably want your client to run in a web browser.

With the correct options *emscripten* will output an HTML file, from here, all you need to do is run an HTTP server that serves
this file and open it in your web browser.

For testing purposes, I recommend using Python [SimpleHTTPServer](https://docs.python.org/2/library/simplehttpserver.html).

Just run:

`python -m SimpleHTTPServer 8000`

in the directory containing your HTML file; then, open `http://localhost:8000` in your web browser and open your client HTML file.

One significant difference between running JS code in a web browser compared to running it in *NodeJS* is that you cannot use the *NodeJS* packaging system. nbnet's WebRTC code relies on *NodeJS* packages, so, for nbnet to run in a web browser we need to "bundle" those packages into something that can be used by a web browser.

I recommend using [browserify](https://github.com/browserify/browserify).

To bundle packages with browserify, you need to first install the required *NodeJS* packages by running:

`npm install`

from the directory containing the same `package.json` file used by your server.

Then you can run:

`browserify net_drivers/webrtc/js/nbnet.js -o nbnet_bundle.js`

and include the generated `nbnet_bundle.js` script in your HTML shell file:

`<script src="nbnet_bundle.js"></script>`

See the *raylib* example to see how you can integrate this operation into a CMake script.
