
import pytest

from natasha.obj import Name


tests = [
    [
        'Мустафа Джемилев',
        Name('Мустафа', 'Джемилев')
    ],
    [
        'Егор Свиридов',
        Name('Егор', 'Свиридов')
    ],
    [
        'Владимир Путин',
        Name('Владимир', 'Путин')
    ],
    [
        'Плаксюк Саша',
        Name('Саша', 'Плаксюк')
    ],
    [
        'Ищенко Е.П.',
        Name('Е', 'Ищенко', 'П')
    ],
    [
        'Фёдор Иванович Шаляпин',
        Name('Фёдор', 'Шаляпин', 'Иванович')
    ],
    [
        'Ипполит Матвеевич',
        Name('Ипполит', None, 'Матвеевич')
    ],
    [
        'Янукович',
        Name(None, 'Янукович')
    ],
    [
        'Авраам',
        Name('Авраам')
    ],
    [
        'Гоша Куценко',
        Name('Гоша', 'Куценко')
    ],
    [
        'Юрий Георгиевич Куценко',
        Name('Юрий', 'Куценко', 'Георгиевич')
    ],
    [
        'Наталья Ищенко',
        Name('Наталья', 'Ищенко')
    ],
    [
        'Наталья Сергеевна Ищенко',
        Name('Наталья', 'Ищенко', 'Сергеевна')
    ],
    [
        'Монина Нина Гафуровна',
        Name('Нина', 'Монина', 'Гафуровна')
    ],
    [
        'В. И. Ленин',
        Name('В', 'Ленин', 'И'),
    ],
]


@pytest.mark.parametrize('test', tests)
def test_extractor(names_extractor, test):
    text, target = test
    pred = names_extractor.find(text).fact
    assert pred == target
