
import pytest


tests = [
    [
        '1 599 059, 38 Евро',
        '1599059.38 EUR'
    ],
    [
        '2 134 472,44 рубля',
        '2134472.44 RUB'
    ],
    [
        '420 долларов',
        '420.00 USD'
    ],
    [
        '20 млн руб',
        '20000000.00 RUB'],
    [
        '20 000 долларов',
        '20000.00 USD'
    ],
    [
        '2,2 млн.руб.',
        '2200000.00 RUB'
    ],
    [
        '2,20 млн.руб.',
        '2200000.00 RUB'
    ],
    [
        '2,02 млн.руб.',
        '2020000.00 RUB'
    ],
    [
        '20 тыс руб',
        '20000.00 RUB'
    ],
    [
        '20 т. р.',
        '20000.00 RUB'
    ],
    [
        '2 200 000 руб.',
        '2200000.00 RUB'
    ],
    [
        '20.000 руб.',
        '20000.00 RUB'
    ],
    [
        '20,000 руб',
        '20000.00 RUB'
    ],
    [
        '20,00 руб',
        '20.00 RUB'
    ],
    [
        '124 451 рубль 50 копеек',
        '124451.50 RUB',
    ],
    [
        '881 913 (Восемьсот восемьдесят одна тысяча девятьсот тринадцать) руб. 98 коп.',
        '881913.98 RUB'
    ]
]


@pytest.mark.parametrize('test', tests)
def test_extractor(money_extractor, test):
    text, target = test
    fact = money_extractor.find(text).fact
    pred = '{fact.amount:0.2f} {fact.currency}'.format(fact=fact)
    assert pred == target
