
import pytest

from natasha.obj import (
    AddrPart as Part,
    Addr
)


tests = [
    [
        'Россия, Вологодская обл. г. Череповец, пр.Победы 93 б',
        Addr([
            Part('Россия', 'страна'),
            Part('Вологодская', 'область'),
            Part('Череповец', 'город'),
            Part('Победы', 'проезд'),
        ])
    ],
    [
        '692909, РФ, Приморский край, г. Находка, ул. Добролюбова, 18',
        Addr([
            Part('692909', 'индекс'),
            Part('РФ', 'страна'),
            Part('Приморский', 'край'),
            Part('Находка', 'город'),
            Part('Добролюбова', 'улица'),
        ])
    ],
    [
        'д. Федоровка, ул. Дружбы, 13',
        Addr([
            Part('Федоровка', 'деревня'),
            Part('Дружбы', 'улица'),
        ])
    ],
    [
        'Россия, 129110, г.Москва, Олимпийский проспект, 22',
        Addr([
            Part('Россия', 'страна'),
            Part('129110', 'индекс'),
            Part('Москва', 'город'),
            Part('Олимпийский', 'проспект'),
        ])
    ],
    [
        'г. Санкт-Петербург, Красногвардейский пер., д. 15',
        Addr([
            Part('Санкт-Петербург', 'город'),
            Part('Красногвардейский', 'переулок'),
            Part('15', 'дом')
        ])
    ],
    [
        'Республика Карелия,г.Петрозаводск,ул.Маршала Мерецкова, д.8 Б,офис 4',
        Addr([
            Part('Карелия', 'республика'),
            Part('Петрозаводск', 'город'),
            Part('Маршала Мерецкова', 'улица'),
            Part('8 Б', 'дом'),
            Part('4', 'офис')
        ])
    ],
    [
        '628000, ХМАО-Югра, г.Ханты-Мансийск, ул. Ледовая , д.19',
        Addr([
            Part('628000', 'индекс'),
            Part('ХМАО-Югра'),
            Part('Ханты-Мансийск', 'город'),
            Part('Ледовая', 'улица'),
            Part('19', 'дом')
        ])
    ],
    [
        'ХМАО г.Нижневартовск пер.Ягельный 17',
        Addr([
            Part('ХМАО'),
            Part('Нижневартовск', 'город'),
            Part('Ягельный', 'переулок'),
        ])
    ],
    [
        'Белгородская обл, пгт Борисовка,ул. Рудого д.160',
        Addr([
            Part('Белгородская', 'область'),
            Part('Борисовка', 'посёлок'),
            Part('Рудого', 'улица'),
            Part('160', 'дом')
        ])
    ],
    [
        'Самарская область, п.г.т. Алексеевка, ул. Ульяновская д. 21',
        Addr([
            Part('Самарская', 'область'),
            Part('Алексеевка', 'посёлок'),
            Part('Ульяновская', 'улица'),
            Part('21', 'дом')
        ])

    ],
    [
        'Мурманская обл поселок городского типа Молочный, ул.Гальченко д.11',
        Addr([
            Part('Мурманская', 'область'),
            Part('Молочный', 'посёлок'),
            Part('Гальченко', 'улица'),
            Part('11', 'дом')
        ])
    ],
    [
        'ул. Народного Ополчения д. 9к.3',
        Addr([
            Part('Народного Ополчения', 'улица'),
            Part('9к', 'дом'),
        ])
    ],
    [
        'ул. Б. Пироговская, д.37/430',
        Addr([
            Part('Б. Пироговская', 'улица'),
            Part('37/430', 'дом')
        ])
    ],
    [
        'Ставропольский край, Изобильненский район, город Изобильный, улица Чапаева, дом 68',
        Addr([
            Part('Ставропольский', 'край'),
            Part('Изобильненский', 'район'),
            Part('Изобильный', 'город'),
            Part('Чапаева', 'улица'),
            Part('68', 'дом')
        ])
    ],
]


@pytest.mark.parametrize('test', tests)
def test_extractor(addr_extractor, test):
    text, target = test
    pred = addr_extractor.find(text).fact
    assert pred == target
