# Hawking's Privacy Policy
Effective October 4th, 2022

Pertains only to the Hawking bot accessible from [this](https://github.com/naschorr/hawking) repository. Forks and third party installations cannot be confirmed to follow this privacy policy, so use caution if you're not sure about the origin of a Hawking bot.

## What Data is Stored
Only messages that invoke Hawking (via the `/` slash-command, or `@Hawking` mention by default) will be stored. Hawking does not listen in on text or voice channels, and doesn't store any data outside of the context of the message that invoked Hawking.

The data stored is broken into two groups, detailed and anonymized data. Detailed data contains information that ties the message content to a specific user, in a specific channel, inside a specific guild. Anonymized data has none of that, just the anonymized content of the message. See the tables below for the exact message data stored for each.

### Detailed Data
When Hawking is invoked, the following attributes from the message are stored:
| Attribute           | Explanation                                                                  | Example |
| ------------------- | ---------------------------------------------------------------------------- | ------- |
| User ID             | The ID of the user who invoked Hawking                                       | 334894709292007424
| Username            | The name of the user who invoked Hawking                                     | Stephen
| Text Channel ID     | The ID of the text channel that Hawking was invoked in                       | 769086384580853770
| Text Channel Name   | The name of the text channel that Hawking was invoked in                     | general
| Voice Channel ID    | The ID of the voice channel that Hawking will (attempt to) join              | 697856016389505035
| Voice Channel Name  | The name of the voice channel that Hawking  will (attempt to) join           | Hawking's Hovel
| Guild ID            | The ID of the guild that Hawking was invoked in                              | 521474080340180998
| Guild Name          | The name of the guild that Hawking was invoked in                            | Nick's Bots
| Qualified Command   | The name of the invoked command, with any parent or group commands prepended | say
| Command Name        | The name of the command itself                                               | say
| Query               | An approximation of the command invoked by the user, as the user would've typed it in. This has the same content as what the user typed in, but parameters may not be in the same order. | /say text:Hey, did you see the new Hawking update? user:<@Stephen>
| Is App Command?     | Was the invoked command an app command (slash command)?                      | True
| Timestamp           | The time that the message that invoked Hawking was created                   | 1645156527246

Note that the detailed data that Hawking stores can be verified [here](https://github.com/naschorr/hawking/blob/master/code/common/database/models/detailed_item.py) on the master branch, and always supercedes the above list in the event of any differences. Also note that additional fields that generated by Hawking are stored alongside the detailed user data.

### Anonymized Data
When Hawking is invoked, the following attributes from the message are stored:
| Attribute         | Explanation                                                                  | Example |
| ----------------- | -----------------------------------------------------------------------------| ------- |
| Qualified Command | The name of the invoked command, with any parent or group commands prepended | say
| Command Name      | The name of the command itself                                               | say
| Query             | An approximation of the command invoked by the user, as the user would've typed it in. This has the same content as what the user typed in, but parameters may not be in the same order. Note that any `@mentions` or `#channels` will be anonymized. | /say text:Hey, did you see the new Hawking update? user:<@user0>
| Is App Command?   | Was the invoked command an app command (slash command)?                      | True
| Timestamp         | The time that the message that invoked Hawking was created                   | 1645156527246

Note that the anonymous data that Hawking stores can be verified [here](https://github.com/naschorr/hawking/blob/master/code/common/database/models/anonymous_item.py) on the master branch, and always supercedes the above list in the event of any differences. Also note that additional fields that generated by Hawking are stored alongside the anonymized user data.

### Log Data
Detailed data is also stored briefly on the cloud server that runs Hawking in the form of log files. Logs are rotated every day, and only a week of logs is kept at any given time.

## Deleting Detailed Data
Users are able to have their own detailed data be deleted upon request, or it will happen automatically a year after their data was inserted into the database.

### User Controlled Data Deletion
Users can invoke the `@Hawking delete_my_data` command at any time. This will queue up the user's detailed data for deletion, which happens in a batch process once a week. Users will not be notified that their data has been deleted, however the bot will tell them when to expect that their detailed data will be deleted.

### Automatic Data Deletion
Detailed data will automatically be deleted one year after entry into the database.

## Data Access

### Where Data is Stored
Detailed and Anonymous user data stays in my secured database running on AWS (DynamoDB). Similarly, log data stays in my secured cloud server running on AWS (EC2). Both are only accessible to me, the developer.

### Unauthorized Data Access
In the event that an unauthorized person gains access to Hawking data, a notice will be posted in this repository, and linked to from this paragraph.

## How Data is Used

### Detailed Data
Detailed data is kept for a year at most, and is intended to help with troubleshooting and debugging issues. Being able to reference specific users, channels, guilds, as well as their message content and timestamp data is exceptionally useful in determining what, when, how, and why a specific error has occurred.

### Anonymized Data
Anonymous data is kept indefinitely for general analytics. It's very useful to know how users interact with Hawking over time, and as such anonymized message and timestamp data is essential.

## Data Sharing
There isn't **any** data sharing whatsoever. No third parties have been allowed access to any of it.

## TL;DR from the developer
I'm not a lawyer or a business man, and Hawking isn't intended to be some silicon valley venture capital scheme to get rich quick. It's just a fun side project that started as a joke, and turned into something bigger than I expected.

I use the same Hawking that you do, and I don't want my data to be used in sketchy ways, so by proxy (and ethically), your data isn't being used in sketchy ways. If you've got any questions, feel free to ask them in my [Discord server](https://discord.gg/JJqx8C4). Remember that you can have your identifying data removed from the database at any time by invoking the `@Hawking delete_my_data` command.
