---
layout: error-code
title: '5101'
ename: SSL - LetsEncrypt Challenge Invalid
---

## The Issue
LetsEncrypt cannot validate the provided domain.

## Possible Causes
- The domain you're trying to use isn't pointed to your app's IP. <a class="jump" href="#domain-isn-39-t-pointed-to-your-app-ip">JUMP</a>
- The domain provided for the certificate is not a valid domain. <a class="jump" href="#invalid-domain">JUMP</a>

## Domain Isn't Pointed to Your App IP
LetsEncrypt requires that your domain be pointed to the server on which the certificate is being installed in order to validate domain ownership. If your domain isn't pointed to your app yet, LetsEncrypt won't be able to validate the domain and issue the certificate.

### Steps to Take

#### Cancel the Sequence
While Nanobox will continue to hit the LetsEncrypt API, there's a chance the domain status will not change. The best thing to do is to cancel the process. To cancel a process, click the "Cancel" button in the upper-right corner of the process viewer.

![Cancel a Process](process-cancel.png)

#### Point Your Domain to Your App
Make sure your domain is pointed to your app. For the provided app-name.gonano.io domains, this is done automatically, but if you're using your own custom domain, instructions are provided in the [Using Custom Domains](/domains-networking/custom-domains/) doc.

Keep in mind that changes to your domain do take time to propagate. To keep propagation times down, turn down your domain's "Time to Live" (TTL) before updates.

#### Try it Again
Once your domain is routing to your live app, try to create the LetsEncrypt bundle again and it should succeed.

## Invalid Domain
LetsEncrypt doesn't recognize the domain you provided when creating your SSL/TLS certificate as a valid domain.

### Steps to Take

#### Cancel the Sequence
The information provided for your certificate will not work and you need to cancel the currently running process. To cancel a process, click the "Cancel" button in the upper-right corner of the process viewer.

![Cancel a Process](process-cancel.png)

#### Delete the Erred Certificate
Once a certificate is created, the domain associated with that certificate can't be changed. You need to delete the certificate and create a new one. To delete the certificate, click on "Manage" next to your certificate, then click the "Delete" button.

#### Create a New Certificate
Create a new certificate using a valid domain.
