---
layout: error-code
title: '5000'
ename: SSL Error
---

## The Issue
There was an error when trying to install your SSL certificate.

## Possible Causes
- You're using a third-party certificate and the key and certificate provided do not match.

## Steps to Take

### Cancel the Process
With SSL errors, you will need to cancel the process. To cancel a process, click the "Cancel" button in the upper-right corner of the process viewer.

![Cancel a Process](process-cancel.png)

### Check to Make Sure Your Key & Certificate Match
In order for the SSL to validate correctly, the certificate must match the private key. SSL shopper has instructions on how to check if your certificate matches your private key as well as an online key-checker [here](https://www.sslshopper.com/certificate-key-matcher.html).

### Make the Necessary Update to Your SSL Bundle
If the key and certificate do not match, update your certificate bundle with the correct matching key and certificate.

### Restart the Process
Save your updated bundle and attempt the same process you attempted before.
