---
title: Contributing
description: Contributing to the Nanobox documentation and other Nanobox projects is simple. There are just a few guidelines.
---

Nanobox manages a [collection of open-source projects](https://github.com/nanobox-io/) to which you're welcome to contribute. Any contributions to Nanobox projects should follow the following process and guidelines.

## Contribution Process

1. Fork, then clone the project.

    ```bash
    git clone git@github.com:your-username/project-name.git
    ```

2. Create your feature branch.

    ```bash
    git checkout -b my-new-feature
    ```

3. Commit your changes. ***If you have multiple commits, squash merge them into a single commit (great tutorial [here](https://ariejan.net/2011/07/05/git-squash-your-latests-commits-into-one/))***.

    ```bash
    git commit -am 'Added some feature'
    ```

5. Push to the feature branch.

    ```bash
    git push origin my-new-feature
    ```

6. Create new pull request

## Contribution Guidelines
Pull requests must do the following in order to be merged.

1. Match the style of code already existing in the project.
2. Must not contain any merge conflicts *(Pull and merge master before submitting the pull request)*.
3. Include tests for the modifications in your commit.
