---
title: Runtime & Services
seo_title: Configure Runtimes, Services, & Components with the boxfile.yml
description: Your app's runtime and supporting services are all configured in your boxfile.yml.
---

Your app's runtime and services are all configured in your `boxfile.yml`. For the deep dive into all the configuration options available, view the [boxfile.yml documentation](/boxfile/).

## Web & Worker Configuration
Code components (webs & workers) use the runtime generated by your [engine](/boxfile/run-config/#engine). Every engine exposes different runtime configuration options which should be documented in each engine. Official Nanobox engines and available config options are provided in the [Nanobox Language Guides](https://guides.nanobox.io).

Configuration options are available to webs and workers that are not part of the built runtime. These are documented in the following docs:

[Web Config Options](/boxfile/web/)  
[Worker Config Options](/boxfile/worker/)  

## Data Component Configuration
Data components are configured using their [image](/images/). Each image exposes different configuration options available in the boxfile.yml which should be documented in the image. Official Nanobox images and available configuration options are available in the [Nanobox Service Guides](https://guides.nanobox.io/#services).

[Data Component Config Options](/boxfile/data/)
