---
language: swift
exerciseType: 1
---

# --description--

Le variabili sono contenitori per la memorizzazione di valori (dati).
Ogni variabile in Swift è un oggetto.
Per creare una variabile, possiamo darle un **nome** tenendo presente che non deve contenere spazi.
Una variabile viene create nel momento in cui le si assegna per la prima volta un valore.
Con Swift dichiariamo le costanti con la parola chiave `let` e le variabili con la parola chiave `var`.
Il valore di una costante non può essere cambiato dopo che viene impostato, mentre una variabile può essere impostata con un valore diverso in futuro
Un esempio di creazione di una variabile denominata `x` è:
```swift
var x = 1
```
In questo modo, abbiamo assegnato il valore `1` alla variabile chiamata `x`.
Se stampiamo la variabile `x` otteniamo il numero `1`:
```swift
>>> print(x)
1
```

# --instructions--

Assegna alla variabile `y` il valore `2`

# --before-asserts--

```swift
import Foundation
import XCTest

class CodigoTests: XCTestCase {
```

# --asserts--

`y` deve essere uguale a `2`.

```swift
    func test1() {
        XCTAssertEqual(y, 2, "--err-t1--")
    }
```

# --after-asserts--

```swift
}

extension CodigoTests {
    static var allTests : [(String, (CodigoTests) -> () throws -> Void)] {
        return [
            ("test1", test1),
        ]
    }
}

XCTMain([testCase(CodigoTests.allTests)])
```

# --solutions--

```swift
var y = 2
```

