---
language: swift
exerciseType: 2
---

# --description--

Un _parametro variadico_ accetta zero o più valori di un tipo specifico.
Per aggiungere un parametro variadico usiamo `...` dopo il nome del tipo di parametro.
I valori passati ad un parametro variadico sono resi disponibili all'interno del corpo della funzione come array del tipo appropriato.
Per esempio, un parametro variadico con il nome `numeri` e un tipo `Double...` viene reso disponibile all'interno del corpo della funzione come un array costante chiamato `numeri` di tipo `[Double]`

# --instructions--

Completa il codice in modo da calcolare la media per la seguente lista di numeri `1, 4, 6, 7, 9`

# --seed--

```swift
func media(_ numeri: [/][/]) -> Double {
    let totale: Double = numeri.reduce(0, +)
    [/] totale / Double(numeri.count)
}
print(media[/]1, 4, 6, 7, 9[/])
```

# --answers--

- Double
- "Double"
- double
- ...
- ..<
- (
- )
- return

# --solutions--

```swift
func media(_ numeri: Double...) -> Double {
    let totale: Double = numeri.reduce(0, +)
    return totale / Double(numeri.count)
}
print(media(1, 4, 6, 7, 9))
```

# --output--

5.4
