---
language: swift
exerciseType: 2
---

# --description--

In Swift abbiamo anche il ciclo `forEach`.
In effetti, il `forEach` richiama la suddetta closure su ogni elemento della sequenza nello stesso ordine di un ciclo `for..in`
```swift
// questo è un array, lo vedremo presto
let numeri: [Int] = [1, 3, 5, 7, 9] 
numeri.forEach { num in 
    print(num)
}
```
Il metodo `forEach` è diverso dal ciclo `for..in` in due modi importanti:
1. Le istruzioni `break` o `continue` non possono essere utilizzati per uscire o saltare le chiamate della closure.
2. L'utilizzo della dichiarazione di `return` nella closure del corpo uscirà solo dalla closure e non dallo scopo esterno, inoltre non salterà le chiamate successive.

# --instructions--

Completa il codice in modo da stampare i seguenti numeri `(3, 24, 9, 12, 18)` utilizzando il ciclo di `forEach`

# --seed--

```swift
let numeri: [Int] = [3, 24, 9, 12, 18]
[/].[/] { [/] in
    print(num)
}
```

# --answers--

- for
- numeri
- forEach
- num

# --solutions--

```swift
let numeri: [Int] = [3, 24, 9, 12, 18]
numeri.forEach { num in
    print(num)
}
```

# --output--

3
24
9
12
18
