---
language: swift
exerciseType: 2
---

# --description--

Per alcune enumerazioni, e' utile avere una raccolta di tutti i casi di tale enumerazione.
Per abilitarlo bisogna aggiungere `: CaseIterable" dopo il nome dell'enumerazione.
Swift espone una raccolta di tutti i casi con la proprietà `allCases`:
```swift
enum Colori: CaseIterable {
    case blue, rosso, verde
}
for colore in Colori.allCases {
    print(colore)
}
// stampa blue, rosso, verde
```

# --instructions--

Itera l'enumerazione per stampare ogni caso.
`$0` è una forma breve che può essere usata per riferirsi ai valori degli argomenti della closure.
`$0` si riferisce al primo argomento della prima closure, `$1` al secondo argomento, e cosi' via

# --seed--

```swift
enum Settimana: [/] {
    case lunedi, martedi, mercoledi, giovedi, venerdi, sabato, domenica
}
Settimana.[/].forEach { print($0) }
```

# --answers--

- CaseIterable
- caseIterable
- allCases
- AllCases
- all
- cases

# --solutions--

```swift
enum Settimana: CaseIterable {
    case lunedi, martedi, mercoledi, giovedi, venerdi, sabato, domenica
}
Settimana.allCases.forEach { print($0) }
```

# --output--

lunedi
martedi
mercoledi
giovedi
venerdi
sabato
domenica
