---
language: swift
exerciseType: 2
---

# --description--

Possiamo abbinare i singoli valori dell'enumerazione con una dichiarazione `switch`:
```swift
let colori = Colori.red
switch colori {
    case .blu:
        print("Blu")
    case .rosso:
        print("Rosso")
    case .verde:
        print("Verde")
}
// stampa "Rosso"
```
Tieni presente che se non vuoi fornire un `case` per ogni caso di enumerazione, puoi fornire un `default` case per coprire tutti i casi che non sono stati affrontati esplicitamente

# --instructions--

Completa l'istruzione di `switch` in modo da ricoprire tutti i casi

# --seed--

```swift
let giorno = Settimana.lunedi
[/][/] {
    case .sabato, .[/]:
        print("Week-end")
    [/]:
        print("Lavoro")
}
```

# --answers--

- switch 
- giorno
- domenica
- default

# --solutions--

```swift
let giorno = Settimana.lunedi
switch giorno {
    case .sabato, .domenica:
        print("Week-end")
    default:
        print("Lavoro")
}
```

# --output--

Lavoro
