---
language: swift
exerciseType: 2
---

# --description--

L'operatore ternario è un operatore condizionale speciale costituito da tre parti, e prende la forma di `domanda ? risposta1 : risposta2`.
È una scorciatoia che permette di valutare una delle due espressioni in base al fatto che la `domanda` sia vera o falsa.
Se `domanda` è vera, valuta `risposta1` e ne restituisce il suo valore; altrimenti, valuta `risposta2` e ne restituisce il suo valore.
```swift
let a = 10, b = 20, c: Int
if (a < b) {
    c = a
} else {
    c = b
}
print(c)
```
La versione abbreviata del codice di sopra è:
```swift
let a = 10, b = 20, c: Int
c = a < b ? a : b
print(c)
```
`c` viene impostato uguale ad `a`, perchè la condizione `a < b` è vera

# --instructions--

Crea un valido operatore ternario stampando `"Mattina"` se `orario` è minore di `12`, altrimenti stampa `"Pomeriggio"`

# --seed--

```swift
var orario = 15
orario < 12 [/] print("Mattina") [/] print("Pomeriggio")
```

# --answers--

- if
- ==
- =
- else
- ?
- :

# --solutions--

```swift
var orario = 15
orario < 12 ? print("Mattina") : print("Pomeriggio")
```

# --output--

Pomeriggio
