---
language: swift
exerciseType: 2
---

# --description--

Le strutture e le classi di Swift hanno molte cose in comune. Entrambe possono:
- Definire le proprietà per memorizzare i valori
- Definire i metodi per fornire funzionalità
- Definire i subscript per fornire l'accesso ai loro valori utilizzando la sintassi dei subscript
- Definire gli inizializzatori per impostare il loro stato iniziale
- Essere esteso per espandere le loro funzionalità al di là di un'implementazione predefinita
- Conformarsi ai protocolli per fornire funzionalità standard di un certo tipo

Ma le classi hanno capacità aggiuntive che le strutture non hanno:
- L'ereditarietà permette ad una classe di ereditare le caratteristiche di un'altra
- Il Type casting consente di controllare e interpretare il tipo di istanza di classe durante il runtime
- I deinizializzatori consentono ad un'istanza di una classe di liberare le risorse che ha assegnato
- Il conteggio dei riferimenti permette più di un riferimento ad un'istanza di classe

# --instructions--

Utilizzando l'ereditarietà crea una classe `Cane` che eredita la classe `Animale`

# --seed--

```swift
class Animale {
    var genere: String?
    var zampe = 4
    func descrizione() {
        if let genere = self.genere { print(genere) }
        print(self.zampe)
    }
}
[/][/]: [/] {
    func verso() {
        print("Bau Bau!!")
    }
}
let Cane = [/][/]
Cane.genere = "femmina"
Cane.description()
Cane.verso()
```

# --answers--

- class 
- Cane
- Animale
- Cane
- ()
- Cane[]

# --solutions--

```swift
class Animale {
    var genere: String?
    var zampe = 4
    func descrizione() {
        if let genere = self.genere { print(genere) }
        print(self.zampe)
    }
}
class Cane: Animale {
    func verso() {
        print("Bau Bau!!")
    }
}
let Cane = Cane()
Cane.genere = "femmina"
Cane.description()
Cane.verso()
```

# --output--

femmina
4
Bau Bau!!
