---
language: python
exerciseType: 2
---

# --description--

Spesso in programmazione, e' necessario ripetere un blocco di codice, ad esempio:
```python
print("2 secondi")
print("3 secondi")
print("4 secondi")
print("5 secondi")
```
Questo produce il seguente output:
```python
2 secondi
3 secondi
4 secondi
5 secondi
```
Ovviamente, per lunghe dichiarazioni passeremmo molto tempo a scrivere il codice, ma fortunatamente possiamo usare i cicli.
Usiamo il ciclo `while`, in modo da ottenene lo stesso output di sopra.
```python
contatore = 2
while (contatore <= 5):
    print(f"{contatore} secondi")
    contatore += 1
```
Quindi abbiamo creato una variabile `contatore` assegnandole `2`, il valore iniziale.
Poi abbiamo usato la parola chiave `while` che eseguirà il blocco di codice finche' la condizione `contatore <= 5` e' `True`.
All'interno del blocco di codice, **NON** dovremo dimenticare la linea di codice `contatore += 1`.
In quanto incrementa il valore del `contatore`, altrimenti il nostro ciclo sarà infinito

# --instructions--

Riempire gli spazi vuoti con il ciclo `while` per ripetere il blocco di codice

# --seed--

```python
[/] True:
    print("ripeti")
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```python
while True:
    print("ripeti")
```

# --output--

ripeti
ripeti
ripeti
ripeti
...
