---
language: python
exerciseType: 1
---

# --description--

Le variabili sono contenitori per la memorizzazione di valori (dati).
Ogni variabile in Python e' un oggetto e, diversamente da altri linguaggi di programmazione, Python non ha alcun comando per dichiarare una variabile.
Per creare una variabile, dobbiamo darle un **nome** tenendo presente che non deve contenere spazi.
Viene creata una variabile nel momento in cui le si assegna per la prima volta un valore.
Un esempio di creazione di una variabile denominata `x` e':
```python
x = 1
```
In questo modo, abbiamo assegnato il valore `1` alla variabile chiamata `x`.
Se stampiamo la variabile `x` otteniamo il numero `1`:
```python
>>> print(x)
1
```

# --instructions--

Assegna alla variabile `y` il valore `2`.

# --before-asserts--

```python
import unittest

class CodigoTests(unittest.TestCase):
```

# --asserts--

`y` deve essere uguale a `2`.

```python
    def test_1(self):
        self.assertEqual(y, 2, "--err-t1--")
```

# --after-asserts--

```python
if __name__ == "__main__":
    unittest.main()
```

# --solutions--

```python
y = 2
```

