---
language: kotlin
exerciseType: 2
---

# --description--

Il ciclo _while_ supporta le tre espressioni di salto strutturale:
- `break` termina il ciclo più vicino.
- `continue` procede al passo successivo del ciclo più vicino.
- `return` di default ritorna alla funzione più vicina o ad una funzione anonima (_la vedremo più avanti quando parleremo delle funzioni_).

Ecco un esempio dell'uso di `continue` all'interno di un ciclo _while_:
```kotlin
var i = 0
while (i < 3) {
  i++
  if (i == 2) continue // [1]
  println(i)
}
// stampa 1, 3
```

Come puoi vedere in __[1]__ quando `i` è uguale a _2_, saltiamo e _continuiamo_ al passo successivo. Infatti il numero 2 non viene mai stampato.

# --instructions--

Riempi gli spazi vuoti con il ciclo `while` e salta quando `n` è _pari_.

# --seed--

```kotlin
var n = 0
[/] {
  n++
  if (n[/]2[/]0) [/]
  println(n)
} [/] (n < 10)
```

# --answers--

-  % 
-  // 
-  / 
-  == 
-  != 
- break
- continue
- while
- do
- do-while
- until


# --solutions--

```kotlin
var n = 0
do {
  n++
  if (n % 2 == 0) continue
  println(n)
} while (n < 10)
```

# --output--

1
3
5
7
9
