---
language: kotlin
exerciseType: 2
---

# --description--

C'è un secondo modo di usare _while_, in congiunzione con la parola chiave `do`.
```kotlin
do {
  // Codice da ripetere
} while (espressione-booleana)
```
Come puoi vedere il `do-while` è abbastanza simile al ciclo `while`, tranne che per una differenza importante:
> Il corpo del ciclo viene eseguito una volta prima che la condizione venga valutata.

In altre parole, il corpo del `do-while` viene sempre eseguito almeno una volta, anche se l'espressione della condizione inizialmente produce `false`.

Al contrario, il corpo di un ciclo `while` non verrà mai eseguito se la condizione produce `false` la prima volta.

# --instructions--

Riempi gli spazi vuoti con il ciclo `do-while` per ripetere il blocco di codice al fine di stampare i primi 10 multipli di _3_.

# --seed--

```kotlin
var contatore = 1
do {
    println([/] * 3)
    contatore[/]
} while (contatore[/]10)
```

# --answers--

- while
- "while"
- contatore
- loop
-  <= 
-  < 
- for
-  * 
-  ** 
- ++


# --solutions--

```kotlin
var contatore = 1
do {
    println(contatore * 3)
    contatore++
} while (contatore <= 10)
```

# --output--

3
6
9
12
15
18
21
24
27
30
