---
language: kotlin
exerciseType: 2
---

# --description--

> I computer sono ideali per compiti ripetitivi.

La forma più elementare di ripetizione usa la parola chiave `while`.
Questa ripete un blocco finché l'_espressione booleana_ di controllo è vera:

```kotlin
while (espressione-booleana) {
  // Codice da ripetere
}
```
L'espressione booleana viene valutata una volta all'inizio del ciclo e
di nuovo prima di ogni ulteriore iterazione attraverso il blocco.

```kotlin
var x = 3
while (x > 0) {
    println(x)
    x--
}
```
Qui abbiamo creato una variabile `x`, assegnandole il valore iniziale __3__.

Poi abbiamo usato l'istruzione `while` che eseguirà il blocco di codice finché la condizione `x > 0` è `true`.

All'interno del blocco di codice, **NON** dobbiamo dimenticare di aggiungere la linea `x--`.
Essa decrementa il valore di `x`, altrimenti il nostro ciclo sarà infinito.

# --instructions--

Riempi gli spazi vuoti con il ciclo `while` per ripetere il blocco di codice.

> Non preoccuparti se questo è un ciclo infinito

# --seed--

```kotlin
[/] (true) {
    println("ripeti")
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```kotlin
while (true) {
    println("ripeti")
}
```

# --output--

ripeti
ripeti
ripeti
ripeti
...
