---
language: kotlin
exerciseType: 1
---

# --description--

Le variabili sono contenitori per la memorizzazione di valori (dati).
Ogni variabile in Kotlin è un oggetto.
Per creare una variabile, possiamo darle un __nome__ tenendo presente che non deve contenere spazi.
Una variabile viene create nel momento in cui le si assegna per la prima volta un valore.
In Kotlin dichiariamo le costanti con la parola chiave `val` (abbreviazione di _valore_) e le
variabili con la parola chiave `var` (abbreviazione di _variabile_).
Il valore di una costante non può essere cambiato dopo che viene impostato, mentre una variabile può essere impostata con un valore diverso in futuro
Un esempio di creazione di una variabile denominata `x` è:
```kotlin
var x = 1
```
In questo modo, abbiamo assegnato il valore `1` alla variabile chiamata `x`.
Se stampiamo la variabile `x` otteniamo il numero `1`:
```kotlin
println(x) // stampa 1
```

# --instructions--

Assegna alla variabile `y` il valore `2`

# --before-seed--

```kotlin
// DO NOT EDIT FROM HERE
var _testFailedCount = 0;
var _testCount = 0;
fun tryCatch(assertion: Boolean) {
  _testCount++
    try { 
        if (!assertion) throw Exception()
    }
    catch (e: Throwable) {
        _testFailedCount++
        println("Test Case '--err-t$_testCount--' failed");
  }
};
// DO NOT EDIT UNTIL HERE
fun main() {
```

# --asserts--

`y` deve essere uguale a `2`.

```kotlin
    tryCatch(y == 2)
```

# --after-asserts--

```kotlin
// DO NOT EDIT FROM HERE 
    println("Executed $_testCount tests, with $_testFailedCount failures");
}
// DO NOT EDIT UNTIL HERE
```

# --solutions--

```kotlin
var y = 2
```
