---
language: kotlin
exerciseType: 2
---

# --description--

Ci sono due tipo di `Set` in Kotlin:

- Un `Set` non può essere modificato dopo essere stato creato
- Un `MutableSet` (set mutabile) può essere modificato dopo essere stato creato, quindi possiamo aggiungere, rimuovere o aggiornare i suoi elementi.

```kotlin
val numeri = setOf(1, 2, 3)
numeri.add(4) // [1]
```
__[1]__ genera un Errore in quanto il tipo `Set` è in _sola-lettura_.

Per creare un set modificabile dobbiamo usare la parola chiave `mutableSetOf`

```kotlin
val numeri = mutableSetOf(1, 2, 3)
numeri.add(4)
println(numeri)
// stampa [1, 2, 3, 4]
```

# --instructions--

Completa il codice in modo da creare un valido set modificabile

# --seed--

```kotlin
val [/] = [/]<String>[/]"mela", "banana"[/]
frutti.add("mango")
println(frutti)
```

# --answers--

- frutti
- "frutti"
- [
- ]
- (
- )
- listOf
- setOf
- mutableListOf
- mutableSetOf

# --solutions--

```kotlin
val frutti = mutableSetOf<String>("mela", "banana")
frutti.add("mango")
println(frutti)
```

# --output--

[mela, banana, mango]
