---
language: kotlin
exerciseType: 2
---

# --description--

A volte si vuole accedere solo a una parte di una lista.
Considera il seguente codice:
```kotlin
val numeri = listOf(1, 2, 3, 4) // [1]
val fetta = numeri.slice(1..2) // [2]
println(fetta)
// stampa [2, 3]
```

__[1]__: per prima cosa abbiamo creato una lista in _sola-lettura_ chiamata `numeri`.
__[2]__: successivamente, abbiamo preso un sottoinsieme usando la funzione `slice` ed abbiamo salvato il valore nella variabile `fetta`.
In Kotlin possiamo includere l'indice finale usando `..`, mentre possiamo escluderlo usando `until`.

# --instructions--

Crea una valida lista chiamata `fetta` che contiene solo i due numeri centrali della lista `numeri`

# --seed--

```kotlin
val numeri = listOf(10, 5, 5, 5, 3, 2, 1, 0)
val fetta = [/].[/]([/][/][/])
println(fetta)
```

# --answers--

- numeri
- slice
-  until 
- 2
- :
- 3
- -1
- 6
- 3
- 5
- ...
- ..<

# --solutions--

```kotlin
val numeri = listOf(10, 5, 5, 5, 3, 2, 1, 0)
val fetta = numeri.slice(3 until 5)
println(fetta)
```

# --output--

[5, 3]
