---
language: kotlin
exerciseType: 2
---

# --description--

L'indice è in realtà un offset dal primo elemento. Per esempio, quando si scrive `list[2]` non si chiede il secondo elemento della lista, ma l'elemento che si trova a 2 posizioni di distanza dal primo elemento. Quindi `list[0]` è il primo elemento (offset zero), `list[1]` è il secondo elemento (offset 1), `list[2]` è il terzo elemento (offset 2) e così via.

L'indice di una lista può essere usato sia per accedere che per assegnare valori.
Abbiamo già visto come accedere a un indice di lista in questo modo:
```kotlin
val nomi = mutableListOf("Maria", "Michele", "Ivan", "Noemi"]
// stampa il valore "Maria"
println(nomi[0])
```
Ecco invece come funziona un'assegnazione:
```kotlin
val nomi = mutableListOf("Maria", "Michele", "Ivan", "Noemi")
// Assegna il nuovo valore "Jordan"
nomi[0] = "Jordan"
// Stmpa il valore "Jordan"
println(nomi[0])
```

# --instructions--

Completa il codice in modo da rimpiazzare l'elemento che al momento ha come valore `"Mia"` con il nome `"Sofia"`

# --seed--

```kotlin
val nomi = mutableListOf("Carlotta", "Mia", "Jessica", "Silvia")
[/][/][/]"Sofia"
println(nomi)
```

# --answers--

- [0]
- [1]
- [2]
- [3]
-  = 
- [4]
- nomi

# --solutions--

```kotlin
val nomi = mutableListOf("Carlotta", "Mia", "Jessica", "Silvia")
nomi[1] = "Sofia"
println(nomi)
```

# --output--

[Carlotta, Sofia, Jessica, Silvia]
