---
language: kotlin
exerciseType: 2
---

# --description--

Una lista è una collezione di elementi con uno specifico ordine.
Ci sono due tipi di liste in Kotlin:

- Una `List` non può essere modificata dopo essere stata creata.
- Una `MutableList` (lista mutabile) può essere modificata dopo essere stata creata, quindi possiamo aggiungere, rimuovere o aggiornare i suoi elementi.

```kotlin
val numeri = listOf(1, 3, 5)
numeri.add(7) // [1]
```
__[1]__ genera un Errore in quanto il tipo `List` è in _sola-lettura_.

Per creare una lista modificabile dobbiamo usare la parola chiave `mutableListOf`
```kotlin
val numeri = mutableListOf(1, 3, 5)
numeri.add(7)
println(numeri)
// stampa [1, 3, 5, 7]
```

# --instructions--

Completa il codice in modo da creare una valida lista modificabile

# --seed--

```kotlin
val [/] = [/]<String>[/]"mela", "banana"[/]
frutti.add("mango")
println(frutti)
```

# --answers--

- frutti
- "frutti"
- [
- ]
- (
- )
- listOf
- mutableListOf

# --solutions--

```kotlin
val frutti = mutableListOf<String>("mela", "banana")
frutti.add("mango")
println(frutti)
```

# --output--

[mela, banana, mango]
