---
language: kotlin
exerciseType: 2
---

# --description--

A volte è necessario cercare un elemento in una lista.
In Kotlin possiamo usare il metodo `indexOfFirst`:
```kotlin
val nomi = mutableListOf("Trevor", "Zac", "Glenn")
println(nomi.indexOfFirst { it == "Zac"})
// stampa 1
```

Il metodo `indexOfFirst` prende una funzione __predicato__ che verrà valutata per ogni elemento della lista finchè non è `true`, restituendo l'_indice_ dell'elemento.
Il codice di sopra stampa il primo indice della lista che corrisponde alla stringa `Zac`, in questo caso `1`.

Possiamo anche inserire elementi all'interno di una lista modificabile ad un indice specifico, utilizzando il metodo `add(index, element)`:

```kotlin
nomi.add(1, "Ali")
// stampa [Trevor, Ali, Zac, Glenn]
```
Questo codice inserisce `"Ali"` all'indice `1`, muovendo tutto ciò che è successivo a questo indice in giù di 1.

# --instructions--

- Usa il metodo `indexOfFirst` per stampare l'indice della parola `"cane"`
- Successivamente usando il metodo `add` aggiungere la parole `"orso"` come primo elemento della lista

# --seed--

```kotlin
val animali = mutableListOf("gatto", "scimmia", "cane")
println(animali.[/] { it == [/]})
animali.[/]([/], "orso")
println(animali)
```

# --answers--

- index
- indexOfFirst
- cane
- "cane"
- insert
- append
- add
- 0
- 1

# --solutions--

```kotlin
val animali = mutableListOf("gatto", "scimmia", "cane")
println(animali.indexOfFirst { it == "cane"})
animali.add(0, "orso")
println(animali)
```

# --output--

2
[orso, gatto, scimmia, cane]
